/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedDataBlock;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.util.CompressionUtils;

public class BigBedIterator
implements Iterator<BedFeature> {
    private static Logger log = Logger.getLogger(BigBedIterator.class);
    private RPChromosomeRegion selectionRegion;
    private boolean contained;
    private BPTree chromIDTree;
    private RPTree chromDataTree;
    private HashMap<Integer, String> chromosomeMap;
    List<BedFeature> features;
    int currentIdx = 0;
    CompressionUtils compressionUtils;

    public BigBedIterator(String path, BPTree chromIDTree, RPTree chromDataTree, RPChromosomeRegion selectionRegion, boolean contained, CompressionUtils compressionUtils) {
        if (selectionRegion == null) {
            throw new RuntimeException("Error: BigBedIterator selection region is null\n");
        }
        this.compressionUtils = compressionUtils;
        this.chromIDTree = chromIDTree;
        this.chromDataTree = chromDataTree;
        this.selectionRegion = selectionRegion;
        this.contained = contained;
        ArrayList<RPTreeLeafNodeItem> leafNodeItems = chromDataTree.getChromosomeDataHits(selectionRegion, contained);
        this.features = new ArrayList<BedFeature>(512 * leafNodeItems.size());
        SeekableStream fis = null;
        try {
            fis = BBFileReader.getStream(path);
            for (RPTreeLeafNodeItem item : leafNodeItems) {
                this.features.addAll(this.readBedDataBlock(item, fis));
            }
        }
        catch (IOException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error(e);
                }
            }
        }
    }

    public BigBedIterator() {
        this.features = Collections.emptyList();
    }

    @Override
    public boolean hasNext() {
        return this.currentIdx < this.features.size();
    }

    @Override
    public BedFeature next() {
        BedFeature retvalue = this.features.get(this.currentIdx);
        ++this.currentIdx;
        return retvalue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public boolean isContained() {
        return this.contained;
    }

    private List<BedFeature> readBedDataBlock(RPTreeLeafNodeItem leafHitItem, SeekableStream fis) {
        int startChromID = leafHitItem.getChromosomeBounds().getStartChromID();
        int endChromID = leafHitItem.getChromosomeBounds().getEndChromID();
        this.chromosomeMap = this.chromIDTree.getChromosomeIDMap(startChromID, endChromID);
        boolean isLowToHigh = this.chromDataTree.isIsLowToHigh();
        int uncompressBufSize = this.chromDataTree.getUncompressBuffSize();
        BigBedDataBlock bedDataBlock = new BigBedDataBlock(fis, leafHitItem, this.chromosomeMap, isLowToHigh, uncompressBufSize, this.compressionUtils);
        return bedDataBlock.getBedData(this.selectionRegion, this.contained);
    }
}

