/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.util.BasicInputParser;
import net.sf.samtools.util.CloserUtil;

class IlluminaTextIterator
implements Iterator<String[]> {
    private final int lane;
    private int currentTile = 0;
    private IlluminaFileMap files;
    private boolean treatGroupedDelimitersAsOne = true;
    private BasicInputParser parser;

    public IlluminaTextIterator(int lane, IlluminaFileMap files) {
        this.lane = lane;
        this.files = files;
        this.currentTile = (Integer)files.firstKey();
    }

    public IlluminaTextIterator(int lane, IlluminaFileMap files, boolean treatGroupedDelimitersAsOne) {
        this(lane, files);
        this.treatGroupedDelimitersAsOne = treatGroupedDelimitersAsOne;
        this.currentTile = (Integer)files.firstKey();
    }

    public void seekToTile(int oneBasedTileNumber) {
        CloserUtil.close(this.parser);
        this.currentTile = oneBasedTileNumber;
        this.initializeParser();
    }

    private void initializeParser() {
        List<File> fileSubset = this.files.getFilesStartingAt(this.currentTile);
        this.parser = new BasicInputParser(this.treatGroupedDelimitersAsOne, fileSubset.toArray(new File[fileSubset.size()]));
    }

    @Override
    public String[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (String[])this.parser.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by IlluminaTextIterator");
    }

    @Override
    public boolean hasNext() {
        if (this.parser == null) {
            this.initializeParser();
        }
        return this.parser.hasNext();
    }

    protected int getLane() {
        return this.lane;
    }

    public String getCurrentFilename() {
        if (this.parser == null) {
            this.initializeParser();
        }
        return this.parser.getFileName();
    }

    protected void validateLane(int lane) {
        if (lane != this.getLane()) {
            throw new PicardException("Lane number mismatch: " + lane + " != " + this.getLane());
        }
    }
}

