/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.genotyper;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.utils.classloader.GATKLiteUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public abstract class PerReadAlleleLikelihoodMap {
    public static final double INDEL_LIKELIHOOD_THRESH = 0.1;
    protected List<Allele> alleles;
    protected Map<GATKSAMRecord, Map<Allele, Double>> likelihoodReadMap;

    public abstract void performPerAlleleDownsampling(double var1, PrintStream var3);

    public abstract ReadBackedPileup createPerAlleleDownsampledBasePileup(ReadBackedPileup var1, double var2, PrintStream var4);

    public void add(GATKSAMRecord read, Allele a, Double likelihood) {
        Map<Object, Object> likelihoodMap;
        if (this.likelihoodReadMap.containsKey(read)) {
            likelihoodMap = this.likelihoodReadMap.get(read);
        } else {
            likelihoodMap = new HashMap();
            this.likelihoodReadMap.put(read, likelihoodMap);
        }
        likelihoodMap.put(a, likelihood);
        if (!this.alleles.contains(a)) {
            this.alleles.add(a);
        }
    }

    public int size() {
        return this.likelihoodReadMap.size();
    }

    public void add(PileupElement p, Allele a, Double likelihood) {
        this.add(p.getRead(), a, likelihood);
    }

    public boolean containsPileupElement(PileupElement p) {
        return this.likelihoodReadMap.containsKey(p.getRead());
    }

    public boolean isEmpty() {
        return this.likelihoodReadMap.isEmpty();
    }

    public Map<GATKSAMRecord, Map<Allele, Double>> getLikelihoodReadMap() {
        return this.likelihoodReadMap;
    }

    public void clear() {
        this.alleles.clear();
        this.likelihoodReadMap.clear();
    }

    public Set<GATKSAMRecord> getStoredElements() {
        return this.likelihoodReadMap.keySet();
    }

    public Collection<Map<Allele, Double>> getLikelihoodMapValues() {
        return this.likelihoodReadMap.values();
    }

    public int getNumberOfStoredElements() {
        return this.likelihoodReadMap.size();
    }

    public Map<Allele, Double> getLikelihoodsAssociatedWithPileupElement(PileupElement p) {
        if (!this.likelihoodReadMap.containsKey(p.getRead())) {
            return null;
        }
        return this.likelihoodReadMap.get(p.getRead());
    }

    public static Allele getMostLikelyAllele(Map<Allele, Double> alleleMap) {
        double maxLike = Double.NEGATIVE_INFINITY;
        double prevMaxLike = Double.NEGATIVE_INFINITY;
        Allele mostLikelyAllele = Allele.NO_CALL;
        for (Map.Entry<Allele, Double> el : alleleMap.entrySet()) {
            if (el.getValue() > maxLike) {
                prevMaxLike = maxLike;
                maxLike = el.getValue();
                mostLikelyAllele = el.getKey();
                continue;
            }
            if (!(el.getValue() > prevMaxLike)) continue;
            prevMaxLike = el.getValue();
        }
        return maxLike - prevMaxLike > 0.1 ? mostLikelyAllele : Allele.NO_CALL;
    }

    public static PerReadAlleleLikelihoodMap getBestAvailablePerReadAlleleLikelihoodMap() {
        Class PerReadAlleleLikelihoodMapClass = GATKLiteUtils.getProtectedClassIfAvailable(PerReadAlleleLikelihoodMap.class);
        try {
            Constructor constructor = PerReadAlleleLikelihoodMapClass.getDeclaredConstructor(null);
            constructor.setAccessible(true);
            return (PerReadAlleleLikelihoodMap)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Unable to create RecalibrationEngine class instance " + PerReadAlleleLikelihoodMapClass.getSimpleName());
        }
    }
}

