/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.sf.samtools.Cigar;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class Haplotype {
    protected final byte[] bases;
    protected final double[] quals;
    private GenomeLoc genomeLocation = null;
    private HashMap<String, double[]> readLikelihoodsPerSample = null;
    private HashMap<String, int[]> readCountsPerSample = null;
    private HashMap<Integer, VariantContext> eventMap = null;
    private boolean isRef = false;
    private Cigar cigar;
    private int alignmentStartHapwrtRef;
    public int leftBreakPoint = 0;
    public int rightBreakPoint = 0;

    public Haplotype(byte[] bases, int qual) {
        this.bases = (byte[])bases.clone();
        this.quals = new double[bases.length];
        Arrays.fill(this.quals, (double)qual);
    }

    public Haplotype(byte[] bases, double[] quals) {
        this.bases = (byte[])bases.clone();
        this.quals = (double[])quals.clone();
    }

    public Haplotype(byte[] bases) {
        this(bases, 0);
    }

    public Haplotype(byte[] bases, GenomeLoc loc) {
        this(bases);
        this.genomeLocation = loc;
    }

    public boolean equals(Object h) {
        return h instanceof Haplotype && Arrays.equals(this.bases, ((Haplotype)h).bases);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bases);
    }

    public void addReadLikelihoods(String sample, double[] readLikelihoods, int[] readCounts) {
        if (this.readLikelihoodsPerSample == null) {
            this.readLikelihoodsPerSample = new HashMap();
        }
        this.readLikelihoodsPerSample.put(sample, readLikelihoods);
        if (this.readCountsPerSample == null) {
            this.readCountsPerSample = new HashMap();
        }
        this.readCountsPerSample.put(sample, readCounts);
    }

    @Ensures(value={"result != null"})
    public double[] getReadLikelihoods(String sample) {
        return this.readLikelihoodsPerSample.get(sample);
    }

    @Ensures(value={"result != null"})
    public int[] getReadCounts(String sample) {
        return this.readCountsPerSample.get(sample);
    }

    public Set<String> getSampleKeySet() {
        return this.readLikelihoodsPerSample.keySet();
    }

    public HashMap<Integer, VariantContext> getEventMap() {
        return this.eventMap;
    }

    public void setEventMap(HashMap<Integer, VariantContext> eventMap) {
        this.eventMap = eventMap;
    }

    public boolean isReference() {
        return this.isRef;
    }

    public void setIsReference(boolean isRef) {
        this.isRef = isRef;
    }

    public double getQualitySum() {
        double s = 0.0;
        for (int k = 0; k < this.bases.length; ++k) {
            s += this.quals[k];
        }
        return s;
    }

    public String toString() {
        return new String(this.bases);
    }

    public double[] getQuals() {
        return (double[])this.quals.clone();
    }

    public byte[] getBases() {
        return (byte[])this.bases.clone();
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getStop();
    }

    public int getAlignmentStartHapwrtRef() {
        return this.alignmentStartHapwrtRef;
    }

    public void setAlignmentStartHapwrtRef(int alignmentStartHapwrtRef) {
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
    }

    public Cigar getCigar() {
        return this.cigar;
    }

    public void setCigar(Cigar cigar) {
        this.cigar = cigar;
    }

    @Requires(value={"refInsertLocation >= 0"})
    public Haplotype insertAllele(Allele refAllele, Allele altAllele, int refInsertLocation) {
        int haplotypeInsertLocation = ReadUtils.getReadCoordinateForReferenceCoordinate(this.alignmentStartHapwrtRef, this.cigar, refInsertLocation, ReadUtils.ClippingTail.RIGHT_TAIL, true);
        if (haplotypeInsertLocation == -1 || haplotypeInsertLocation + refAllele.length() >= this.bases.length) {
            return null;
        }
        byte[] newHaplotypeBases = new byte[]{};
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, ArrayUtils.subarray(this.bases, 0, haplotypeInsertLocation));
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, altAllele.getBases());
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, ArrayUtils.subarray(this.bases, haplotypeInsertLocation + refAllele.length(), this.bases.length));
        return new Haplotype(newHaplotypeBases);
    }

    public static LinkedHashMap<Allele, Haplotype> makeHaplotypeListFromAlleles(List<Allele> alleleList, int startPos, ReferenceContext ref, int haplotypeSize, int numPrefBases) {
        LinkedHashMap<Allele, Haplotype> haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
        Allele refAllele = null;
        for (Allele a : alleleList) {
            if (!a.isReference()) continue;
            refAllele = a;
            break;
        }
        if (refAllele == null) {
            throw new ReviewedStingException("BUG: no ref alleles in input to makeHaplotypeListfrom Alleles at loc: " + startPos);
        }
        byte[] refBases = ref.getBases();
        int startIdxInReference = 1 + startPos - numPrefBases - ref.getWindow().getStart();
        String basesBeforeVariant = new String(Arrays.copyOfRange(refBases, startIdxInReference, startIdxInReference + numPrefBases));
        int startAfter = Math.min(startIdxInReference + numPrefBases + refAllele.getBases().length - 1, refBases.length);
        String basesAfterVariant = new String(Arrays.copyOfRange(refBases, startAfter, refBases.length));
        int startLoc = ref.getWindow().getStart() + startIdxInReference;
        int stopLoc = startLoc + haplotypeSize - 1;
        GenomeLoc locus = ref.getGenomeLocParser().createGenomeLoc(ref.getLocus().getContig(), startLoc, stopLoc);
        for (Allele a : alleleList) {
            byte[] alleleBases = a.getBases();
            String haplotypeString = basesBeforeVariant + new String(Arrays.copyOfRange(alleleBases, 1, alleleBases.length)) + basesAfterVariant;
            haplotypeString = haplotypeString.substring(0, haplotypeSize);
            haplotypeMap.put(a, new Haplotype(haplotypeString.getBytes(), locus));
        }
        return haplotypeMap;
    }

    public static class HaplotypeBaseComparator
    implements Comparator<Haplotype>,
    Serializable {
        @Override
        public int compare(Haplotype hap1, Haplotype hap2) {
            byte[] arr1 = hap1.getBases();
            byte[] arr2 = hap2.getBases();
            int len = Math.min(arr1.length, arr2.length);
            for (int iii = 0; iii < len; ++iii) {
                int cmp = arr1[iii] - arr2[iii];
                if (cmp == 0) continue;
                return cmp;
            }
            return arr2.length - arr1.length;
        }
    }
}

