/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.exome.ExomeBlock;
import org.broad.igv.feature.exome.ExomeReferenceFrame;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

public class RulerPanel
extends JPanel {
    private static Logger log = Logger.getLogger(RulerPanel.class);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    private static Color grey1 = new Color(120, 120, 120);
    private static Color grey2 = new Color(200, 200, 200);
    private static Color gene1 = new Color(0, 0, 150, 150);
    private static Color gene2 = new Color(0, 150, 0, 150);
    boolean drawSpan = true;
    boolean drawEllipsis = false;
    private Font tickFont = FontManager.getFont(1, 9);
    private Font spanFont = FontManager.getFont(1, 12);
    private List<ClickLink> chromosomeRects = new ArrayList<ClickLink>();
    private List<MouseRect> mouseRects = new ArrayList<MouseRect>();
    private static Color dragColor = new Color(0.5f, 0.5f, 1.0f, 0.3f);
    private static Color zoomBoundColor = new Color(0.5f, 0.5f, 0.5f);
    boolean dragging = false;
    int dragStart;
    int dragEnd;
    public static final String WHOLE_GENOME_TOOLTIP = "<html>Click on a chromosome number to jump to that chromosome,<br>or click and drag to zoom in.";
    public static final String CHROM_TOOLTIP = "Click and drag to zoom in.";
    ReferenceFrame frame;

    public RulerPanel(ReferenceFrame frame) {
        this.frame = frame;
        this.init();
    }

    private boolean isWholeGenomeView() {
        return this.frame.getChrName().equals("All");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.render(g);
        if (this.dragging) {
            g.setColor(dragColor);
            int start = Math.min(this.dragStart, this.dragEnd);
            int w = Math.abs(this.dragEnd - this.dragStart);
            int height = this.getHeight();
            g.fillRect(start, 0, w, height);
            g.setColor(zoomBoundColor);
            g.drawLine(this.dragStart, 0, this.dragStart, height);
            g.drawLine(this.dragEnd, 0, this.dragEnd, height);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }

    private void render(Graphics g) {
        g.setColor(Color.black);
        if (this.isWholeGenomeView()) {
            this.drawChromosomeTicks(g);
        } else if (FrameManager.isExomeMode()) {
            ExomeReferenceFrame exomeFrame = (ExomeReferenceFrame)FrameManager.getDefaultFrame();
            this.drawExomeBlocks(g, exomeFrame);
            this.drawExomeGenes(g, exomeFrame);
            if (this.drawSpan) {
                this.drawSpan(g);
            }
        } else {
            this.drawTicks(g);
            if (this.drawSpan) {
                this.drawSpan(g);
            }
            if (this.drawEllipsis) {
                this.drawEllipsis(g);
            }
        }
    }

    private void drawSpan(Graphics g) {
        int w = this.getWidth();
        g.setFont(this.spanFont);
        int range = FrameManager.isExomeMode() ? (int)(this.frame.getEnd() - this.frame.getOrigin()) + 1 : (int)(this.frame.getScale() * (double)w) + 1;
        boolean scaleInKB = this.frame.getChrName().equals("All");
        TickSpacing ts = RulerPanel.findSpacing(range, scaleInKB);
        String rangeString = RulerPanel.formatNumber((double)range / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
        int strWidth = g.getFontMetrics().stringWidth(rangeString);
        int strHeight = g.getFontMetrics().getAscent();
        int strPosition = (w - strWidth) / 2;
        int lineY = this.getHeight() - 35 - strHeight / 2;
        g.drawLine(0, lineY, (w - strWidth) / 2 - 10, lineY);
        int[] arrowX = new int[]{0, 10, 10};
        int[] arrowY = new int[]{lineY, lineY + 3, lineY - 3};
        g.fillPolygon(arrowX, arrowY, arrowX.length);
        g.drawLine((w + strWidth) / 2 + 10, lineY, w, lineY);
        arrowX = new int[]{w, w - 10, w - 10};
        g.fillPolygon(arrowX, arrowY, arrowX.length);
        g.drawString(rangeString, strPosition, this.getHeight() - 35);
    }

    private void drawEllipsis(Graphics g) {
        double cytobandScale = (double)this.frame.getChromosomeLength() / (double)this.getWidth();
        double maxPixel = this.frame.getMaxPixel();
        int start = (int)(this.frame.getOrigin() / cytobandScale);
        int span = (int)((double)this.getWidth() * this.frame.getScale() / cytobandScale);
        int end = start + span;
        g.drawLine(start, 0, 0, this.getHeight());
        g.drawLine(end, 0, this.getWidth(), this.getHeight());
    }

    private void drawTicks(Graphics g) {
        int w = this.getWidth();
        if (w < 200) {
            return;
        }
        g.setFont(this.tickFont);
        boolean scaleInKB = this.frame.getChrName().equals("All");
        int range = (int)((double)w * this.frame.getScale());
        TickSpacing ts = RulerPanel.findSpacing(range, scaleInKB);
        double spacing = ts.getMajorTick();
        int nTick = (int)(this.frame.getOrigin() / spacing) - 1;
        int l = (int)((double)nTick * spacing);
        int x = this.frame.getScreenPosition(l - 1);
        while (x < this.getWidth()) {
            l = (int)((double)nTick * spacing);
            x = this.frame.getScreenPosition(l - 1);
            String chrPosition = RulerPanel.formatNumber((double)l / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
            int strWidth = g.getFontMetrics().stringWidth(chrPosition);
            int strPosition = x - strWidth / 2;
            int height = this.getHeight();
            if (nTick % 2 == 0) {
                g.drawString(chrPosition, strPosition, height - 15);
            }
            g.drawLine(x, height - 10, x, height - 2);
            ++nTick;
        }
    }

    private void drawChromosomeTicks(Graphics g) {
        Font chrFont = FontManager.getFont(10);
        this.setLayout(null);
        int locationUnit = 1000;
        g.setFont(chrFont);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome == null) {
            log.info("No genome found with id: " + genome.getId());
            PreferenceManager.getInstance().remove("DEFAULT_GENOME_KEY");
        }
        boolean even = true;
        long offset = 0L;
        this.chromosomeRects.clear();
        List<String> chrNames = genome.getLongChromosomeNames();
        if (chrNames == null) {
            log.info("No chromosomes found for genome: " + genome.getId());
            PreferenceManager.getInstance().remove("DEFAULT_GENOME_KEY");
        }
        if (chrNames.size() > 500) {
            return;
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        for (String chrName : chrNames) {
            Chromosome c = genome.getChromosome(chrName);
            if (c == null) {
                log.info("Chromosome '" + chrName + "' not found");
                continue;
            }
            int chrLength = c.getLength();
            double scale = this.frame.getScale();
            int gStart = genome.getGenomeCoordinate(chrName, 0);
            int x = (int)((double)gStart / scale);
            int dw = (int)((double)chrLength / ((double)locationUnit * scale));
            g.drawLine(x, this.getHeight() - 10, x, this.getHeight() - 2);
            if (dw > 5) {
                int center = x + dw / 2;
                String displayName = null;
                displayName = chrName.startsWith("gi|") ? Genome.getNCBIName(chrName) : chrName.replace("chr", "");
                int strWidth = fontMetrics.stringWidth(displayName);
                int strPosition = center - strWidth / 2;
                int y = even ? this.getHeight() - 35 : this.getHeight() - 25;
                g.drawString(displayName, strPosition, y);
                int sw = (int)fontMetrics.getStringBounds(displayName, g).getWidth();
                Rectangle clickRect = new Rectangle(strPosition, y - 15, sw, 15);
                String tooltipText = "Jump to chromosome: " + chrName;
                this.chromosomeRects.add(new ClickLink(clickRect, chrName, tooltipText));
                even = !even;
            }
            offset += (long)chrLength;
        }
    }

    private void drawExomeBlocks(Graphics g, ExomeReferenceFrame frame) {
        int pStart;
        String chr = frame.getChrName();
        List<ExomeBlock> blocks = frame.getBlocks(chr);
        int idx = frame.getFirstBlockIdx();
        Rectangle visibleRect = this.getVisibleRect();
        int lastPStart = -1;
        int exomeOrigin = frame.getExomeOrigin();
        int visibleBlockCount = 0;
        int blockGap = 0;
        int top = visibleRect.y + visibleRect.height - 10;
        do {
            ExomeBlock b = blocks.get(idx);
            pStart = (int)((double)(b.getExomeStart() - exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
            int pEnd = (int)((double)(b.getExomeEnd() - exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
            if (pEnd <= lastPStart) continue;
            lastPStart = pStart;
            if (pEnd == pStart) {
                ++pEnd;
            }
            b.setScreenBounds(pStart, pEnd);
            Rectangle rect = new Rectangle(pStart, top, pEnd - pStart, 10);
            Graphics2D exomeGraphics = (Graphics2D)g.create();
            Color c = idx % 2 == 0 ? grey1 : grey2;
            exomeGraphics.setColor(c);
            exomeGraphics.fill(rect);
            ++visibleBlockCount;
        } while (pStart < visibleRect.x + visibleRect.width && ++idx < blocks.size());
    }

    private void drawExomeGenes(Graphics g, ExomeReferenceFrame frame) {
        int pStart;
        this.mouseRects.clear();
        String chr = frame.getChrName();
        List<ExomeReferenceFrame.Gene> genes = frame.getGenes(chr);
        int idx = FeatureUtils.getIndexBefore(frame.getOrigin(), genes);
        Rectangle visibleRect = this.getVisibleRect();
        FontMetrics fm = g.getFontMetrics();
        int lastPStart = -1;
        int exomeOrigin = frame.getExomeOrigin();
        int visibleBlockCount = 0;
        int blockGap = 0;
        int top = visibleRect.y + visibleRect.height - 30;
        do {
            ExomeReferenceFrame.Gene gene = genes.get(idx);
            double exomeStart = frame.genomeToExomePosition(gene.getStart());
            double exomeEnd = frame.genomeToExomePosition(gene.getEnd());
            pStart = (int)((exomeStart - (double)exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
            int pEnd = (int)((exomeEnd - (double)exomeOrigin) / frame.getScale()) + visibleBlockCount * blockGap;
            if (pEnd <= lastPStart) continue;
            lastPStart = pStart;
            if (pEnd == pStart) {
                ++pEnd;
            }
            Rectangle rect = new Rectangle(pStart, top, pEnd - pStart, 20);
            Graphics2D exomeGraphics = (Graphics2D)g.create();
            Color c = idx % 2 == 0 ? gene1 : gene2;
            exomeGraphics.setColor(c);
            exomeGraphics.fill(rect);
            Rectangle2D sb = fm.getStringBounds(gene.getName(), g);
            if (sb.getWidth() < rect.getWidth()) {
                exomeGraphics.setColor(Color.black);
                GraphicUtils.drawCenteredText(gene.getName(), rect, exomeGraphics);
            }
            this.mouseRects.add(new MouseRect(rect, gene.getName()));
            ++visibleBlockCount;
        } while (pStart < visibleRect.x + visibleRect.width && ++idx < genes.size());
        Collections.sort(this.mouseRects, new Comparator<MouseRect>(){

            @Override
            public int compare(MouseRect mr1, MouseRect mr2) {
                return mr1.width() - mr2.width();
            }
        });
    }

    public static String formatNumber(double position) {
        return DECIMAL_FORMAT.format((int)position);
    }

    public static TickSpacing findSpacing(long maxValue, boolean scaleInKB) {
        if (maxValue < 10L) {
            return new TickSpacing(1.0, "bp", 1);
        }
        int nZeroes = (int)Math.log10(maxValue);
        String majorUnit = scaleInKB ? "kb" : "bp";
        int unitMultiplier = 1;
        if (nZeroes > 9) {
            majorUnit = scaleInKB ? "tb" : "gb";
            unitMultiplier = 1000000000;
        }
        if (nZeroes > 6) {
            majorUnit = scaleInKB ? "gb" : "mb";
            unitMultiplier = 1000000;
        } else if (nZeroes > 3) {
            majorUnit = scaleInKB ? "mb" : "kb";
            unitMultiplier = 1000;
        }
        double nMajorTicks = (double)maxValue / Math.pow(10.0, nZeroes - 1);
        if (nMajorTicks < 25.0) {
            return new TickSpacing(Math.pow(10.0, nZeroes - 1), majorUnit, unitMultiplier);
        }
        return new TickSpacing(Math.pow(10.0, nZeroes) / 2.0, majorUnit, unitMultiplier);
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(UIConstants.TRACK_BORDER_GRAY));
        this.setCursor(Cursor.getDefaultCursor());
        if (this.isWholeGenomeView()) {
            this.setToolTipText(WHOLE_GENOME_TOOLTIP);
        } else {
            this.setToolTipText("Click and drag to zoom");
        }
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent evt) {
                MouseEvent e = evt;
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    if (!RulerPanel.this.isWholeGenomeView()) {
                        double newLocation = RulerPanel.this.frame.getChromosomePosition(e.getX());
                        RulerPanel.this.frame.centerOnLocation(newLocation);
                    } else {
                        for (ClickLink link : RulerPanel.this.chromosomeRects) {
                            if (!link.region.contains(e.getPoint())) continue;
                            String chrName = link.value;
                            RulerPanel.this.frame.getEventBus().post(new ViewChange.ChromosomeChangeCause(RulerPanel.this, chrName));
                        }
                    }
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (RulerPanel.this.isWholeGenomeView()) {
                    for (ClickLink link : RulerPanel.this.chromosomeRects) {
                        if (!link.region.contains(e.getPoint())) continue;
                        RulerPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                        RulerPanel.this.setToolTipText(link.tooltipText);
                        return;
                    }
                    RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                } else {
                    for (MouseRect mr : RulerPanel.this.mouseRects) {
                        if (!mr.containsPoint(e.getPoint())) continue;
                        RulerPanel.this.setToolTipText(mr.getText());
                        return;
                    }
                    RulerPanel.this.setToolTipText(RulerPanel.CHROM_TOOLTIP);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RulerPanel.this.setCursor(Cursor.getDefaultCursor());
                if (RulerPanel.this.isWholeGenomeView()) {
                    RulerPanel.this.setToolTipText(RulerPanel.WHOLE_GENOME_TOOLTIP);
                } else {
                    RulerPanel.this.setToolTipText(RulerPanel.CHROM_TOOLTIP);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Math.abs(e.getPoint().getX() - (double)RulerPanel.this.dragStart) > 1.0) {
                    RulerPanel.this.dragEnd = e.getX();
                    RulerPanel.this.dragging = true;
                    RulerPanel.this.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RulerPanel.this.dragStart = e.getX();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (RulerPanel.this.dragging) {
                    RulerPanel.this.dragEnd = e.getX();
                    RulerPanel.this.dragging = false;
                    RulerPanel.this.zoom();
                }
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private void zoom() {
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public void run() {
                double s = RulerPanel.this.frame.getChromosomePosition(RulerPanel.this.dragStart);
                double e = RulerPanel.this.frame.getChromosomePosition(RulerPanel.this.dragEnd);
                if (e < s) {
                    double tmp = s;
                    s = e;
                    e = tmp;
                }
                if (e - s < 40.0) {
                    double c = (s + e) / 2.0;
                    s = c - 20.0;
                    e = c + 20.0;
                }
                s = Math.max(0.0, s);
                String chr = null;
                if (RulerPanel.this.isWholeGenomeView()) {
                    Genome genome = GenomeManager.getInstance().getCurrentGenome();
                    ChromosomeCoordinate start = genome.getChromosomeCoordinate((int)s);
                    ChromosomeCoordinate end = genome.getChromosomeCoordinate((int)e);
                    chr = start.getChr();
                    s = start.getCoordinate();
                    e = end.getCoordinate();
                    if (end.getChr() != start.getChr()) {
                        e = genome.getChromosome(start.getChr()).getLength();
                    }
                } else {
                    chr = RulerPanel.this.frame.getChrName();
                }
                RulerPanel.this.frame.jumpTo(chr, (int)Math.min(s, e), (int)Math.max(s, e));
                RulerPanel.this.frame.recordHistory();
            }

            @Override
            public String getName() {
                return "Rule panel zoom";
            }
        };
        LongRunningTask.submit(runnable);
    }

    static class MouseRect {
        Rectangle bounds;
        String text;

        MouseRect(Rectangle bounds, String text) {
            this.bounds = bounds;
            this.text = text;
        }

        boolean containsPoint(Point p) {
            return this.bounds.contains(p);
        }

        String getText() {
            return this.text;
        }

        public int width() {
            return this.bounds.width;
        }
    }

    class ClickLink {
        Rectangle region;
        String value;
        String tooltipText;

        ClickLink(Rectangle region, String value, String tooltipText) {
            this.region = region;
            this.value = value;
            this.tooltipText = tooltipText;
        }
    }

    public static class TickSpacing {
        private double majorTick;
        private double minorTick;
        private String majorUnit = "";
        private int unitMultiplier = 1;

        TickSpacing(double majorTick, String majorUnit, int unitMultiplier) {
            this.majorTick = majorTick;
            this.minorTick = majorTick / 10.0;
            this.majorUnit = majorUnit;
            this.unitMultiplier = unitMultiplier;
        }

        public double getMajorTick() {
            return this.majorTick;
        }

        public double getMinorTick() {
            return this.minorTick;
        }

        public String getMajorUnit() {
            return this.majorUnit;
        }

        public void setMajorUnit(String majorUnit) {
            this.majorUnit = majorUnit;
        }

        public int getUnitMultiplier() {
            return this.unitMultiplier;
        }

        public void setUnitMultiplier(int unitMultiplier) {
            this.unitMultiplier = unitMultiplier;
        }
    }
}

