/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.bbfile.BBFileReader;
import org.broad.igv.bigwig.BigWigDataSource;
import org.broad.igv.das.DASFeatureSource;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DatasetDataSource;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.data.WiggleParser;
import org.broad.igv.data.cufflinks.CufflinksCodec;
import org.broad.igv.data.cufflinks.CufflinksDataSource;
import org.broad.igv.data.cufflinks.CufflinksParser;
import org.broad.igv.data.cufflinks.CufflinksTrack;
import org.broad.igv.data.cufflinks.ExpDiffCodec;
import org.broad.igv.data.cufflinks.FPKMTrackingCodec;
import org.broad.igv.data.cufflinks.FPKMValue;
import org.broad.igv.data.expression.ExpressionDataset;
import org.broad.igv.data.expression.ExpressionFileParser;
import org.broad.igv.data.rnai.RNAIDataSource;
import org.broad.igv.data.rnai.RNAIGCTDatasetParser;
import org.broad.igv.data.rnai.RNAIGeneScoreParser;
import org.broad.igv.data.rnai.RNAIHairpinParser;
import org.broad.igv.data.seg.FreqData;
import org.broad.igv.data.seg.SegmentFileParser;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.data.seg.SegmentedBinaryDataSet;
import org.broad.igv.data.seg.SegmentedDataSet;
import org.broad.igv.data.seg.SegmentedDataSource;
import org.broad.igv.dev.SegmentedReader;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.SQLCodecSource;
import org.broad.igv.dev.db.SampleInfoSQLReader;
import org.broad.igv.dev.db.SegmentedSQLReader;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.CachingFeatureSource;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.GisticFileParser;
import org.broad.igv.feature.MutationTrackLoader;
import org.broad.igv.feature.dranger.DRangerParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.goby.GobyAlignmentQueryReader;
import org.broad.igv.goby.GobyCountArchiveDataSource;
import org.broad.igv.gwas.GWASData;
import org.broad.igv.gwas.GWASParser;
import org.broad.igv.gwas.GWASTrack;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.lists.VariantListManager;
import org.broad.igv.maf.MultipleAlignmentTrack;
import org.broad.igv.methyl.MethylTrack;
import org.broad.igv.peaks.PeakTrack;
import org.broad.igv.renderer.CosmicFeatureRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.renderer.MutationRenderer;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.EWigTrack;
import org.broad.igv.sam.SpliceJunctionFinderTrack;
import org.broad.igv.sam.reader.IndexNotFoundException;
import org.broad.igv.synteny.BlastMapping;
import org.broad.igv.synteny.BlastParser;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.CNFreqTrack;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureDirSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GFFFeatureSource;
import org.broad.igv.track.GisticTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.track.TribbleListFeatureSource;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.IndexCreatorDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.util.PedigreeUtils;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broadinstitute.variant.vcf.VCFHeader;

public class TrackLoader {
    private static Logger log = Logger.getLogger(TrackLoader.class);

    public List<Track> load(ResourceLocator locator, IGV igv) {
        Genome genome = igv != null ? GenomeManager.getInstance().getCurrentGenome() : null;
        return this.load(locator, genome);
    }

    public List<Track> load(ResourceLocator locator, Genome genome) {
        String path = locator.getPath();
        log.info("Loading resource, path " + path);
        try {
            String typeString = locator.getTypeString();
            if (typeString.endsWith(".tbi")) {
                MessageUtils.showMessage("<html><b>Error:</b>File type '.tbi' is not recognized.  If this is a 'tabix' index <br> load the associated gzipped file, which should have an extension of '.gz'");
            }
            ArrayList<Track> newTracks = new ArrayList<Track>();
            String dbUrl = locator.getDBUrl();
            if (dbUrl != null) {
                this.loadFromDatabase(locator, newTracks, genome);
            } else if (typeString.endsWith(".dbxml")) {
                this.loadFromDBProfile(locator, newTracks);
            } else if (typeString.endsWith(".gmt")) {
                this.loadGMT(locator);
            } else if (typeString.equals("das")) {
                this.loadDASResource(locator, newTracks);
            } else if (MutationTrackLoader.isMutationAnnotationFile(locator)) {
                this.loadMutFile(locator, newTracks, genome);
            } else if ((typeString.endsWith(".vcf3") || typeString.endsWith(".vcf4") || typeString.endsWith(".vcf")) && !HttpUtils.isRemoteURL(locator.getPath())) {
                if (!TrackLoader.isIndexed(path, genome)) {
                    File baseFile = new File(locator.getPath());
                    File newIdxFile = new File(locator.getPath() + ".idx");
                    IndexCreatorDialog dialog = IndexCreatorDialog.createShowDialog(IGV.getMainFrame(), baseFile, newIdxFile);
                    Object index = dialog.getIndex();
                    if (index == null) {
                        log.warn("No index created, loading cancelled");
                        return newTracks;
                    }
                }
                this.loadIndexed(locator, newTracks, genome);
            } else {
                if (this.VCFrequiresIndex(path) && !TrackLoader.isIndexed(path, genome)) {
                    throw new DataLoadException("Could not access required index file", path);
                }
                if (TrackLoader.isIndexed(path, genome)) {
                    this.loadIndexed(locator, newTracks, genome);
                } else if (typeString.endsWith(".vcf.list")) {
                    this.loadVCFListFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".trio")) {
                    this.loadTrioData(locator);
                } else if (typeString.endsWith("varlist")) {
                    VariantListManager.loadVariants(locator);
                } else if (typeString.endsWith("samplepathmap")) {
                    VariantListManager.loadSamplePathMap(locator);
                } else {
                    if (typeString.endsWith("h5") || typeString.endsWith("hbin")) {
                        throw new DataLoadException("HDF5 files are no longer supported", locator.getPath());
                    }
                    if (typeString.endsWith(".rnai.gct")) {
                        this.loadRnaiGctFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".gct") || typeString.endsWith("res") || typeString.endsWith("tab")) {
                        this.loadGctFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".cn") || typeString.endsWith(".xcn") || typeString.endsWith(".snp") || typeString.endsWith(".igv") || typeString.endsWith(".loh")) {
                        this.loadIGVFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".cbs") || typeString.endsWith(".seg") || typeString.endsWith("glad") || typeString.endsWith("birdseye_canary_calls") || typeString.endsWith(".seg.zip")) {
                        this.loadSegFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".gistic")) {
                        this.loadGisticFile(locator, newTracks);
                    } else if (typeString.endsWith(".gs")) {
                        this.loadRNAiGeneScoreFile(locator, newTracks, RNAIGeneScoreParser.Type.GENE_SCORE, genome);
                    } else if (typeString.endsWith(".riger")) {
                        this.loadRNAiGeneScoreFile(locator, newTracks, RNAIGeneScoreParser.Type.POOLED, genome);
                    } else if (typeString.endsWith(".hp")) {
                        this.loadRNAiHPScoreFile(locator);
                    } else if (typeString.endsWith("gene")) {
                        this.loadGeneFile(locator, newTracks, genome);
                    } else if (typeString.contains(".tabblastn") || typeString.endsWith(".orthologs")) {
                        this.loadSyntentyMapping(locator, newTracks);
                    } else if (typeString.endsWith(".sam") || typeString.endsWith(".bam") || typeString.endsWith(".sam.list") || typeString.endsWith(".bam.list") || typeString.endsWith("_sorted.txt") || typeString.endsWith(".aligned") || typeString.endsWith(".sai") || typeString.endsWith(".bai") || typeString.equals("alist")) {
                        this.loadAlignmentsTrack(locator, newTracks, genome);
                    } else if (typeString.endsWith(".wig") || typeString.endsWith(".bedgraph") || typeString.endsWith("cpg.txt") || typeString.endsWith(".expr")) {
                        this.loadWigFile(locator, newTracks, genome);
                    } else if (typeString.endsWith("fpkm_tracking") || typeString.endsWith("gene_exp.diff") || typeString.endsWith("cds_exp.diff")) {
                        this.loadCufflinksFile(locator, newTracks, genome);
                    } else if (typeString.contains(".dranger")) {
                        this.loadDRangerFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".ewig.tdf") || typeString.endsWith(".ewig.ibf")) {
                        this.loadEwigIBFFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".bw") || typeString.endsWith(".bb") || typeString.endsWith(".bigwig") || typeString.endsWith(".bigbed")) {
                        this.loadBWFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".ibf") || typeString.endsWith(".tdf")) {
                        this.loadTDFFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".counts")) {
                        this.loadGobyCountsArchive(locator, newTracks, genome);
                    } else if (GFFFeatureSource.isGFF(locator.getPath())) {
                        this.loadGFFfile(locator, newTracks, genome);
                    } else if (AbstractFeatureParser.canParse(locator.getPath())) {
                        this.loadFeatureFile(locator, newTracks, genome);
                    } else if (WiggleParser.isWiggle(locator)) {
                        this.loadWigFile(locator, newTracks, genome);
                    } else if (typeString.endsWith(".maf")) {
                        this.loadMultipleAlignmentTrack(locator, newTracks, genome);
                    } else if (typeString.endsWith(".maf.dict")) {
                        this.loadMultipleAlignmentTrack(locator, newTracks, genome);
                    } else if (typeString.contains(".peak.bin")) {
                        this.loadPeakTrack(locator, newTracks, genome);
                    } else if ("mage-tab".equals(typeString) || ExpressionFileParser.parsableMAGE_TAB(locator)) {
                        locator.setDescription("MAGE_TAB");
                        this.loadGctFile(locator, newTracks, genome);
                    } else if (GWASParser.isGWASFile(typeString)) {
                        this.loadGWASFile(locator, newTracks, genome);
                    } else if (GobyAlignmentQueryReader.supportsFileType(path)) {
                        this.loadAlignmentsTrack(locator, newTracks, genome);
                    } else if (typeString.endsWith(".list")) {
                        this.loadListFile(locator, newTracks, genome);
                    } else if (AttributeManager.isSampleInfoFile(locator)) {
                        AttributeManager.getInstance().loadSampleInfo(locator);
                    } else {
                        MessageUtils.showMessage("<html>Unknown file type: " + path + "<br>Check file extension");
                    }
                }
            }
            TrackProperties tp = null;
            String trackLine = locator.getTrackLine();
            if (trackLine != null) {
                tp = new TrackProperties();
                ParsingUtils.parseTrackLine(trackLine, tp);
            }
            for (Track track : newTracks) {
                if (locator.getFeatureInfoURL() != null) {
                    track.setUrl(locator.getFeatureInfoURL());
                }
                if (tp != null) {
                    track.setProperties(tp);
                }
                if (locator.getColor() != null) {
                    track.setColor(locator.getColor());
                }
                if (locator.getSampleId() == null) continue;
                track.setSampleId(locator.getSampleId());
            }
            return newTracks;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new DataLoadException(e.getMessage(), path);
        }
    }

    private boolean VCFrequiresIndex(String path) {
        String[] exts;
        String fn = TrackLoader.stripGZ(path);
        for (String ext : exts = new String[]{".vcf3", ".vcf4", ".vcf"}) {
            if (!fn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private void loadGMT(ResourceLocator locator) throws IOException {
        List<GeneList> lists = GeneListManager.getInstance().importGMTFile(locator.getPath());
        if (lists.size() == 1) {
            GeneList gl = lists.get(0);
            IGV.getInstance().setGeneList(gl, true);
        } else {
            MessageUtils.showMessage("Loaded " + lists.size() + " gene lists.");
        }
    }

    private void loadIndexed(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        TribbleFeatureSource src = GFFFeatureSource.isGFF(locator.getPath()) ? new GFFFeatureSource(locator.getPath(), genome) : new TribbleFeatureSource(locator.getPath(), genome);
        String typeString = locator.getPath();
        if (typeString.endsWith("vcf") || typeString.endsWith("vcf.gz") || typeString.endsWith("bcf")) {
            VCFHeader header = (VCFHeader)src.getHeader();
            boolean enableMethylationRateSupport = header.getFormatHeaderLine("MR") != null && header.getFormatHeaderLine("GB") != null;
            ArrayList<String> allSamples = new ArrayList<String>(header.getGenotypeSamples());
            VariantTrack t = new VariantTrack(locator, src, allSamples, enableMethylationRateSupport);
            t.setMargin(0);
            newTracks.add(t);
        } else {
            FeatureTrack t = new FeatureTrack(locator, src);
            t.setName(locator.getTrackName());
            Object header = src.getHeader();
            if (header != null && header instanceof FeatureFileHeader) {
                FeatureFileHeader ffh = (FeatureFileHeader)header;
                if (ffh.getTrackType() != null) {
                    t.setTrackType(ffh.getTrackType());
                }
                if (ffh.getTrackProperties() != null) {
                    t.setProperties(ffh.getTrackProperties());
                }
                if (ffh.getTrackType() == TrackType.REPMASK) {
                    t.setHeight(15);
                }
            }
            newTracks.add(t);
        }
    }

    private void loadVCFListFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        TribbleListFeatureSource src = new TribbleListFeatureSource(locator.getPath(), genome);
        VCFHeader header = (VCFHeader)src.getHeader();
        boolean enableMethylationRateSupport = header.getFormatHeaderLine("MR") != null && header.getFormatHeaderLine("GB") != null;
        ArrayList<String> allSamples = new ArrayList<String>(header.getGenotypeSamples());
        VariantTrack t = new VariantTrack(locator, src, allSamples, enableMethylationRateSupport);
        t.setMargin(0);
        newTracks.add(t);
    }

    private void loadGeneFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        FeatureParser featureParser = AbstractFeatureParser.getInstanceFor(locator, genome);
        if (featureParser != null) {
            List<FeatureTrack> tracks = featureParser.loadTracks(locator, genome);
            newTracks.addAll(tracks);
        }
    }

    private void loadSyntentyMapping(ResourceLocator locator, List<Track> newTracks) {
        List<BlastMapping> mappings = new BlastParser().parse(locator.getPath());
        ArrayList<BlastMapping> features = new ArrayList<BlastMapping>(mappings.size());
        features.addAll(mappings);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        FeatureTrack track = new FeatureTrack(locator, new FeatureCollectionSource(features, genome));
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadDRangerFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        DRangerParser parser = new DRangerParser();
        newTracks.addAll(parser.loadTracks(locator, genome));
    }

    private void loadGFFfile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        GFFParser featureParser = new GFFParser();
        List<FeatureTrack> tracks = featureParser.loadTracks(locator, genome);
        newTracks.addAll(tracks);
    }

    private void loadFeatureFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        if (locator.isLocal() && (locator.getPath().endsWith(".bed") || locator.getPath().endsWith(".bed.txt")) && !this.checkSize(locator.getPath())) {
            return;
        }
        FeatureCodec codec = CodecFactory.getCodec(locator.getPath(), genome);
        if (codec != null) {
            AbstractFeatureReader bfs = AbstractFeatureReader.getFeatureReader(locator.getPath(), codec, false);
            CloseableTribbleIterator<Feature> iter = bfs.iterator();
            Object header = bfs.getHeader();
            TrackProperties trackProperties = TrackLoader.getTrackProperties(header);
            List<FeatureTrack> tracks = AbstractFeatureParser.loadTracks(iter, locator, genome, trackProperties);
            if (locator.getPath().contains(".narrowPeak") || locator.getPath().contains(".broadPeak")) {
                for (FeatureTrack t : tracks) {
                    t.setUseScore(true);
                }
            }
            newTracks.addAll(tracks);
        } else if (MutationTrackLoader.isMutationAnnotationFile(locator)) {
            this.loadMutFile(locator, newTracks, genome);
        } else if (WiggleParser.isWiggle(locator)) {
            this.loadWigFile(locator, newTracks, genome);
        } else if (locator.getPath().toLowerCase().contains(".maf") || locator.getPath().toLowerCase().endsWith(".maf.dict")) {
            this.loadMultipleAlignmentTrack(locator, newTracks, genome);
        }
    }

    private void loadGWASFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        GWASParser gwasParser = new GWASParser(locator, genome);
        GWASData gwasData = gwasParser.parse();
        GWASTrack gwasTrack = new GWASTrack(locator, locator.getPath(), locator.getFileName(), gwasData, gwasParser);
        newTracks.add(gwasTrack);
    }

    private void loadRnaiGctFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        RNAIGCTDatasetParser parser = new RNAIGCTDatasetParser(locator, genome);
        Collection<RNAIDataSource> dataSources = parser.parse();
        if (dataSources != null) {
            String path = locator.getPath();
            for (RNAIDataSource ds : dataSources) {
                String trackId = path + "_" + ds.getName();
                DataSourceTrack track = new DataSourceTrack(locator, trackId, ds.getName(), ds);
                track.setAttributeValue("SCREEN", ds.getScreen());
                track.setHeight(80);
                newTracks.add(track);
            }
        }
    }

    private void loadGctFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        if (locator.isLocal() && !this.checkSize(locator.getPath())) {
            return;
        }
        ExpressionFileParser parser = null;
        ExpressionDataset ds = null;
        parser = new ExpressionFileParser(locator, null, genome);
        ds = parser.createDataset();
        if (ds.isEmpty()) {
            String message = "The probes in the file <br>&nbsp;&nbsp;&nbsp;" + locator.getPath() + "<br>" + "could not be mapped to genomic positions.  This can be corrected by specify a probe mapping<br>" + "file from the Preferences window (Probes tab), or by specifing the genomic positions in the<br>" + "expression data file.  Please see the user guide for more details.";
            MessageUtils.showMessage(message);
        } else {
            ds.setName(locator.getTrackName());
            ds.setNormalized(true);
            ds.setLogValues(true);
            TrackProperties trackProperties = ds.getTrackProperties();
            String path = locator.getPath();
            for (String trackName : ds.getTrackNames()) {
                DatasetDataSource dataSource = new DatasetDataSource(trackName, ds, genome);
                String trackId = path + "_" + trackName;
                DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
                track.setRendererClass(HeatmapRenderer.class);
                track.setProperties(trackProperties);
                newTracks.add(track);
            }
        }
    }

    private void loadIGVFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !this.checkSize(locator.getPath())) {
            return;
        }
        String dsName = locator.getTrackName();
        IGVDataset ds = new IGVDataset(locator, genome);
        ds.setName(dsName);
        TrackProperties trackProperties = ds.getTrackProperties();
        String path = locator.getPath();
        TrackType type = ds.getType();
        for (String trackName : ds.getTrackNames()) {
            DatasetDataSource dataSource = new DatasetDataSource(trackName, ds, genome);
            String trackId = path + "_" + trackName;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            track.setTrackType(ds.getType());
            track.setProperties(trackProperties);
            if (type == TrackType.ALLELE_FREQUENCY) {
                track.setRendererClass(PointsRenderer.class);
                track.setHeight(40);
            }
            newTracks.add(track);
        }
    }

    private void loadCufflinksFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        CufflinksCodec codec;
        String path = locator.getPath();
        String s = path.toLowerCase();
        ArrayList<DataSourceTrack> cuffTracks = new ArrayList<DataSourceTrack>();
        if (s.endsWith("fpkm_tracking")) {
            codec = new FPKMTrackingCodec(path);
            List<FPKMValue> list = CufflinksParser.parse(codec, path);
            for (int sampleIndex = 0; sampleIndex < ((FPKMTrackingCodec)codec).getNumSamples(); ++sampleIndex) {
                CufflinksDataSource ds = new CufflinksDataSource(sampleIndex, list, genome);
                String supId = String.format("q%02d", sampleIndex);
                DataSourceTrack track = new DataSourceTrack(locator, locator.getPath() + " " + supId, locator.getTrackName() + " " + supId, ds);
                cuffTracks.add(track);
            }
        } else if (s.endsWith("gene_exp.diff") || s.endsWith("cds_exp.diff")) {
            codec = new ExpDiffCodec(path);
            List<FPKMValue> list = CufflinksParser.parse(codec, path);
            CufflinksDataSource ds = new CufflinksDataSource(list, genome);
            DataSourceTrack track = new DataSourceTrack(locator, locator.getPath(), locator.getTrackName(), ds);
            cuffTracks.add(track);
        } else {
            throw new RuntimeException("Unsupported file type: " + path);
        }
        for (DataTrack dataTrack : cuffTracks) {
            dataTrack.setTrackType(TrackType.FPKM);
            CufflinksTrack.setCufflinksScale(dataTrack);
            newTracks.add(dataTrack);
        }
    }

    private boolean checkSize(String file) {
        if (!PreferenceManager.getInstance().getAsBoolean("SHOW_SIZE_WARNING")) {
            return true;
        }
        File f = new File(file);
        String tmp = file;
        if (f.exists()) {
            long size = f.length();
            if (file.endsWith(".gz")) {
                size *= 3L;
                tmp = file.substring(0, file.length() - 3);
            }
            if (size > 50000000L) {
                String message = "";
                message = tmp.endsWith(".bed") || tmp.endsWith(".bed.txt") ? "The file " + file + " is large (" + size / 1000000L + " mb).  It is recommended " + "that large files be indexed using IGVTools or Tabix. Loading un-indexed " + "ascii fies of this size can lead to poor performance or unresponsiveness (freezing).  " + "<br><br>IGVTools can be launched from the <b>Tools</b> menu or separately as a command line program.  " + "See the user guide for more details.<br><br>Click <b>Continue</b> to continue loading, or <b>Cancel</b>" + " to skip this file." : "The file " + file + " is large (" + size / 1000000L + " mb).  It is recommended " + "that large files be converted to the binary <i>.tdf</i> format using the IGVTools " + "<b>tile</b> command. Loading  unconverted ascii fies of this size can lead to poor " + "performance or unresponsiveness (freezing).  " + "<br><br>IGVTools can be launched from the <b>Tools</b> menu or separately as a " + "command line program. See the user guide for more details.<br><br>Click <b>Continue</b> " + "to continue loading, or <b>Cancel</b> to skip this file.";
                return ConfirmDialog.optionallyShowConfirmDialog(message, "SHOW_SIZE_WARNING", true);
            }
        }
        return true;
    }

    private void loadDOTFile(ResourceLocator locator, List<Track> newTracks) {
    }

    private void loadWigFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !this.checkSize(locator.getPath())) {
            return;
        }
        WiggleDataset ds = new WiggleParser(locator, genome).parse();
        TrackProperties props = ds.getTrackProperties();
        String name = props == null ? null : props.getName();
        String label = locator.getName();
        if (name == null) {
            name = locator.getFileName();
        } else if (label != null) {
            props.setName(label);
        }
        String path = locator.getPath();
        boolean multiTrack = ds.getTrackNames().length > 1;
        for (String heading : ds.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            DatasetDataSource dataSource = new DatasetDataSource(trackId, ds, genome);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            String displayName = label == null || multiTrack ? heading : label;
            track.setName(displayName);
            track.setProperties(props);
            track.setTrackType(ds.getType());
            if (ds.getType() == TrackType.EXPR) {
                track.setWindowFunction(WindowFunction.none);
            }
            newTracks.add(track);
        }
    }

    public void loadTDFFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        String name;
        log.debug("Loading TDF file " + locator.getPath());
        TDFReader reader = TDFReader.getReader(locator);
        TrackType type = reader.getTrackType();
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        if ((name = locator.getName()) != null && props != null) {
            props.setName(name);
        }
        if (name == null) {
            name = props == null ? locator.getTrackName() : props.getName();
        }
        int trackNumber = 0;
        String path = locator.getPath();
        boolean multiTrack = reader.getTrackNames().length > 1;
        for (String heading : reader.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            CoverageDataSource dataSource = locator.getPath().endsWith(".counts") ? new GobyCountArchiveDataSource(locator) : new TDFDataSource(reader, trackNumber, heading, genome);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            String displayName = name == null || multiTrack ? heading : name;
            track.setName(displayName);
            track.setTrackType(type);
            if (props != null) {
                track.setProperties(props);
            }
            newTracks.add(track);
            ++trackNumber;
        }
    }

    public void loadBWFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        String trackName = locator.getTrackName();
        String trackId = locator.getPath();
        String path = locator.getPath();
        BBFileReader reader = new BBFileReader(path);
        BigWigDataSource bigwigSource = new BigWigDataSource(reader, genome);
        if (reader.isBigWigFile()) {
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, bigwigSource);
            newTracks.add(track);
        } else if (reader.isBigBedFile()) {
            if (locator.getPath().contains("RRBS_cpgMethylation") || locator.getPath().contains("BiSeq_cpgMethylation") || reader.getAutoSql() != null && reader.getAutoSql().startsWith("table BisulfiteSeq")) {
                this.loadMethylTrack(locator, reader, newTracks, genome);
            } else {
                FeatureTrack track = new FeatureTrack(locator, trackId, trackName, bigwigSource);
                newTracks.add(track);
            }
        } else {
            throw new RuntimeException("Unknown BIGWIG type: " + locator.getPath());
        }
    }

    private void loadMethylTrack(ResourceLocator locator, BBFileReader reader, List<Track> newTracks, Genome genome) throws IOException {
        MethylTrack track = new MethylTrack(locator, reader, genome);
        newTracks.add(track);
    }

    private void loadGobyCountsArchive(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (log.isDebugEnabled()) {
            log.debug("Loading Goby counts archive: " + locator.toString());
        }
        String trackId = locator.getSampleId() + " coverage";
        String trackName = locator.getFileName();
        GobyCountArchiveDataSource dataSource = new GobyCountArchiveDataSource(locator);
        DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
        newTracks.add(track);
    }

    private void loadEwigIBFFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        TDFReader reader = TDFReader.getReader(locator.getPath());
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        EWigTrack track = new EWigTrack(locator, genome);
        if (props != null) {
            track.setProperties(props);
        }
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadListFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        try {
            FeatureDirSource source = new FeatureDirSource(locator, genome);
            FeatureTrack track = new FeatureTrack(locator, source);
            track.setName(locator.getTrackName());
            track.setVisibilityWindow(0);
            newTracks.add(track);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void loadGisticFile(ResourceLocator locator, List<Track> newTracks) {
        GisticTrack track = GisticFileParser.loadData(locator);
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadRNAiGeneScoreFile(ResourceLocator locator, List<Track> newTracks, RNAIGeneScoreParser.Type type, Genome genome) {
        RNAIGeneScoreParser parser = new RNAIGeneScoreParser(locator.getPath(), type, genome);
        Collection<RNAIDataSource> dataSources = parser.parse();
        String path = locator.getPath();
        for (RNAIDataSource ds : dataSources) {
            String name = ds.getName();
            String trackId = path + "_" + name;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, name, ds);
            track.setAttributeValue("SCREEN", ds.getScreen());
            if (ds.getCondition() != null && ds.getCondition().length() > 0) {
                track.setAttributeValue("CONDITION", ds.getCondition());
            }
            track.setHeight(80);
            newTracks.add(track);
        }
    }

    private void loadRNAiHPScoreFile(ResourceLocator locator) {
        new RNAIHairpinParser(locator.getPath()).parse();
    }

    private void loadMultipleAlignmentTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        MultipleAlignmentTrack t = new MultipleAlignmentTrack(locator, genome);
        t.setName("Multiple Alignments");
        newTracks.add(t);
    }

    private void loadPeakTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        PeakTrack t = new PeakTrack(locator, genome);
        newTracks.add(t);
    }

    private void loadAlignmentsTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        try {
            boolean showSpliceJunctionTrack;
            String path;
            String dsName = locator.getTrackName();
            if (locator.getTypeString().endsWith(".sai") || locator.getTypeString().endsWith(".bai")) {
                MessageUtils.showMessage("<html><b>ERROR:</b> Loading SAM/BAM index files are not supported:  " + locator.getPath() + "<br>Load the SAM or BAM file directly. ");
                return;
            }
            AlignmentDataManager dataManager = new AlignmentDataManager(locator, genome);
            List<String> seqNames = dataManager.getSequenceNames();
            if (seqNames != null && seqNames.size() > 0 && !this.checkSequenceNames(locator.getPath(), genome, seqNames)) {
                return;
            }
            if (locator.getPath().toLowerCase().endsWith(".bam") && !dataManager.hasIndex()) {
                MessageUtils.showMessage("<html>Could not load index file for: " + locator.getPath() + "<br>  An index file is required for SAM & BAM files.");
                return;
            }
            AlignmentTrack alignmentTrack = new AlignmentTrack(locator, dataManager, genome);
            alignmentTrack.setName(dsName);
            CoverageTrack covTrack = new CoverageTrack(locator, alignmentTrack.getName() + " Coverage", genome);
            covTrack.setVisible(PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_COV_TRACK"));
            newTracks.add(covTrack);
            alignmentTrack.setCoverageTrack(covTrack);
            covTrack.setDataManager(dataManager);
            dataManager.setCoverageTrack(covTrack);
            String covPath = locator.getCoverage();
            if (covPath == null && !(path = locator.getPath()).contains("/query.cgi?")) {
                covPath = path + ".tdf";
            }
            if (covPath != null) {
                try {
                    if (new File(covPath).exists() || HttpUtils.isRemoteURL(covPath) && HttpUtils.getInstance().resourceAvailable(new URL(covPath))) {
                        log.debug("Loading TDF for coverage: " + covPath);
                        TDFReader reader = TDFReader.getReader(covPath);
                        TDFDataSource ds = new TDFDataSource(reader, 0, alignmentTrack.getName() + " coverage", genome);
                        covTrack.setDataSource(ds);
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (showSpliceJunctionTrack = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK")) {
                SpliceJunctionFinderTrack spliceJunctionTrack = new SpliceJunctionFinderTrack(locator, alignmentTrack.getName() + " Junctions", dataManager, false);
                spliceJunctionTrack.setHeight(60);
                spliceJunctionTrack.setVisible(showSpliceJunctionTrack);
                newTracks.add(spliceJunctionTrack);
                alignmentTrack.setSpliceJunctionTrack(spliceJunctionTrack);
            }
            log.debug("Alignment track loaded");
            newTracks.add(alignmentTrack);
        }
        catch (IndexNotFoundException e) {
            MessageUtils.showMessage("<html>Could not find the index file for  <br><br>&nbsp;&nbsp;" + e.getSamFile() + "<br><br>Note: The index file can be created using igvtools and must be in the same directory as the .sam file.");
        }
    }

    private boolean checkSequenceNames(String filename, Genome genome, List<String> seqNames) {
        boolean atLeastOneMatch = false;
        for (String seqName : seqNames) {
            if (genome.getChromosome(seqName) == null) continue;
            atLeastOneMatch = true;
            break;
        }
        if (!atLeastOneMatch) {
            StringBuffer message = new StringBuffer();
            message.append("<html>File: " + filename + "<br>does not contain any sequence names which match the current genome.");
            message.append("<br><br>File: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            int n = 0;
            for (String sn : seqNames) {
                message.append(sn + ", ");
                if (++n <= 3) continue;
                message.append(" ...");
                break;
            }
            message.append("<br>Genome: ");
            n = 0;
            for (String cn : genome.getAllChromosomeNames()) {
                message.append(cn + ", ");
                if (++n <= 3) continue;
                message.append(" ...");
                break;
            }
            MessageUtils.showMessage(message.toString());
        }
        return atLeastOneMatch;
    }

    private void loadMutFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        MutationTrackLoader loader = new MutationTrackLoader();
        List<FeatureTrack> mutationTracks = loader.loadMutationTracks(locator, genome);
        for (FeatureTrack track : mutationTracks) {
            track.setTrackType(TrackType.MUTATION);
            track.setRendererClass(MutationRenderer.class);
            newTracks.add(track);
        }
    }

    private void loadFromDBProfile(ResourceLocator profileLocator, List<Track> newTracks) throws IOException {
        DBProfile dbProfile = DBProfile.parseProfile(profileLocator.getPath());
        for (DBProfile.DBTable table : dbProfile.getTableList()) {
            SQLCodecSource source = SQLCodecSource.getFromTable(table);
            if (source != null) {
                CachingFeatureSource cachingReader = new CachingFeatureSource(source);
                FeatureTrack track = new FeatureTrack(profileLocator, cachingReader);
                track.setName(source.getTableName());
                newTracks.add(track);
                continue;
            }
            if (table.getFormat().equals("seg")) {
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                SegmentedAsciiDataSet ds = new SegmentedReader(table.getDbLocator(), genome).loadFromDB(table);
                this.loadSegTrack(table.getDbLocator(), newTracks, genome, ds);
                continue;
            }
            if (!table.getFormat().equals("sample.info")) continue;
            String sampleIdColumnLabel = table.getBinColName();
            if (sampleIdColumnLabel == null) {
                throw new IllegalArgumentException("Profile must have binColName specifying the sample id column label");
            }
            new SampleInfoSQLReader(table, sampleIdColumnLabel).load();
        }
    }

    @Deprecated
    private void loadFromDatabase(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        ResourceLocator dbLocator = new ResourceLocator(locator.getDBUrl());
        if (".seg".equals(locator.getTypeString())) {
            SegmentedAsciiDataSet ds = (SegmentedAsciiDataSet)new SegmentedSQLReader(dbLocator, "CNV", genome).load();
            this.loadSegTrack(locator, newTracks, genome, ds);
        } else {
            new SampleInfoSQLReader(dbLocator, "SAMPLE_INFO", "SAMPLE_ID_ARRAY").load();
        }
    }

    private void loadSegFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        SegmentedDataSet ds;
        String path = locator.getPath().toLowerCase();
        if (path.endsWith("seg.zip")) {
            ds = new SegmentedBinaryDataSet(locator);
        } else {
            SegmentFileParser parser = new SegmentFileParser(locator);
            ds = parser.loadSegments(locator, genome);
        }
        this.loadSegTrack(locator, newTracks, genome, ds);
    }

    private void loadSegTrack(ResourceLocator locator, List<Track> newTracks, Genome genome, SegmentedDataSet ds) {
        String path = locator.getPath();
        TrackProperties props = null;
        if (ds instanceof SegmentedAsciiDataSet) {
            props = ((SegmentedAsciiDataSet)ds).getTrackProperties();
        }
        if ((ds.getType() == TrackType.COPY_NUMBER || ds.getType() == TrackType.CNV) && ds.getSampleNames().size() > 4) {
            FreqData fd = new FreqData(ds, genome);
            String freqTrackId = path;
            String freqTrackName = "CNV Summary";
            CNFreqTrack freqTrack = new CNFreqTrack(locator, freqTrackId, freqTrackName, fd);
            newTracks.add(freqTrack);
        }
        for (String trackName : ds.getSampleNames()) {
            String trackId = path + "_" + trackName;
            SegmentedDataSource dataSource = new SegmentedDataSource(trackName, ds);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            track.setRendererClass(HeatmapRenderer.class);
            track.setTrackType(ds.getType());
            if (props != null) {
                track.setProperties(props);
            }
            newTracks.add(track);
        }
    }

    private void loadDASResource(ResourceLocator locator, List<Track> currentTracks) {
        DASFeatureSource featureSource = null;
        try {
            featureSource = new DASFeatureSource(locator);
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", e);
            throw new DataLoadException("Error: Malformed URL ", locator.getPath());
        }
        FeatureTrack track = new FeatureTrack(locator, featureSource);
        String name = locator.getName();
        if (name == null || name.length() == 0) {
            name = locator.getPath().contains("genome.ucsc.edu") ? featureSource.getType() : featureSource.getPath().replace("/das/", "").replace("/features", "");
        }
        track.setName(name);
        if (locator.getPath().contains("cosmic")) {
            track.setRendererClass(CosmicFeatureRenderer.class);
            track.setMinimumHeight(2);
            track.setHeight(20);
            track.setDisplayMode(Track.DisplayMode.EXPANDED);
        } else {
            track.setRendererClass(IGVFeatureRenderer.class);
            track.setMinimumHeight(35);
            track.setHeight(45);
        }
        currentTracks.add(track);
    }

    private void loadTrioData(ResourceLocator locator) throws IOException {
        PedigreeUtils.parseTrioFile(locator.getPath());
    }

    public static boolean isIndexed(String path, Genome genome) {
        if (!TrackLoader.isIndexable(path, genome)) {
            return false;
        }
        String indexExtension = path.endsWith("gz") ? ".tbi" : ".idx";
        String indexPath = path + indexExtension;
        try {
            if (HttpUtils.isRemoteURL(path)) {
                return HttpUtils.getInstance().resourceAvailable(new URL(indexPath));
            }
            File f = new File(path + indexExtension);
            return f.exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isIndexable(String path, Genome genome) {
        String fn = TrackLoader.stripGZ(path);
        return fn.endsWith(".vcf") || fn.endsWith(".bcf") || CodecFactory.getCodec(path, genome) != null;
    }

    private static String stripGZ(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            int l = fn.length() - 3;
            fn = fn.substring(0, l);
        }
        return fn;
    }

    public static TrackProperties getTrackProperties(Object header) {
        try {
            FeatureFileHeader ffHeader = (FeatureFileHeader)header;
            if (ffHeader != null) {
                return ffHeader.getTrackProperties();
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

