/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.Interval;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.tribble.Feature;

public abstract class MultitrackDataManager<T extends Feature> {
    String path;
    Interval currentInterval;
    Map<String, List<T>> featureMap = Collections.synchronizedMap(new HashMap());
    TribbleFeatureSource tribbleFeatureSource;

    public MultitrackDataManager(String path, Genome genome) throws IOException {
        this.path = path;
        this.tribbleFeatureSource = new TribbleFeatureSource(path, genome);
    }

    synchronized Iterator<T> getFeatures(String trackKey, String chr, int start, int end) throws IOException {
        List<T> featureList;
        if (this.currentInterval == null || !this.currentInterval.contains(chr, start, end)) {
            Iterator<Feature> features = this.tribbleFeatureSource.getFeatures(chr, start, end);
            while (features.hasNext()) {
                Feature feat = features.next();
                String thisKey = this.getTrackKey(feat);
                List<T> keyFeatures = this.featureMap.get(thisKey);
                if (keyFeatures == null) {
                    keyFeatures = new ArrayList<T>();
                    this.featureMap.put(thisKey, keyFeatures);
                }
                keyFeatures.add(feat);
                this.currentInterval = new Interval(chr, start, end);
            }
        }
        return (featureList = this.featureMap.get(trackKey)) == null ? Collections.EMPTY_LIST.iterator() : featureList.iterator();
    }

    protected abstract String getTrackKey(T var1);
}

