/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.DenseAlignmentCounts;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.SparseAlignmentCounts;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.ReadGroupFilter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.collections.LRUCache;

public class AlignmentTileLoader {
    private static Logger log = Logger.getLogger(AlignmentTileLoader.class);
    private static Set<WeakReference<AlignmentTileLoader>> activeLoaders = Collections.synchronizedSet(new HashSet());
    private boolean corruptIndex = false;
    private AlignmentReader reader;
    private boolean cancel = false;
    private boolean pairedEnd = false;

    static void cancelReaders() {
        for (WeakReference<AlignmentTileLoader> readerRef : activeLoaders) {
            AlignmentTileLoader reader = (AlignmentTileLoader)readerRef.get();
            if (reader == null) continue;
            reader.cancel = true;
        }
        log.debug("Readers canceled");
        activeLoaders.clear();
    }

    public AlignmentTileLoader(AlignmentReader reader) {
        this.reader = reader;
        activeLoaders.add(new WeakReference<AlignmentTileLoader>(this));
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public CloseableIterator<Alignment> iterator() {
        return this.reader.iterator();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlignmentTile loadTile(String chr, int start, int end, SpliceJunctionHelper spliceJunctionHelper, AlignmentDataManager.DownsampleOptions downsampleOptions, Map<String, PEStats> peStats, AlignmentTrack.BisulfiteContext bisulfiteContext, ProgressMonitor monitor) {
        AlignmentTile t = new AlignmentTile(start, end, spliceJunctionHelper, downsampleOptions, bisulfiteContext);
        if (this.corruptIndex) {
            return t;
        }
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean filterFailedReads = prefMgr.getAsBoolean("SAM.FILTER_FAILED_READS");
        boolean filterSecondaryAlignments = prefMgr.getAsBoolean("SAM.FILTER_SECONDARY_ALIGNMENTS");
        ReadGroupFilter filter = ReadGroupFilter.getFilter();
        boolean showDuplicates = prefMgr.getAsBoolean("SAM.SHOW_DUPLICATES");
        int qualityThreshold = prefMgr.getAsInt("SAM.QUALITY_THRESHOLD");
        CloseableIterator<Alignment> iter = null;
        int alignmentCount = 0;
        WeakReference<AlignmentTileLoader> ref = new WeakReference<AlignmentTileLoader>(this);
        try {
            activeLoaders.add(ref);
            iter = this.reader.query(chr, start, end, false);
            while (iter != null && iter.hasNext()) {
                PEStats stats;
                int interval;
                if (this.cancel) {
                    AlignmentTile alignmentTile = t;
                    return alignmentTile;
                }
                Alignment record = (Alignment)iter.next();
                if (record.isPaired()) {
                    this.pairedEnd = true;
                }
                if (!record.isMapped() || !showDuplicates && record.isDuplicate() || filterFailedReads && record.isVendorFailedRead() || filterSecondaryAlignments && !record.isPrimary() || record.getMappingQuality() < qualityThreshold || filter != null && filter.filterAlignment(record)) continue;
                t.addRecord(record);
                int n = interval = Globals.isTesting() ? 100000 : 1000;
                if (++alignmentCount % interval == 0) {
                    if (this.cancel) {
                        AlignmentTile alignmentTile = null;
                        return alignmentTile;
                    }
                    String msg = "Reads loaded: " + alignmentCount;
                    MessageUtils.setStatusBarMessage(msg);
                    if (monitor != null) {
                        monitor.updateStatus(msg);
                    }
                    if (AlignmentTileLoader.memoryTooLow()) {
                        if (monitor != null) {
                            monitor.fireProgressChange(100);
                        }
                        AlignmentTileLoader.cancelReaders();
                        AlignmentTile alignmentTile = t;
                        return alignmentTile;
                    }
                }
                if (peStats == null || !record.isPaired() || !record.isProperPair()) continue;
                String lb = record.getLibrary();
                if (lb == null) {
                    lb = "null";
                }
                if ((stats = peStats.get(lb)) == null) {
                    stats = new PEStats(lb);
                    peStats.put(lb, stats);
                }
                stats.update(record);
            }
            if (peStats != null) {
                double minPercentile = prefMgr.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
                double maxPercentile = prefMgr.getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
                for (PEStats stats : peStats.values()) {
                    stats.compute(minPercentile, maxPercentile);
                }
            }
            t.setLoaded(true);
            AlignmentTile minPercentile = t;
            return minPercentile;
        }
        catch (BufferUnderflowException e) {
            this.corruptIndex = true;
            MessageUtils.showMessage("<html>Error encountered querying alignments: " + e.toString() + "<br>This is often caused by a corrupt index file.");
            AlignmentTile alignmentTile = null;
            return alignmentTile;
        }
        catch (Exception e) {
            log.error("Error loading alignment data", e);
            MessageUtils.showMessage("<html>Error encountered querying alignments: " + e.toString());
            AlignmentTile alignmentTile = null;
            return alignmentTile;
        }
        finally {
            this.cancel = false;
            activeLoaders.remove(ref);
            if (monitor != null) {
                monitor.fireProgressChange(100);
            }
            if (iter != null) {
                iter.close();
            }
            if (!Globals.isHeadless()) {
                IGV.getInstance().resetStatusMessage();
            }
        }
    }

    private static synchronized boolean memoryTooLow() {
        if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
            LRUCache.clearCaches();
            System.gc();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
                String msg = "Memory is low, reading terminating.";
                MessageUtils.showMessage(msg);
                return true;
            }
        }
        return false;
    }

    public boolean isPairedEnd() {
        return this.pairedEnd;
    }

    public Set<String> getPlatforms() {
        return this.reader.getPlatforms();
    }

    public static class AlignmentTile {
        private boolean loaded = false;
        private int end;
        private int start;
        private AlignmentCounts counts;
        private List<Alignment> alignments;
        private List<DownsampledInterval> downsampledIntervals;
        private SpliceJunctionHelper spliceJunctionHelper;
        private boolean downsample;
        private int samplingWindowSize;
        private int samplingDepth;
        private SamplingBucket currentSamplingBucket;
        private static final Random RAND = new Random(System.currentTimeMillis());

        AlignmentTile(int start, int end, SpliceJunctionHelper spliceJunctionHelper, AlignmentDataManager.DownsampleOptions downsampleOptions, AlignmentTrack.BisulfiteContext bisulfiteContext) {
            this.start = start;
            this.end = end;
            this.alignments = new ArrayList<Alignment>(16000);
            this.downsampledIntervals = new ArrayList<DownsampledInterval>();
            this.counts = end - start > 10000000 ? new SparseAlignmentCounts(start, end, bisulfiteContext) : new DenseAlignmentCounts(start, end, bisulfiteContext);
            if (downsampleOptions == null) {
                downsampleOptions = new AlignmentDataManager.DownsampleOptions();
            }
            this.downsample = downsampleOptions.isDownsample();
            this.samplingWindowSize = downsampleOptions.getSampleWindowSize();
            this.samplingDepth = Math.max(1, downsampleOptions.getMaxReadCount());
            this.spliceJunctionHelper = spliceJunctionHelper;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void addRecord(Alignment alignment) {
            this.counts.incCounts(alignment);
            if (this.spliceJunctionHelper != null) {
                this.spliceJunctionHelper.addAlignment(alignment);
            }
            if (this.downsample) {
                int alignmentStart = alignment.getAlignmentStart();
                if (this.currentSamplingBucket == null || alignmentStart >= this.currentSamplingBucket.end) {
                    if (this.currentSamplingBucket != null) {
                        this.emptyBucket();
                    }
                    int end = alignmentStart + this.samplingWindowSize;
                    this.currentSamplingBucket = new SamplingBucket(alignmentStart, end);
                }
                this.currentSamplingBucket.add(alignment);
            } else {
                this.alignments.add(alignment);
            }
            alignment.finish();
        }

        private void emptyBucket() {
            if (this.currentSamplingBucket == null) {
                return;
            }
            for (Alignment alignment : this.currentSamplingBucket.getAlignments()) {
                this.alignments.add(alignment);
            }
            if (this.currentSamplingBucket.isSampled()) {
                DownsampledInterval interval = new DownsampledInterval(this.currentSamplingBucket.start, this.currentSamplingBucket.end, this.currentSamplingBucket.downsampledCount);
                this.downsampledIntervals.add(interval);
            }
            this.currentSamplingBucket = null;
        }

        public List<Alignment> getAlignments() {
            return this.alignments;
        }

        public List<DownsampledInterval> getDownsampledIntervals() {
            return this.downsampledIntervals;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
            if (loaded) {
                this.emptyBucket();
                this.currentSamplingBucket = null;
                this.finalizeSpliceJunctions();
                this.counts.finish();
            }
        }

        public AlignmentCounts getCounts() {
            return this.counts;
        }

        private void finalizeSpliceJunctions() {
            if (this.spliceJunctionHelper != null) {
                this.spliceJunctionHelper.finish();
            }
        }

        public List<SpliceJunctionFeature> getSpliceJunctionFeatures() {
            if (this.spliceJunctionHelper == null) {
                return null;
            }
            return this.spliceJunctionHelper.getFilteredJunctions();
        }

        public SpliceJunctionHelper getSpliceJunctionHelper() {
            return this.spliceJunctionHelper;
        }

        private class SamplingBucket {
            int start;
            int end;
            int downsampledCount = 0;
            List<Alignment> alignments;

            private SamplingBucket(int start, int end) {
                this.start = start;
                this.end = end;
                this.alignments = new ArrayList<Alignment>(AlignmentTile.this.samplingDepth);
            }

            public void add(Alignment alignment) {
                if (this.alignments.size() < AlignmentTile.this.samplingDepth) {
                    this.alignments.add(alignment);
                } else {
                    double samplingProb = (double)AlignmentTile.this.samplingDepth / (double)(AlignmentTile.this.samplingDepth + this.downsampledCount + 1);
                    if (RAND.nextDouble() < samplingProb) {
                        int idx = (int)(RAND.nextDouble() * (double)(this.alignments.size() - 1));
                        this.alignments.set(idx, alignment);
                    }
                    ++this.downsampledCount;
                }
            }

            public List<Alignment> getAlignments() {
                return this.alignments;
            }

            public boolean isSampled() {
                return this.downsampledCount > 0;
            }

            public int getDownsampledCount() {
                return this.downsampledCount;
            }
        }
    }
}

