/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import org.apache.log4j.Logger;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.variant.VariantTrack;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Argument {
    public static final String CMD_ARG = "cmd_arg";
    public static final String LIBS = "libs";
    private static final Logger log = Logger.getLogger(Argument.class);
    @XmlAttribute
    private String name;
    @XmlAttribute
    private InputType type;
    @XmlAttribute(name="cmd_arg")
    private String cmdArg;
    @XmlAttribute
    private String defaultValue;
    @XmlAttribute
    private boolean output = false;
    @XmlAttribute
    private boolean visible = true;
    @XmlAttribute
    private String id;
    @XmlAttribute
    private String encodingCodec;
    @XmlElement(name="libs")
    private String[] libPaths;
    public static final CharSequence TOOL_DIR_KEY = "$toolDir";
    @XmlAttribute
    private boolean remembered;
    @XmlElement
    List<String> value;

    public boolean isRemembered() {
        return this.remembered;
    }

    boolean isValidValue(Object value) {
        switch (this.type) {
            case BOOL: {
                return value instanceof Boolean;
            }
            case TEXT: 
            case LONGTEXT: {
                return value instanceof String || value == null;
            }
            case VARIANT_TRACK: {
                return value instanceof VariantTrack;
            }
            case ALIGNMENT_TRACK: {
                return value instanceof AlignmentTrack;
            }
            case FEATURE_TRACK: {
                return value instanceof FeatureTrack;
            }
            case MULTI_FEATURE_TRACK: {
                if (!(value instanceof List)) {
                    return false;
                }
                try {
                    List lVal = (List)value;
                    FeatureTrack fVal = (FeatureTrack)lVal.get(0);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getCmdArg() {
        return this.cmdArg;
    }

    public InputType getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String[] getLibPaths() {
        return this.libPaths;
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public String getId() {
        return this.id;
    }

    public String getEncodingCodec() {
        return this.encodingCodec;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private Argument() {
    }

    Argument(String name, InputType type, String cmdArg, String defaultValue, String encodingCodec, String[] libPaths, boolean isOutput, String id) {
        this.name = name;
        this.type = type;
        this.cmdArg = cmdArg != null ? cmdArg : "";
        this.defaultValue = defaultValue;
        this.encodingCodec = encodingCodec;
        this.libPaths = libPaths;
        this.output = isOutput;
        this.id = id;
        if (!this.output && id == null) {
            log.info(String.format("Argument %s is not output but it also has no id. This argument will have no effect", name));
        }
    }

    @XmlEnum
    public static enum InputType {
        BOOL,
        TEXT,
        LONGTEXT,
        FEATURE_TRACK,
        DATA_TRACK,
        MULTI_FEATURE_TRACK,
        ALIGNMENT_TRACK,
        VARIANT_TRACK,
        LOCUS;

    }
}

