/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.LineNumberingTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;

@Invariant(value={"stack != null", "!stack.contains(null)"})
public class BalancedTokenizer
extends LineNumberingTokenizer {
    protected Deque<Character> stack = new ArrayDeque<Character>();

    @Requires(value={"reader != null"})
    public BalancedTokenizer(Reader reader) {
        super(reader);
    }

    @Ensures(value={"result != null", "result.size() == getCurrentLevel()"})
    public Collection<Character> getStack() {
        return Collections.unmodifiableCollection(this.stack);
    }

    @Ensures(value={"result >= 0", "result == getStack().size()"})
    public int getCurrentLevel() {
        return this.stack.size();
    }

    @Requires(value={"\"()[]{}\".indexOf(c) != -1"})
    protected char getMatchingDelimiter(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case ')': {
                return '(';
            }
            case ']': {
                return '[';
            }
            case '}': {
                return '{';
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected boolean lex() throws IOException {
        if (!super.lex()) {
            if (!this.stack.isEmpty()) {
                char c = this.getMatchingDelimiter(this.stack.pop().charValue());
                this.errorMessage = "'" + c + "' expected";
                this.hasErrors_ = true;
                return false;
            }
            return false;
        }
        if (this.nextToken.kind == JavaTokenizer.TokenKind.SYMBOL) {
            char c = this.nextToken.text.charAt(0);
            switch (c) {
                case '(': 
                case '[': 
                case '{': {
                    this.stack.push(Character.valueOf(c));
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    String string = null;
                    if (this.stack.isEmpty()) {
                        string = "unexpected '" + c + "'";
                    } else {
                        char c2 = this.getMatchingDelimiter(this.stack.pop().charValue());
                        if (c2 != c) {
                            string = "'" + c2 + "' expected";
                        }
                    }
                    if (string == null) break;
                    this.unreadChar(c);
                    this.nextToken = null;
                    this.errorMessage = string;
                    this.hasErrors_ = true;
                    return false;
                }
            }
        }
        return true;
    }
}

