/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractHandle;
import com.google.java.contract.core.agent.ContractMethodSignatures;
import com.google.java.contract.core.model.ContractKind;
import java.util.List;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"getMethodName() != null"})
public class MethodContractHandle
extends ContractHandle {
    protected String methodName;

    @Requires(value={"kind != null", "className != null", "contractMethod != null"})
    @Ensures(value={"kind == getKind()", "className.equals(getClassName())", "contractMethod == getContractMethod()", "lineNumbers == getLineNumbers()"})
    public MethodContractHandle(ContractKind contractKind, String string, MethodNode methodNode, List<Long> list) {
        super(contractKind, string, methodNode, list);
        this.methodName = ContractMethodSignatures.getTarget(methodNode);
    }

    public String getMethodName() {
        return this.methodName;
    }
}

