/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.mongodb.DBCursor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.RawSiteIterator;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.InvalidRecordHandler;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.InvalidRecordsThrowError;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.errors.MongoVariantContextException;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class SiteIterator<T extends MongoVariantContext>
extends PeekableIterator<T>
implements Iterable<T>,
CloseableIterator<T> {
    final GenomeLocParser parser;
    InvalidRecordHandler<T> errorHandler;
    GenomeLoc lastLoc = null;

    public SiteIterator(GenomeLocParser parser, DBCursor cursor) {
        this(parser, cursor, new InvalidRecordsThrowError());
    }

    public SiteIterator(GenomeLocParser parser, DBCursor cursor, InvalidRecordHandler errorHandler) {
        super(new RawSiteIterator(cursor));
        if (parser == null) {
            throw new IllegalArgumentException("Parser cannot be null");
        }
        this.parser = parser;
        this.setErrorHandler(errorHandler);
    }

    public void setErrorHandler(InvalidRecordHandler<T> errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException("errorHandler cannot be null");
        }
        this.errorHandler = errorHandler;
    }

    @Ensures(value={"result != null"})
    public List<T> getSitesBefore(GenomeLoc loc) {
        MongoVariantContext n;
        GenomeLoc nLoc;
        if (loc.size() != 1) {
            throw new IllegalArgumentException("GenomeLoc must be a single one bp site but got " + loc);
        }
        LinkedList<Object> l = new LinkedList<Object>();
        while (this.hasNext() && (nLoc = (n = (MongoVariantContext)this.peek()).getLocation(this.parser)).startsBefore(loc)) {
            l.add(this.next());
        }
        return l;
    }

    @Ensures(value={"result != null"})
    public List<T> getSitesAtLocation(GenomeLoc loc) {
        if (loc.size() != 1) {
            throw new IllegalArgumentException("GenomeLoc must be a single one bp site but got " + loc);
        }
        LinkedList<Object> l = new LinkedList<Object>();
        while (this.hasNext()) {
            MongoVariantContext n = (MongoVariantContext)this.peek();
            GenomeLoc nLoc = n.getLocation(this.parser);
            if (nLoc.isBefore(loc)) {
                this.next();
                continue;
            }
            if (!nLoc.startsAt(loc)) break;
            l.add(this.next());
        }
        return l;
    }

    @Ensures(value={"result != null"})
    public List<T> getNextEquivalents() {
        MongoVariantContext n;
        LinkedList<Object> variants = new LinkedList<Object>();
        MongoVariantContext first = (MongoVariantContext)this.peek();
        while (this.hasNext() && this.equivalentVariants(first, n = (MongoVariantContext)this.peek())) {
            variants.add(this.next());
        }
        return variants;
    }

    @Requires(value={"vc1 != null", "vc2 != null"})
    private boolean equivalentVariants(T vc1, T vc2) {
        return ((MongoVariantContext)vc1).getChr().equals(((MongoVariantContext)vc2).getChr()) && ((MongoVariantContext)vc1).getStart() == ((MongoVariantContext)vc2).getStart() && ((MongoVariantContext)vc1).getRef().equals(((MongoVariantContext)vc2).getRef()) && ((MongoVariantContext)vc1).getAlt().equals(((MongoVariantContext)vc2).getAlt());
    }

    public List<T> toList() {
        LinkedList<Object> l = new LinkedList<Object>();
        while (this.hasNext()) {
            l.add(this.next());
        }
        return l;
    }

    @Override
    public boolean hasNext() {
        while (super.hasNext()) {
            MongoVariantContext n = (MongoVariantContext)super.peek();
            try {
                n.validate(this.parser);
                return true;
            }
            catch (MongoVariantContextException e) {
                this.handleError(n, e);
                super.next();
            }
        }
        return false;
    }

    private void handleError(T record, MongoVariantContextException e) {
        this.errorHandler.handleFailedRecord(record, e);
    }

    @Override
    public T next() {
        MongoVariantContext n = (MongoVariantContext)super.next();
        GenomeLoc nLoc = n.getLocation(this.parser);
        if (this.lastLoc != null && nLoc.isBefore(this.lastLoc)) {
            throw new IllegalStateException("Records appearing out of order.  Current location is " + nLoc + " but last location was " + this.lastLoc);
        }
        this.lastLoc = nLoc;
        while (this.hasNext() && n.isDuplicate((MongoVariantContext)this.peek())) {
            this.next();
        }
        return (T)n;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

