/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.IOException;
import net.sf.samtools.seekablestream.SeekableStream;

public class IGVSeekableBufferedStream
extends SeekableStream {
    public static final int DEFAULT_BUFFER_SIZE = 512000;
    private final int maxBufferSize;
    final SeekableStream wrappedStream;
    long position;
    long length;
    int markpos;
    int marklimit;
    byte[] buffer;
    long bufferStartPosition;
    int bufferSize;

    public IGVSeekableBufferedStream(SeekableStream stream, int bsize) {
        this.maxBufferSize = bsize;
        this.wrappedStream = stream;
        this.position = 0L;
        this.length = this.wrappedStream.length();
        this.buffer = new byte[this.maxBufferSize];
        this.bufferStartPosition = -1L;
        this.bufferSize = 0;
    }

    public IGVSeekableBufferedStream(SeekableStream stream) {
        this(stream, 512000);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long skip(long skipLength) throws IOException {
        long actualSkip = Math.min(this.length - this.position - 1L, skipLength);
        this.position += actualSkip;
        return actualSkip;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.position = this.markpos;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markpos = (int)this.position;
        this.marklimit = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.wrappedStream.length();
    }

    @Override
    public String getSource() {
        return this.wrappedStream.getSource();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferSize == 0 || this.position < this.bufferStartPosition || this.position >= this.bufferStartPosition + (long)this.bufferSize) {
            this.fillBuffer();
        }
        int offset = (int)(this.position - this.bufferStartPosition);
        byte b = this.buffer[offset];
        ++this.position;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position >= this.length) {
            return -1;
        }
        if (len > this.maxBufferSize) {
            this.wrappedStream.seek(this.position);
            int nBytes = this.wrappedStream.read(b, off, len);
            this.position += (long)nBytes;
            return nBytes;
        }
        if (this.position < this.bufferStartPosition || this.position + (long)len >= this.bufferStartPosition + (long)this.bufferSize) {
            this.fillBuffer();
        }
        int bufferOffset = (int)(this.position - this.bufferStartPosition);
        int bytesCopied = Math.min(len, this.bufferSize - bufferOffset);
        System.arraycopy(this.buffer, bufferOffset, b, 0, bytesCopied);
        this.position += (long)bytesCopied;
        return bytesCopied;
    }

    private void fillBuffer() throws IOException {
        int len = Math.min(this.maxBufferSize, (int)(this.length - this.position));
        int offset = 0;
        if (len > 0) {
            int n;
            int count;
            this.wrappedStream.seek(this.position + (long)offset);
            for (n = 0; n < len && (count = this.wrappedStream.read(this.buffer, n, len - n)) >= 0; n += count) {
            }
            this.bufferStartPosition = this.position;
            this.bufferSize = n;
        }
    }
}

