/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class StringUtils {
    private static Map<String, String> internedStrings = new WeakHashMap<String, String>();

    public static String intern(String string) {
        if (!internedStrings.containsKey(string)) {
            internedStrings.put(string, string);
        }
        return internedStrings.get(string);
    }

    public static List<String> breakQuotedString(String string, char splitToken) {
        ArrayList<String> strings = new ArrayList<String>();
        if (string.length() == 0) {
            return strings;
        }
        char[] characters = string.toCharArray();
        boolean isQuoted = false;
        StringBuffer buff = new StringBuffer(100);
        for (int i = 0; i < characters.length; ++i) {
            char c = characters[i];
            if (isQuoted) {
                if (c == '\"') {
                    isQuoted = false;
                }
                buff.append(c);
                continue;
            }
            if (c == '\"') {
                isQuoted = true;
                buff.append(c);
                continue;
            }
            if (c == splitToken) {
                strings.add(buff.toString().trim());
                buff.setLength(0);
                continue;
            }
            buff.append(c);
        }
        if (buff.length() > 0) {
            strings.add(buff.toString().trim());
        }
        return strings;
    }

    public static String checkLength(String string, int maxLength) {
        if (string.length() <= maxLength) {
            return string;
        }
        int nDots = maxLength > 10 ? 3 : (maxLength > 5 ? 2 : 1);
        int m = Math.max(1, (maxLength - nDots) / 2);
        StringBuffer newString = new StringBuffer(maxLength);
        newString.append(string.substring(0, m));
        for (int i = 0; i < nDots; ++i) {
            newString.append('.');
        }
        newString.append(string.substring(string.length() - m));
        return newString.toString();
    }

    public static short genoToShort(String genotype) {
        byte[] bytes = genotype.getBytes();
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static String readString(ByteBuffer byteBuffer) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int b = -1;
        while (true) {
            byte by = byteBuffer.get();
            b = by;
            if (by == 0) break;
            bytes.write(b);
        }
        return new String(bytes.toByteArray());
    }

    public static String decodeURL(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeURL(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyTextToClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static String capWords(String text) {
        String res = "";
        boolean capNext = true;
        for (char c : text.toLowerCase().toCharArray()) {
            String s = Character.toString(c);
            if (capNext) {
                s = s.toUpperCase();
            }
            res = res + s;
            capNext = " ".equals(s);
        }
        return res;
    }

    public static int countChar(String string, char c) {
        int cnt = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            ++cnt;
        }
        return cnt;
    }
}

