/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import com.google.common.primitives.Primitives;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.ui.util.MessageUtils;

public class RuntimeUtils {
    private static Logger log = Logger.getLogger(RuntimeUtils.class);
    private static Instrumentation instrumentation;
    private static Map<Class, Long> primitiveMemMap;

    public static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return freeMemory + (maxMemory - allocatedMemory);
    }

    public static double getAvailableMemoryFraction() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(freeMemory + (maxMemory - allocatedMemory)) / (double)maxMemory;
    }

    public static void premain(String args, Instrumentation inst) {
        instrumentation = inst;
    }

    public static long getObjectSize(Object o) {
        if (instrumentation == null) {
            throw new IllegalStateException("No instrumentation available. Need to launch width -javaagent:path/to/RuntimeUtils.jar");
        }
        return instrumentation.getObjectSize(o);
    }

    static boolean isPrimitiveOrWrapper(Object o) {
        return o.getClass().isPrimitive() || Primitives.isWrapperType(o.getClass());
    }

    public static long getObjectSizeRecursive(Object o, Set<Object> completedObjs) {
        long fullSize = RuntimeUtils.getObjectSize(o);
        completedObjs.add(o);
        if (RuntimeUtils.isPrimitiveOrWrapper(o)) {
            return fullSize;
        }
        if (o.getClass().isArray()) {
            for (int ii = 0; ii < Array.getLength(o); ++ii) {
                Object el = Array.get(o, ii);
                fullSize += RuntimeUtils.getObjectSizeRecursive(el, completedObjs);
            }
        }
        HashSet<Field> fields = new HashSet<Field>();
        RuntimeUtils.getAllFields(o.getClass(), fields);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType.isPrimitive()) {
                fullSize += primitiveMemMap.get(fieldType).longValue();
                continue;
            }
            try {
                Object fieldValue = field.get(o);
                fullSize += RuntimeUtils.getObjectSizeRecursive(fieldValue, completedObjs);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return fullSize;
    }

    static void getAllFields(Class clazz, Set<Field> fields) {
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class supClass = clazz.getSuperclass();
        if (supClass != null) {
            RuntimeUtils.getAllFields(supClass, fields);
        }
    }

    public static Process startExternalProcess(String[] msg, String[] envp, File dir) throws IOException {
        Process pr = Runtime.getRuntime().exec(msg, envp, dir);
        RuntimeUtils.startErrorReadingThread(pr);
        return pr;
    }

    private static Process startErrorReadingThread(Process pr) {
        final BufferedReader err = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
        Thread runnable = new Thread(){
            private boolean messageDisplayed = false;

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = err.readLine()) != null) {
                        log.error(line);
                        if (this.messageDisplayed || !line.toLowerCase().contains("error")) continue;
                        MessageUtils.showMessage(line + "<br>See igv.log for more details");
                        this.messageDisplayed = true;
                    }
                    err.close();
                }
                catch (IOException e) {
                    log.error(e);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
        runnable.start();
        return pr;
    }

    @Deprecated
    public static String executeShellCommand(String cmd, String[] envp, File dir) throws IOException {
        return RuntimeUtils.executeShellCommand(new String[]{cmd}, envp, dir);
    }

    public static String executeShellCommand(String[] cmd, String[] envp, File dir) throws IOException {
        return RuntimeUtils.executeShellCommand(cmd, envp, dir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeShellCommand(String[] cmd, String[] envp, File dir, boolean waitFor) throws IOException {
        Process pr = RuntimeUtils.startExternalProcess(cmd, envp, dir);
        if (waitFor) {
            try {
                pr.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        InputStream inputStream = null;
        String line = "";
        try {
            inputStream = pr.getInputStream();
            BufferedReader buf = new BufferedReader(new InputStreamReader(inputStream));
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            while ((line = buf.readLine()) != null) {
                pw.println(line);
            }
            pw.close();
            String string = writer.toString();
            return string;
        }
        finally {
            OutputStream os;
            if (inputStream != null) {
                inputStream.close();
            }
            if ((os = pr.getOutputStream()) != null) {
                os.close();
            }
        }
    }

    private static URL[] getClassURLs() {
        String[] paths = new String[2];
        paths[0] = new File(DirectoryManager.getIgvDirectory(), "plugins/").getAbsolutePath();
        URL[] urls = new URL[paths.length];
        for (int pp = 0; pp < paths.length; ++pp) {
            try {
                urls[pp] = new URL("file://" + paths[pp]);
                continue;
            }
            catch (MalformedURLException e) {
                log.error(e);
            }
        }
        return urls;
    }

    public static Object loadClassForName(String className) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Object object = null;
        try {
            object = Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (object != null) {
            return object;
        }
        URLClassLoader loader = URLClassLoader.newInstance(RuntimeUtils.getClassURLs(), ClassLoader.getSystemClassLoader());
        return loader.loadClass(className);
    }

    static {
        primitiveMemMap = new HashMap<Class, Long>(9);
        primitiveMemMap.put(Byte.TYPE, 8L);
        primitiveMemMap.put(Short.TYPE, 16L);
        primitiveMemMap.put(Integer.TYPE, 32L);
        primitiveMemMap.put(Long.TYPE, 64L);
        primitiveMemMap.put(Float.TYPE, 32L);
        primitiveMemMap.put(Double.TYPE, 64L);
        primitiveMemMap.put(Boolean.TYPE, 1L);
        primitiveMemMap.put(Character.TYPE, 16L);
        primitiveMemMap.put(Void.TYPE, 0L);
        assert (primitiveMemMap.size() == Primitives.allPrimitiveTypes().size());
    }
}

