/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;

public class MessageUtils {
    private static Logger log = Logger.getLogger(MessageUtils.class);

    public static void showErrorMessage(String message, Exception e) {
        log.error(message, e);
        MessageUtils.showMessage(Level.ERROR, message);
    }

    public static void showMessage(String message) {
        MessageUtils.showMessage(Level.INFO, message);
    }

    public static synchronized void showMessage(Level level, String message) {
        boolean showDialog;
        log.log(level, message);
        boolean bl = showDialog = !Globals.isHeadless() && !Globals.isSuppressMessages() && !Globals.isTesting();
        if (showDialog) {
            message = "<html>" + message.replaceAll("<html>", "");
            Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
            Color background = parent != null ? parent.getBackground() : Color.lightGray;
            JEditorPane content = new JEditorPane();
            content.setContentType("text/html");
            content.setText(message);
            content.setBackground(background);
            JOptionPane.showMessageDialog(parent, content);
        }
    }

    public static void setStatusBarMessage(String message) {
        log.debug("Status bar: " + message);
        if (IGV.hasInstance()) {
            IGV.getInstance().setStatusBarMessage(message);
        }
    }

    public static synchronized boolean confirm(String message) {
        if (Globals.isHeadless()) {
            log.error("Attempted to confirm while running headless with the following message:\n" + message);
            return false;
        }
        Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        return MessageUtils.confirm(parent, message);
    }

    public static synchronized boolean confirm(final Component component, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            int opt = JOptionPane.showConfirmDialog(component, message, "Confirm", 0);
            return opt == 0;
        }
        final ValueHolder returnValue = new ValueHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int opt = JOptionPane.showConfirmDialog(component, message, "Confirm", 0);
                returnValue.value = opt == 0;
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            log.error("Error in showMessage", e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error("Error in showMessage", e);
            throw new RuntimeException(e.getCause());
        }
        return (Boolean)returnValue.value;
    }

    public static String showInputDialog(final String message, final String defaultValue) {
        Frame parent;
        Frame frame = parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        if (SwingUtilities.isEventDispatchThread()) {
            String val = JOptionPane.showInputDialog(parent, message, defaultValue);
            return val;
        }
        final ValueHolder returnValue = new ValueHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String val = JOptionPane.showInputDialog(parent, message, defaultValue);
                returnValue.value = val;
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            log.error("Error in showMessage", e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error("Error in showMessage", e);
            throw new RuntimeException(e.getCause());
        }
        return (String)returnValue.value;
    }

    public static String showInputDialog(final String message) {
        Frame parent;
        Frame frame = parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        if (SwingUtilities.isEventDispatchThread()) {
            String val = JOptionPane.showInputDialog(parent, (Object)message);
            return val;
        }
        final ValueHolder returnValue = new ValueHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String val = JOptionPane.showInputDialog(parent, (Object)message);
                returnValue.value = val;
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            log.error("Error in showMessage", e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error("Error in showMessage", e);
            throw new RuntimeException(e.getCause());
        }
        return (String)returnValue.value;
    }

    public static void main(String[] args) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MessageUtils.showMessage("showMessage");
                MessageUtils.confirm("confirm");
                MessageUtils.confirm(null, "confirm with parent");
                MessageUtils.showInputDialog("showInputDialog", "default");
                MessageUtils.showInputDialog("showInputDialog");
            }
        };
        runnable.run();
        SwingUtilities.invokeLater(runnable);
    }

    static class ValueHolder {
        Object value;

        ValueHolder() {
        }
    }
}

