/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IconFactory;

public class ZoomSliderPanel
extends JPanel {
    static Color TICK_GRAY = new Color(90, 90, 90);
    static Color TICK_BLUE = new Color(25, 50, 200);
    Image slider;
    Image zoomPlus;
    Image zoomMinus;
    Rectangle zoomPlusRect;
    Rectangle zoomMinusRect;
    Rectangle[] zoomLevelRects;
    int numZoomLevels = 25;
    private int minZoomLevel = 0;
    private static final Color TRANSPARENT_GRAY = new Color(200, 200, 200, 150);
    private ReferenceFrame referenceFrame;
    int toolZoom = -1;

    public void setMinZoomLevel(int minZoomLevel) {
        this.minZoomLevel = minZoomLevel;
    }

    public ZoomSliderPanel() {
        this((ReferenceFrame)null);
    }

    public ZoomSliderPanel(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        this.slider = IconFactory.getInstance().getIcon(IconFactory.IconID.SLIDER).getImage();
        this.zoomPlus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_PLUS).getImage();
        this.zoomMinus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_MINUS).getImage();
        this.zoomLevelRects = new Rectangle[this.numZoomLevels];
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.init();
    }

    private void updateTickCount() {
        int tmp = this.getViewContext().getMaxZoom() + 1;
        if (tmp != this.numZoomLevels) {
            this.numZoomLevels = tmp;
            this.zoomLevelRects = new Rectangle[this.numZoomLevels];
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updateTickCount();
        this.paintHorizontal(g);
    }

    protected void paintHorizontal(Graphics g) {
        int zoom;
        Graphics2D transGraphics = (Graphics2D)g.create();
        transGraphics.setColor(TRANSPARENT_GRAY);
        int buttonWidth = this.zoomPlus.getWidth(null);
        int buttonHeight = this.zoomPlus.getHeight(null);
        Insets insets = this.getInsets();
        int panelWidth = this.getWidth() - insets.left - insets.right;
        int panelHeight = this.getHeight() - insets.top - insets.bottom;
        boolean enabled = this.isEnabled();
        g.setColor(enabled ? Color.BLACK : Color.LIGHT_GRAY);
        double x = insets.left;
        double xStep = (double)(panelWidth - 2 * buttonWidth - 10) / (double)this.numZoomLevels;
        int y = insets.top + (panelHeight - buttonHeight) / 2;
        g.drawImage(this.zoomMinus, (int)x, y, null);
        this.zoomMinusRect = new Rectangle((int)x, y, buttonWidth, buttonHeight);
        if (!this.isEnabled()) {
            transGraphics.fill(this.zoomMinusRect);
        }
        int lastX = (int)((x += (double)(5 + buttonWidth)) - xStep);
        for (int i = 0; i < this.numZoomLevels; ++i) {
            Rectangle zoomRect = new Rectangle((int)x, y, (int)(x - (double)lastX), buttonHeight);
            int xLine = (int)(x + xStep / 2.0);
            g.drawLine(xLine, y + 3, xLine, y + buttonHeight - 4);
            this.zoomLevelRects[i] = zoomRect;
            lastX = (int)x;
            x += xStep;
        }
        y = insets.top + panelHeight / 2 - 1;
        y = insets.top + (panelHeight - buttonHeight) / 2;
        g.drawImage(this.zoomPlus, (int)(x += 5.0), y, null);
        this.zoomPlusRect = new Rectangle((int)x, y, buttonWidth, buttonWidth);
        if (!this.isEnabled()) {
            transGraphics.fill(this.zoomPlusRect);
        }
        int n = zoom = this.toolZoom >= 0 ? this.toolZoom : this.getViewContext().getAdjustedZoom();
        if (enabled && zoom >= 0 && zoom < this.zoomLevelRects.length) {
            Rectangle rect = this.zoomLevelRects[zoom];
            g.setColor(TICK_BLUE);
            g.fill3DRect((int)(rect.getX() + rect.getWidth() / 2.0) - 3, (int)rect.getY(), 6, (int)rect.getHeight(), true);
        }
        transGraphics.dispose();
    }

    int setZoom(MouseEvent e) {
        if (this.zoomPlusRect.contains(e.getX(), e.getY())) {
            ++this.toolZoom;
        } else if (this.zoomMinusRect.contains(e.getX(), e.getY()) && this.toolZoom > this.minZoomLevel) {
            --this.toolZoom;
        } else {
            for (int i = 0; i < this.zoomLevelRects.length; ++i) {
                Rectangle rect = this.zoomLevelRects[i];
                if (!rect.contains(e.getX(), e.getY()) || i < this.minZoomLevel) continue;
                this.toolZoom = i;
            }
        }
        return this.toolZoom;
    }

    private ReferenceFrame getViewContext() {
        if (this.referenceFrame == null) {
            return FrameManager.getDefaultFrame();
        }
        return this.referenceFrame;
    }

    private void init() {
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX = 0;

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!ZoomSliderPanel.this.isEnabled()) {
                    return;
                }
                ZoomSliderPanel.this.toolZoom = Math.max(0, ZoomSliderPanel.this.getViewContext().getAdjustedZoom());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ZoomSliderPanel.this.isEnabled()) {
                    return;
                }
                int oldToolZoom = ZoomSliderPanel.this.toolZoom;
                int diff = ZoomSliderPanel.this.setZoom(e) - oldToolZoom;
                if (diff == 0) {
                    ZoomSliderPanel.this.toolZoom = -1;
                    return;
                }
                ZoomSliderPanel.this.repaint();
                int effectiveZoom = ZoomSliderPanel.this.toolZoom + ZoomSliderPanel.this.getViewContext().getMinZoom();
                ViewChange.ZoomCause event = new ViewChange.ZoomCause(effectiveZoom);
                ZoomSliderPanel.this.getViewContext().getEventBus().post(event);
                ZoomSliderPanel.this.toolZoom = -1;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ZoomSliderPanel.this.setZoom(e);
                ZoomSliderPanel.this.repaint();
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }
}

