/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.blat.BlatClient;
import org.broad.igv.data.CombinedDataSource;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.renderer.RNAiBarChartRenderer;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuItemBuilder;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.HeatmapScaleDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.stats.KMPlotFrame;
import org.broad.tribble.Feature;

public class TrackMenuUtils {
    static Logger log = Logger.getLogger(TrackMenuUtils.class);
    static final String LEADING_HEADING_SPACER = "  ";
    private static final WindowFunction[] ORDERED_WINDOW_FUNCTIONS = new WindowFunction[]{WindowFunction.min, WindowFunction.percentile2, WindowFunction.percentile10, WindowFunction.median, WindowFunction.mean, WindowFunction.percentile90, WindowFunction.percentile98, WindowFunction.max, WindowFunction.none};
    private static List<TrackMenuItemBuilder> trackMenuItems = new ArrayList<TrackMenuItemBuilder>();

    public static void addTrackMenuItemBuilder(TrackMenuItemBuilder builder) {
        trackMenuItems.add(builder);
    }

    public static IGVPopupMenu getPopupMenu(Collection<Track> tracks, String title, TrackClickEvent te) {
        if (log.isDebugEnabled()) {
            log.debug("enter getPopupMenu");
        }
        IGVPopupMenu menu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel(LEADING_HEADING_SPACER + title, 0);
        popupTitle.setFont(UIConstants.boldFont);
        if (popupTitle != null) {
            menu.add(popupTitle);
            menu.addSeparator();
        }
        TrackMenuUtils.addStandardItems(menu, tracks, te);
        return menu;
    }

    public static void addPluginItems(JPopupMenu menu, Collection<Track> tracks, TrackClickEvent te) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(0);
        for (TrackMenuItemBuilder builder : trackMenuItems) {
            JMenuItem item = builder.build(tracks, te);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            menu.addSeparator();
            for (JMenuItem item : items) {
                menu.add(item);
            }
        }
    }

    public static void addStandardItems(JPopupMenu menu, Collection<Track> tracks, TrackClickEvent te) {
        boolean hasDataTracks = false;
        boolean hasFeatureTracks = false;
        boolean hasOtherTracks = false;
        for (Track track : tracks) {
            if (track instanceof DataTrack) {
                hasDataTracks = true;
            } else if (track instanceof FeatureTrack) {
                hasFeatureTracks = true;
            } else {
                hasOtherTracks = true;
            }
            if (!hasDataTracks || !hasFeatureTracks || !hasOtherTracks) continue;
            break;
        }
        boolean featureTracksOnly = hasFeatureTracks && !hasDataTracks && !hasOtherTracks;
        boolean dataTracksOnly = !hasFeatureTracks && hasDataTracks && !hasOtherTracks;
        TrackMenuUtils.addSharedItems(menu, tracks, hasFeatureTracks);
        menu.addSeparator();
        if (dataTracksOnly) {
            TrackMenuUtils.addDataItems(menu, tracks);
        } else if (featureTracksOnly) {
            TrackMenuUtils.addFeatureItems(menu, tracks, te);
        }
        menu.addSeparator();
        menu.add(TrackMenuUtils.getRemoveMenuItem(tracks));
    }

    public static void addZoomItems(JPopupMenu menu, final ReferenceFrame frame) {
        if (FrameManager.isGeneListMode()) {
            JMenuItem item = new JMenuItem("Reset panel to '" + frame.getName() + "'");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    frame.reset();
                }
            });
            menu.add(item);
        }
        JMenuItem zoomOutItem = new JMenuItem("Zoom out");
        zoomOutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.doZoomIncrement(-1);
            }
        });
        menu.add(zoomOutItem);
        JMenuItem zoomInItem = new JMenuItem("Zoom in");
        zoomInItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.doZoomIncrement(1);
            }
        });
        menu.add(zoomInItem);
    }

    public static void addDataItems(JPopupMenu menu, final Collection<Track> tracks) {
        if (log.isDebugEnabled()) {
            log.debug("enter getDataPopupMenu");
        }
        String[] labels = new String[]{"Heatmap", "Bar Chart", "Points", "Line Plot"};
        Class[] renderers = new Class[]{HeatmapRenderer.class, BarChartRenderer.class, PointsRenderer.class, LineplotRenderer.class};
        JLabel rendererHeading = new JLabel("  Type of Graph", 2);
        rendererHeading.setFont(UIConstants.boldFont);
        menu.add(rendererHeading);
        HashSet currentRenderers = new HashSet();
        for (Track track : tracks) {
            if (track.getRenderer() == null) continue;
            currentRenderers.add(track.getRenderer().getClass());
        }
        for (int i = 0; i < labels.length; ++i) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(labels[i]);
            final Class rendererClass = renderers[i];
            if (currentRenderers.contains(rendererClass)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.changeRenderer(tracks, rendererClass);
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        HashSet<WindowFunction> avaibleWindowFunctions = new HashSet<WindowFunction>();
        for (Track track : tracks) {
            avaibleWindowFunctions.addAll(track.getAvailableWindowFunctions());
        }
        avaibleWindowFunctions.add(WindowFunction.none);
        HashSet<WindowFunction> currentWindowFunctions = new HashSet<WindowFunction>();
        for (Track track : tracks) {
            if (track.getWindowFunction() == null) continue;
            currentWindowFunctions.add(track.getWindowFunction());
        }
        if (avaibleWindowFunctions.size() > 1 || currentWindowFunctions.size() > 1) {
            JLabel statisticsHeading = new JLabel("  Windowing Function", 2);
            statisticsHeading.setFont(UIConstants.boldFont);
            menu.add(statisticsHeading);
            for (final WindowFunction wf : ORDERED_WINDOW_FUNCTIONS) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(wf.getValue());
                if (!avaibleWindowFunctions.contains(wf) && !currentWindowFunctions.contains(wf)) continue;
                if (currentWindowFunctions.contains(wf)) {
                    item.setSelected(true);
                }
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TrackMenuUtils.changeStatType(wf.toString(), tracks);
                    }
                });
                menu.add(item);
            }
            menu.addSeparator();
        }
        menu.add(TrackMenuUtils.getDataRangeItem(tracks));
        menu.add(TrackMenuUtils.getHeatmapScaleItem(tracks));
        if (tracks.size() > 0) {
            menu.add(TrackMenuUtils.getLogScaleItem(tracks));
        }
        menu.add(TrackMenuUtils.getAutoscaleItem(tracks));
        menu.add(TrackMenuUtils.getShowDataRangeItem(tracks));
        menu.addSeparator();
        menu.add(TrackMenuUtils.getChangeKMPlotItem(tracks));
    }

    private static List<JMenuItem> getCombinedDataSourceItems(Collection<Track> tracks) {
        Iterable<DataTrack> dataTracksIter = Iterables.filter(tracks, DataTrack.class);
        final ArrayList<DataTrack> dataTracks = Lists.newArrayList(dataTracksIter);
        JMenuItem addItem = new JMenuItem("Sum Tracks");
        JMenuItem subItem = new JMenuItem("Subtract Tracks");
        boolean enableComb = dataTracks.size() == 2;
        addItem.setEnabled(enableComb);
        addItem.setEnabled(enableComb);
        addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackMenuUtils.addCombinedDataTrack(dataTracks, CombinedDataSource.Operation.ADD);
            }
        });
        subItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackMenuUtils.addCombinedDataTrack(dataTracks, CombinedDataSource.Operation.SUBTRACT);
            }
        });
        return Arrays.asList(addItem, subItem);
    }

    private static void addCombinedDataTrack(List<DataTrack> dataTracks, CombinedDataSource.Operation op) {
        String text = "";
        switch (op) {
            case ADD: {
                text = "Sum";
                break;
            }
            case SUBTRACT: {
                text = "Difference";
            }
        }
        DataTrack track0 = dataTracks.get(0);
        DataTrack track1 = dataTracks.get(1);
        CombinedDataSource source = new CombinedDataSource(track0, track1, op);
        DataSourceTrack newTrack = new DataSourceTrack(null, track0.getId() + track1.getId() + text, text, source);
        TrackMenuUtils.changeRenderer(Arrays.asList(newTrack), track0.getRenderer().getClass());
        newTrack.setDataRange(track0.getDataRange());
        newTrack.setColorScale(track0.getColorScale());
        IGV.getInstance().addTracks(Arrays.asList(newTrack), PanelName.DATA_PANEL);
    }

    private static void addFeatureItems(JPopupMenu featurePopupMenu, Collection<Track> tracks, TrackClickEvent te) {
        Track t;
        Feature f;
        TrackMenuUtils.addDisplayModeItems(tracks, featurePopupMenu);
        if (tracks.size() == 1 && (f = (t = tracks.iterator().next()).getFeatureAtMousePosition(te)) != null) {
            featurePopupMenu.addSeparator();
            if (f instanceof IGVFeature) {
                double position = te.getChromosomePosition();
                List<Exon> exons = ((IGVFeature)f).getExons();
                if (exons != null) {
                    for (Exon exon : exons) {
                        if (!(position > (double)exon.getStart()) || !(position < (double)exon.getEnd())) continue;
                        f = exon;
                        break;
                    }
                }
            }
            featurePopupMenu.add(TrackMenuUtils.getCopyDetailsItem(f, te));
            featurePopupMenu.add(TrackMenuUtils.getCopySequenceItem(f));
            if (!Globals.isProduction()) {
                featurePopupMenu.add(TrackMenuUtils.getBlatItem(f));
            }
        }
        featurePopupMenu.addSeparator();
        featurePopupMenu.add(TrackMenuUtils.getChangeFeatureWindow(tracks));
    }

    public static void addSharedItems(JPopupMenu menu, final Collection<Track> tracks, boolean hasFeatureTracks) {
        menu.add(TrackMenuUtils.getTrackRenameItem(tracks));
        String colorLabel = hasFeatureTracks ? "Change Track Color..." : "Change Track Color (Positive Values)...";
        JMenuItem item = new JMenuItem(colorLabel);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeTrackColor(tracks);
            }
        });
        menu.add(item);
        if (!hasFeatureTracks) {
            item = new JMenuItem("Change Track Color (Negative Values)...");
            item.setToolTipText("Change the alternate track color.  This color is used when graphing negative values");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.changeAltTrackColor(tracks);
                }
            });
            menu.add(item);
        }
        menu.add(TrackMenuUtils.getChangeTrackHeightItem(tracks));
        menu.add(TrackMenuUtils.getChangeFontSizeItem(tracks));
    }

    private static void changeStatType(String statType, Collection<Track> selectedTracks) {
        for (Track track : selectedTracks) {
            track.setWindowFunction(WindowFunction.valueOf(statType));
        }
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getTrackRenameItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Rename Track...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        TrackMenuUtils.renameTrack(selectedTracks);
                    }
                });
            }
        });
        if (selectedTracks.size() > 1) {
            item.setEnabled(false);
        }
        return item;
    }

    private static JMenuItem getHeatmapScaleItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Heatmap Scale...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.size() > 0) {
                    ContinuousColorScale colorScale = ((Track)selectedTracks.iterator().next()).getColorScale();
                    HeatmapScaleDialog dlg = new HeatmapScaleDialog(IGV.getMainFrame(), colorScale);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        colorScale = dlg.getColorScale();
                        for (Track track : selectedTracks) {
                            track.setColorScale(colorScale);
                        }
                        IGV.getInstance().repaint();
                    }
                }
            }
        });
        return item;
    }

    public static JMenuItem getDataRangeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Data Range...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.size() > 0) {
                    float mid = 0.0f;
                    float min = Float.MAX_VALUE;
                    float max = Float.MIN_VALUE;
                    boolean drawBaseline = true;
                    boolean isLog = true;
                    for (Track t : selectedTracks) {
                        DataRange dr = t.getDataRange();
                        min = Math.min(min, dr.getMinimum());
                        max = Math.max(max, dr.getMaximum());
                        mid += dr.getBaseline();
                        drawBaseline &= dr.isDrawBaseline();
                        isLog &= dr.isLog();
                    }
                    if ((mid /= (float)selectedTracks.size()) < min) {
                        mid = min;
                    } else if (mid > max) {
                        min = max;
                    }
                    DataRange prevAxisDefinition = new DataRange(min, mid, max, drawBaseline, isLog);
                    DataRangeDialog dlg = new DataRangeDialog(IGV.getMainFrame(), prevAxisDefinition);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        min = Math.min(dlg.getMax(), dlg.getMin());
                        max = Math.max(dlg.getMin(), dlg.getMax());
                        mid = dlg.getBase();
                        mid = Math.max(min, Math.min(mid, max));
                        DataRange axisDefinition = new DataRange(dlg.getMin(), mid, dlg.getMax(), drawBaseline, dlg.isLog());
                        for (Track track : selectedTracks) {
                            track.setDataRange(axisDefinition);
                            if (!(track instanceof DataTrack)) continue;
                            ((DataTrack)track).setAutoScale(false);
                        }
                        IGV.getInstance().repaint();
                    }
                }
            }
        });
        return item;
    }

    private static JMenuItem getDrawBorderItem() {
        final JCheckBoxMenuItem drawBorderItem = new JCheckBoxMenuItem("Draw borders");
        drawBorderItem.setSelected(FeatureTrack.isDrawBorder());
        drawBorderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTrack.setDrawBorder(drawBorderItem.isSelected());
                IGV.getInstance().repaintDataPanels();
            }
        });
        return drawBorderItem;
    }

    public static JMenuItem getLogScaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = selectedTracks.iterator().next().getDataRange().isLog();
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                for (Track t : selectedTracks) {
                    t.getDataRange().setType(scaleType);
                }
                IGV.getInstance().repaintDataPanels();
            }
        });
        return logScaleItem;
    }

    private static JMenuItem getAutoscaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        if (selectedTracks.size() == 0) {
            autoscaleItem.setEnabled(false);
        } else {
            boolean autoScale = TrackMenuUtils.checkAutoscale(selectedTracks);
            autoscaleItem.setSelected(autoScale);
            autoscaleItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean autoScale = autoscaleItem.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setAutoScale(autoScale);
                    }
                    IGV.getInstance().repaintDataPanels();
                }
            });
        }
        return autoscaleItem;
    }

    private static boolean checkAutoscale(Collection<Track> selectedTracks) {
        boolean autoScale = false;
        for (Track t : selectedTracks) {
            if (!(t instanceof DataTrack) || !((DataTrack)t).isAutoScale()) continue;
            autoScale = true;
            break;
        }
        return autoScale;
    }

    public static JMenuItem getShowDataRangeItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Data Range");
        if (selectedTracks.size() == 0) {
            item.setEnabled(false);
        } else {
            boolean showDataRange = true;
            for (Track t : selectedTracks) {
                if (t.isShowDataRange()) continue;
                showDataRange = false;
                break;
            }
            item.setSelected(showDataRange);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean showDataRange = item.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setShowDataRange(showDataRange);
                    }
                    IGV.getInstance().repaintDataPanels();
                }
            });
        }
        return item;
    }

    public static void addDisplayModeItems(final Collection<Track> tracks, JPopupMenu menu) {
        HashMap<Track.DisplayMode, Integer> counts = new HashMap<Track.DisplayMode, Integer>(Track.DisplayMode.values().length);
        Track.DisplayMode currentMode = null;
        for (Track t : tracks) {
            Track.DisplayMode mode = t.getDisplayMode();
            if (counts.containsKey((Object)mode)) {
                counts.put(mode, (Integer)counts.get((Object)mode) + 1);
                continue;
            }
            counts.put(mode, 1);
        }
        int maxCount = -1;
        for (Map.Entry count : counts.entrySet()) {
            if ((Integer)count.getValue() <= maxCount) continue;
            currentMode = (Track.DisplayMode)((Object)count.getKey());
            maxCount = (Integer)count.getValue();
        }
        ButtonGroup group = new ButtonGroup();
        LinkedHashMap<String, Track.DisplayMode> modes = new LinkedHashMap<String, Track.DisplayMode>(4);
        modes.put("Collapsed", Track.DisplayMode.COLLAPSED);
        modes.put("Expanded", Track.DisplayMode.EXPANDED);
        modes.put("Squished", Track.DisplayMode.SQUISHED);
        boolean showAS = Boolean.parseBoolean(System.getProperty("showAS", "false"));
        if (showAS) {
            modes.put("Alternative Splice", Track.DisplayMode.ALTERNATIVE_SPLICE);
        }
        for (final Map.Entry entry : modes.entrySet()) {
            JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
            mm.setSelected(currentMode == entry.getValue());
            mm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.setTrackDisplayMode(tracks, (Track.DisplayMode)((Object)entry.getValue()));
                    TrackMenuUtils.refresh();
                }
            });
            group.add(mm);
            menu.add(mm);
        }
    }

    private static void setTrackDisplayMode(Collection<Track> tracks, Track.DisplayMode mode) {
        for (Track t : tracks) {
            t.setDisplayMode(mode);
        }
    }

    public static JMenuItem getRemoveMenuItem(final Collection<Track> selectedTracks) {
        boolean multiple = selectedTracks.size() > 1;
        JMenuItem item = new JMenuItem("Remove Track" + (multiple ? "s" : ""));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.isEmpty()) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (Track track : selectedTracks) {
                    buffer.append("\n\t");
                    buffer.append(track.getName());
                }
                String deleteItems = buffer.toString();
                JTextArea textArea = new JTextArea();
                textArea.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(textArea);
                textArea.setText(deleteItems);
                JOptionPane optionPane = new JOptionPane(scrollPane, -1, 0);
                optionPane.setPreferredSize(new Dimension(550, 500));
                JDialog dialog = optionPane.createDialog(IGV.getMainFrame(), "Remove The Following Tracks");
                dialog.setVisible(true);
                Object choice = optionPane.getValue();
                if (choice == null || 0 != (Integer)choice) {
                    return;
                }
                IGV.getInstance().removeTracks(selectedTracks);
                IGV.getInstance().doRefresh();
            }
        });
        return item;
    }

    public static void changeRenderer(Collection<Track> selectedTracks, Class rendererClass) {
        for (Track track : selectedTracks) {
            if (track.getTrackType() == TrackType.RNAI && rendererClass == BarChartRenderer.class) {
                rendererClass = RNAiBarChartRenderer.class;
            }
            track.setRendererClass(rendererClass);
        }
        TrackMenuUtils.refresh();
    }

    public static void renameTrack(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Track t = selectedTracks.iterator().next();
        String newName = JOptionPane.showInputDialog(IGV.getMainFrame(), "Enter new name: ", t.getName());
        if (newName == null || newName.trim() == "") {
            return;
        }
        t.setName(newName);
        TrackMenuUtils.refresh();
    }

    public static void changeTrackHeight(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Track height";
        int value = TrackMenuUtils.getIntValue("Track height", TrackMenuUtils.getRepresentativeTrackHeight(selectedTracks));
        if (value == Integer.MIN_VALUE) {
            return;
        }
        value = Math.max(0, value);
        for (Track track : selectedTracks) {
            track.setHeight(value, true);
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFeatureVisibilityWindow(Collection<Track> selectedTracks) {
        ArrayList<Track> featureTracks = new ArrayList<Track>(selectedTracks.size());
        for (Track t : selectedTracks) {
            if (!(t instanceof FeatureTrack)) continue;
            featureTracks.add(t);
        }
        if (featureTracks.isEmpty()) {
            return;
        }
        int origValue = ((Track)featureTracks.iterator().next()).getVisibilityWindow();
        double origValueKB = (double)origValue / 1000.0;
        double value = TrackMenuUtils.getNumericValue("Visibility window (kb)", origValueKB);
        if (value == -2.147483648E9) {
            return;
        }
        for (Track track : featureTracks) {
            track.setVisibilityWindow((int)(value * 1000.0));
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFontSize(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Font size";
        int defaultValue = selectedTracks.iterator().next().getFontSize();
        int value = TrackMenuUtils.getIntValue("Font size", defaultValue);
        if (value == Integer.MIN_VALUE) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setFontSize(value);
        }
        TrackMenuUtils.refresh();
    }

    public static int getIntValue(String parameter, int value) {
        String height;
        while ((height = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !height.trim().equals("")) {
            try {
                value = Integer.parseInt(height);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), parameter + " must be an integer number.");
                continue;
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    public static double getNumericValue(String parameter, double value) {
        String height;
        while ((height = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !height.trim().equals("")) {
            try {
                value = Double.parseDouble(height);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                MessageUtils.showMessage(parameter + " must be a number.");
                continue;
            }
            break;
        }
        return Double.MIN_VALUE;
    }

    public static void changeTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Positive Values)", currentSelection);
        if (color != null) {
            for (Track track : selectedTracks) {
                track.setColor(color);
            }
            TrackMenuUtils.refresh();
        }
    }

    public static void changeAltTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Negative Values)", currentSelection);
        if (color == null) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setAltColor(color);
        }
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getCopyDetailsItem(final Feature f, final TrackClickEvent evt) {
        JMenuItem item = new JMenuItem("Copy Details to Clipboard");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String details;
                ReferenceFrame frame = evt.getFrame();
                int mouseX = evt.getMouseEvent().getX();
                double location = frame.getChromosomePosition(mouseX);
                if (f instanceof IGVFeature && (details = ((IGVFeature)f).getValueString(location, null)) != null) {
                    details = details.replace("<br>", System.getProperty("line.separator"));
                    details = details + System.getProperty("line.separator") + f.getChr() + ":" + (f.getStart() + 1) + "-" + f.getEnd();
                    StringUtils.copyTextToClipboard(details);
                }
            }
        });
        return item;
    }

    public static JMenuItem getCopySequenceItem(final Feature f) {
        JMenuItem item = new JMenuItem("Copy Sequence");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                IGV.copySequenceToClipboard(genome, f.getChr(), f.getStart(), f.getEnd());
            }
        });
        return item;
    }

    public static JMenuItem getBlatItem(final Feature f) {
        JMenuItem item = new JMenuItem("Blat Sequence");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlatClient.doBlatQuery(f.getChr(), f.getStart(), f.getEnd());
            }
        });
        return item;
    }

    public static int getRepresentativeTrackHeight(Collection<Track> tracks) {
        double[] heights = new double[tracks.size()];
        int i = 0;
        for (Track track : tracks) {
            heights[i] = track.getHeight();
            ++i;
        }
        int medianTrackHeight = (int)Math.round(StatUtils.percentile(heights, 50.0));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }
        return PreferenceManager.getInstance().getAsInt("15");
    }

    public static void refresh() {
        if (IGV.hasInstance()) {
            IGV.getInstance().showLoadedTrackCount();
            IGV.getInstance().doRefresh();
        }
    }

    public static JMenuItem getChangeTrackHeightItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Track Height...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeTrackHeight(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getChangeKMPlotItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Kaplan-Meier Plot...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                List<Track> tracks = selectedTracks.size() > 1 ? selectedTracks : IGV.getInstance().getAllTracks();
                KMPlotFrame frame = new KMPlotFrame(tracks);
                frame.setVisible(true);
            }
        });
        boolean sampleInfoLoaded = AttributeManager.getInstance().getAttributeNames().size() > 4;
        item.setEnabled(sampleInfoLoaded);
        return item;
    }

    public static JMenuItem getChangeFeatureWindow(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeFeatureVisibilityWindow(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getChangeFontSizeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Font Size...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeFontSize(selectedTracks);
            }
        });
        return item;
    }
}

