/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import javax.swing.JProgressBar;
import net.sf.picard.sam.BuildBamIndex;
import net.sf.samtools.SAMFileReader;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.sam.reader.SamIndexCreatorDialog;
import org.broad.igv.sam.reader.SamUtils;

public class SamIndexer
extends AlignmentIndexer {
    static final int FLAG_COL = 1;
    static final int READ_UNMAPPED_FLAG = 4;

    public SamIndexer(File samFile, JProgressBar progressBar, SamIndexCreatorDialog.IndexWorker worker) {
        super(samFile, progressBar, worker);
    }

    @Override
    int getAlignmentStart(String[] fields) throws NumberFormatException {
        int alignmentStart = Integer.parseInt(fields[3].trim()) - 1;
        return alignmentStart;
    }

    @Override
    int getAlignmentLength(String[] fields) throws NumberFormatException {
        String cigarString = fields[5];
        return SamUtils.getPaddedReferenceLength(cigarString);
    }

    @Override
    String getChromosome(String[] fields) {
        return fields[2];
    }

    @Override
    boolean isMapped(String[] fields) {
        int flags = Integer.parseInt(fields[1]);
        return (flags & 4) == 0;
    }

    public static void createBAMIndex(File inputBam, File outputBam) {
        SAMFileReader reader = new SAMFileReader(inputBam);
        BuildBamIndex.createIndex(reader, outputBam);
    }
}

