/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.util.ParsingUtils;

public class ChromSizesParser {
    private static Logger log = Logger.getLogger(ChromSizesParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Chromosome> parse(String path) throws IOException {
        BufferedReader br = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(path);
            ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = Globals.whitespacePattern.split(nextLine);
                int idx = 0;
                if (tokens.length >= 2) {
                    String chr = tokens[0];
                    int length = Integer.parseInt(tokens[1]);
                    chromosomes.add(new Chromosome(idx, chr, length));
                    ++idx;
                    continue;
                }
                log.info("Unexpected # of tokens at line: " + nextLine);
            }
            ArrayList<Chromosome> arrayList = chromosomes;
            return arrayList;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }
}

