/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.CompositeScore;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.data.NamedScore;
import org.broad.igv.data.SummaryTile;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.Accumulator;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.util.collections.LRUCache;

public abstract class AbstractDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(AbstractDataSource.class);
    boolean cacheSummaryTiles = true;
    WindowFunction windowFunction = WindowFunction.mean;
    LRUCache<String, SummaryTile> summaryTileCache = new LRUCache(this, 10);
    protected Genome genome;
    static List<WindowFunction> wfs = new ArrayList<WindowFunction>();

    public AbstractDataSource(Genome genome) {
        this.genome = genome;
    }

    protected abstract DataTile getRawData(String var1, int var2, int var3);

    protected abstract List<LocusScore> getPrecomputedSummaryScores(String var1, int var2, int var3, int var4);

    public int getChrLength(String chr) {
        if (chr.equals("All")) {
            return (int)(this.genome.getNominalLength() / 1000L);
        }
        Chromosome c = this.genome.getChromosome(chr);
        return c == null ? 0 : c.getLength();
    }

    public void refreshData(long timestamp) {
    }

    public abstract int getLongestFeature(String var1);

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        List<LocusScore> scores = this.getPrecomputedSummaryScores(chr, startLocation, endLocation, zoom);
        if (scores != null) {
            return scores;
        }
        List<SummaryTile> tiles = this.getSummaryTilesForRange(chr, startLocation, endLocation, zoom);
        scores = new ArrayList<LocusScore>(tiles.size() * 700);
        for (SummaryTile tile : tiles) {
            scores.addAll(tile.getScores());
        }
        return scores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SummaryTile> getSummaryTilesForRange(String chr, int startLocation, int endLocation, int zReq) {
        int chrLength = this.getChrLength(chr);
        if (chrLength == 0) {
            return Collections.emptyList();
        }
        endLocation = Math.min(endLocation, chrLength);
        int adjustedStart = Math.max(0, startLocation);
        int adjustedEnd = Math.min(chrLength, endLocation);
        if (this.cacheSummaryTiles && !FrameManager.isGeneListMode() && !FrameManager.isExomeMode()) {
            int z = zReq;
            int virtualTileCount = (int)Math.pow(2.0, z);
            double tileWidth = (double)chrLength / (double)virtualTileCount;
            int startTile = (int)((double)adjustedStart / tileWidth);
            int endTile = (int)((double)Math.min(chrLength, adjustedEnd) / tileWidth) + 1;
            ArrayList<SummaryTile> tiles = null;
            tiles = new ArrayList<SummaryTile>(endTile - startTile + 1);
            for (int t = startTile; t <= endTile; ++t) {
                int tileStart = (int)((double)t * tileWidth);
                int tileEnd = Math.min(chrLength, (int)((double)(t + 1) * tileWidth));
                String key = chr + "_" + z + "_" + t + this.getWindowFunction();
                SummaryTile summaryTile = this.summaryTileCache.get(key);
                if (summaryTile == null) {
                    summaryTile = this.computeSummaryTile(chr, t, tileStart, tileEnd, 700);
                    if (this.cacheSummaryTiles && !FrameManager.isGeneListMode()) {
                        LRUCache<String, SummaryTile> lRUCache = this.summaryTileCache;
                        synchronized (lRUCache) {
                            this.summaryTileCache.put(key, summaryTile);
                        }
                    }
                }
                if (summaryTile == null) continue;
                tiles.add(summaryTile);
            }
            return tiles;
        }
        SummaryTile summaryTile = this.computeSummaryTile(chr, 0, startLocation, endLocation, 700);
        return Arrays.asList(summaryTile);
    }

    SummaryTile computeSummaryTile(String chr, int tileNumber, int startLocation, int endLocation, int nBins) {
        int longestGene = this.getLongestFeature(chr);
        int adjustedStart = Math.max(startLocation - longestGene, 0);
        DataTile rawTile = this.getRawData(chr, adjustedStart, endLocation);
        SummaryTile tile = null;
        if (rawTile != null) {
            tile = new SummaryTile();
        }
        if (rawTile != null && !rawTile.isEmpty() && nBins > 0) {
            int[] starts = rawTile.getStartLocations();
            int[] ends = rawTile.getEndLocations();
            float[] values = rawTile.getValues();
            String[] features = rawTile.getFeatureNames();
            if (this.windowFunction == WindowFunction.none) {
                for (int i = 0; i < starts.length; ++i) {
                    int e;
                    int s = starts[i];
                    int n = e = ends == null ? s + 1 : Math.max(s + 1, ends[i]);
                    if (e < startLocation) continue;
                    if (s < endLocation) {
                        String probeName = features == null ? null : features[i];
                        float v = values[i];
                        NamedScore score = new NamedScore(s, e, v, probeName);
                        tile.addScore(score);
                        continue;
                    }
                    break;
                }
            } else {
                float normalizationFactor = 1.0f;
                ArrayList<LocusScore> scores = new ArrayList<LocusScore>(nBins);
                double scale = (double)(endLocation - startLocation) / (double)nBins;
                Accumulator accumulator = new Accumulator(this.windowFunction, 5);
                int accumulatedStart = -1;
                int accumulatedEnd = -1;
                int lastEndBin = 0;
                int size = starts.length;
                for (int i = 0; i < size; ++i) {
                    int true_end = ends == null ? starts[i] + 1 : ends[i];
                    float v = values[i] * normalizationFactor;
                    if (starts[i] >= endLocation) break;
                    if (true_end <= startLocation || Float.isNaN(v)) continue;
                    int s = Math.max(startLocation, starts[i]);
                    int e = Math.min(endLocation, true_end);
                    String probeName = features == null ? null : features[i];
                    int endBin = (int)((double)(e - startLocation) / scale);
                    int startBin = (int)((double)(s - startLocation) / scale);
                    if ((endBin > lastEndBin || endBin > startBin) && accumulator.hasData()) {
                        scores.add(this.getCompositeScore(accumulator, accumulatedStart, accumulatedEnd));
                        accumulator = new Accumulator(this.windowFunction, 5);
                    }
                    if (endBin > startBin) {
                        scores.add(new NamedScore(s, e, v, probeName));
                    } else {
                        if (!accumulator.hasData()) {
                            accumulatedStart = s;
                        }
                        accumulatedEnd = e;
                        accumulator.add(e - s, v, probeName);
                    }
                    lastEndBin = endBin;
                }
                if (accumulator.hasData()) {
                    scores.add(this.getCompositeScore(accumulator, accumulatedStart, accumulatedEnd));
                }
                tile.addAllScores(scores);
            }
        }
        return tile;
    }

    private LocusScore getCompositeScore(Accumulator accumulator, int accumulatedStart, int accumulatedEnd) {
        LocusScore ls;
        if (accumulator.getNpts() == 1) {
            ls = new NamedScore(accumulatedStart, accumulatedEnd, accumulator.getRepData()[0], accumulator.getRepProbes()[0]);
        } else {
            float value = accumulator.getValue();
            ls = new CompositeScore(accumulatedStart, accumulatedEnd, value, accumulator.getRepData(), accumulator.getRepProbes(), this.windowFunction);
        }
        return ls;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.windowFunction = statType;
        this.summaryTileCache.clear();
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.windowFunction;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return wfs;
    }

    @Override
    public void dispose() {
    }

    static {
        wfs.add(WindowFunction.min);
        wfs.add(WindowFunction.percentile10);
        wfs.add(WindowFunction.median);
        wfs.add(WindowFunction.mean);
        wfs.add(WindowFunction.percentile90);
        wfs.add(WindowFunction.max);
    }
}

