/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Requires;

public enum ElementKind {
    SOURCE,
    CLASS,
    INTERFACE,
    ANNOTATION_TYPE,
    ENUM,
    CONSTANT,
    FIELD,
    METHOD,
    CONSTRUCTOR,
    PARAMETER,
    INVARIANT,
    REQUIRES,
    ENSURES,
    THROW_ENSURES,
    CONTRACT_SIGNATURE,
    CONTRACT_METHOD,
    CONTRACT_MOCK;


    public boolean isType() {
        switch (this) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return true;
            }
        }
        return false;
    }

    public boolean isMember() {
        switch (this) {
            case FIELD: 
            case METHOD: 
            case CONSTRUCTOR: 
            case CONTRACT_METHOD: 
            case CONTRACT_MOCK: {
                return true;
            }
        }
        return false;
    }

    @Requires(value={"isMember()"})
    public boolean isMock() {
        switch (this) {
            case METHOD: 
            case CONSTRUCTOR: 
            case CONTRACT_MOCK: {
                return true;
            }
        }
        return false;
    }

    @Requires(value={"isMember()"})
    public boolean isContract() {
        return !this.isMock();
    }

    public boolean isAnnotation() {
        switch (this) {
            case INVARIANT: 
            case REQUIRES: 
            case ENSURES: 
            case THROW_ENSURES: 
            case CONTRACT_SIGNATURE: {
                return true;
            }
        }
        return false;
    }

    public boolean isInterfaceType() {
        switch (this) {
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return true;
            }
        }
        return false;
    }

    public boolean isSourceAnnotation() {
        switch (this) {
            case INVARIANT: 
            case REQUIRES: 
            case ENSURES: 
            case THROW_ENSURES: {
                return true;
            }
        }
        return false;
    }
}

