/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.apt.ContractCreationTrait;
import com.google.java.contract.core.apt.ContractWriter;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ContractVariance;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.util.Elements;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.JavaUtils;
import com.google.java.contract.core.util.PushbackTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContractCreation {
    static final String RAISE_METHOD = "com.google.java.contract.core.runtime.ContractRuntime.raise";

    @Requires(value={"code != null", "that != null"})
    @Ensures(value={"result != null"})
    static String rebaseLocalCalls(String string, String string2, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        PushbackTokenizer pushbackTokenizer = new PushbackTokenizer(new StringReader(string));
        boolean bl = false;
        while (pushbackTokenizer.hasNext()) {
            JavaTokenizer.Token token = pushbackTokenizer.next();
            if (!(bl || token.kind != JavaTokenizer.TokenKind.WORD || set != null && set.contains(token.text))) {
                if (token.text.equals("this")) {
                    stringBuilder.append("( ");
                    stringBuilder.append("/*[*/");
                    stringBuilder.append(string2);
                    stringBuilder.append("/*]*/");
                    stringBuilder.append(" )");
                } else if (JavaUtils.lookingAt(pushbackTokenizer, "(")) {
                    stringBuilder.append("/*[*/");
                    stringBuilder.append(string2);
                    stringBuilder.append(".");
                    stringBuilder.append("/*]*/");
                    stringBuilder.append(token.text);
                } else {
                    stringBuilder.append(token.text);
                }
            } else {
                stringBuilder.append(token.text);
            }
            bl = token.text.equals(".");
        }
        return stringBuilder.toString();
    }

    @Requires(value={"contract != null", "trait != null", "annotation != null"})
    static void addContractClauses(ContractMethodModel contractMethodModel, ContractCreationTrait contractCreationTrait, ContractAnnotationModel contractAnnotationModel) {
        ContractKind contractKind = ContractCreation.getContractKind(contractAnnotationModel);
        Iterator<String> iterator = contractCreationTrait.getExpressions().iterator();
        Iterator<String> iterator2 = contractCreationTrait.getMessages().iterator();
        Iterator<String> iterator3 = contractCreationTrait.getSourceExpressions().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = iterator.next();
            String string2 = iterator2.next();
            String string3 = iterator3.next();
            String string4 = "com$google$java$contract$local$success$" + n++;
            stringBuilder.append("boolean ");
            stringBuilder.append(string4);
            stringBuilder.append(" = false; ");
            stringBuilder.append(string4);
            stringBuilder.append(" = ");
            stringBuilder.append("/*[");
            stringBuilder.append(JavaUtils.quoteComment(string3));
            stringBuilder.append("]*/");
            if (!contractAnnotationModel.isVirtual()) {
                stringBuilder.append(ContractCreation.rebaseLocalCalls(string, "com$google$java$contract$local$that", null));
            } else {
                stringBuilder.append(string);
            }
            stringBuilder.append("; ");
            stringBuilder.append("if (!(");
            stringBuilder.append(string4);
            stringBuilder.append(")) { ");
            if (contractKind.getVariance() == ContractVariance.CONTRAVARIANT) {
                stringBuilder.append("return new ");
                stringBuilder.append(contractCreationTrait.getExceptionName());
                stringBuilder.append("(\"");
                stringBuilder.append(ContractWriter.quoteString(string2));
                stringBuilder.append("\", ");
                stringBuilder.append("com$google$java$contract$local$error");
                stringBuilder.append("); ");
            } else {
                stringBuilder.append(RAISE_METHOD);
                stringBuilder.append("(new ");
                stringBuilder.append(contractCreationTrait.getExceptionName());
                stringBuilder.append("(\"");
                stringBuilder.append(ContractWriter.quoteString(string2));
                stringBuilder.append("\"));");
            }
            stringBuilder.append("} ");
            contractMethodModel.addStatement(stringBuilder.toString());
        }
    }

    @Requires(value={"helper != null", "annotation != null"})
    static String getHelperCallCode(MethodModel methodModel, ContractAnnotationModel contractAnnotationModel) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!contractAnnotationModel.isPrimary() && !contractAnnotationModel.isVirtual()) {
            stringBuilder.append(contractAnnotationModel.getOwner().getQualifiedName() + "$com$google$java$contract$H");
            stringBuilder.append(".");
        }
        stringBuilder.append(methodModel.getSimpleName());
        stringBuilder.append("(");
        List<? extends VariableModel> list = methodModel.getParameters();
        if (!list.isEmpty()) {
            Iterator<? extends VariableModel> iterator = list.iterator();
            while (true) {
                String string;
                if ((string = iterator.next().getSimpleName()).equals("com$google$java$contract$local$that")) {
                    stringBuilder.append("this");
                } else {
                    stringBuilder.append(string);
                }
                if (!iterator.hasNext()) break;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static ContractKind getContractKind(ContractAnnotationModel contractAnnotationModel) {
        switch (contractAnnotationModel.getKind()) {
            case INVARIANT: {
                return ContractKind.INVARIANT;
            }
            case REQUIRES: {
                return ContractKind.PRE;
            }
            case ENSURES: {
                return ContractKind.POST;
            }
            case THROW_ENSURES: {
                return ContractKind.SIGNAL;
            }
        }
        throw new IllegalArgumentException();
    }

    @Requires(value={"trait != null", "annotation != null"})
    static ContractMethodModel createContractMethods(ContractCreationTrait contractCreationTrait, ContractMethodModel contractMethodModel, ContractAnnotationModel contractAnnotationModel) {
        if (!contractCreationTrait.visit(contractAnnotationModel)) {
            return null;
        }
        MethodModel methodModel = ContractCreation.createContractHelper(contractCreationTrait, contractAnnotationModel);
        return ContractCreation.createContractMethod(contractCreationTrait, contractMethodModel, contractAnnotationModel, methodModel);
    }

    @Requires(value={"kind != null", "annotation != null"})
    @Ensures(value={"result != null"})
    static ContractMethodModel createBlankContractMethod(ContractKind contractKind, ContractAnnotationModel contractAnnotationModel, String string) {
        TypeModel typeModel = Elements.getTypeOf(contractAnnotationModel);
        MethodModel methodModel = null;
        if (contractKind.isMethodContract()) {
            methodModel = (MethodModel)contractAnnotationModel.getEnclosingElement();
        }
        String string2 = contractKind.getNameSpace() + ContractCreation.getContractName(contractKind, methodModel);
        if (string != null) {
            string2 = string2 + string;
        }
        ContractMethodModel contractMethodModel = new ContractMethodModel(contractKind, string2, new TypeName("void"), methodModel);
        contractMethodModel.addModifier(ElementModifier.PRIVATE);
        typeModel.addMember(contractMethodModel);
        return contractMethodModel;
    }

    @Requires(value={"trait != null", "annotation != null", "helper != null"})
    @Ensures(value={"result != null"})
    static ContractMethodModel createContractMethod(ContractCreationTrait contractCreationTrait, ContractMethodModel contractMethodModel, ContractAnnotationModel contractAnnotationModel, MethodModel methodModel) {
        ContractKind contractKind = ContractCreation.getContractKind(contractAnnotationModel);
        if (contractMethodModel == null) {
            contractMethodModel = ContractCreation.createBlankContractMethod(contractKind, contractAnnotationModel, "");
            Elements.copyParameters(contractMethodModel, contractCreationTrait.getInitialParameters());
            if (contractKind.getVariance() == ContractVariance.CONTRAVARIANT) {
                contractMethodModel.setPrologue(contractCreationTrait.getExceptionName() + " " + "com$google$java$contract$local$error" + " = null;");
                contractMethodModel.setEpilogue("com.google.java.contract.core.runtime.ContractRuntime.raise(com$google$java$contract$local$error);");
            }
        }
        Elements.copyParameters(contractMethodModel, contractCreationTrait.getExtraParameters());
        if (contractAnnotationModel.isPrimary()) {
            contractMethodModel.setSourceInfo(contractAnnotationModel.getSourceInfo());
        }
        String string = ContractCreation.getHelperCallCode(methodModel, contractAnnotationModel) + ";";
        if (contractKind.getVariance() == ContractVariance.CONTRAVARIANT) {
            string = "com$google$java$contract$local$error = " + string + "if (" + "com$google$java$contract$local$error" + " == null) { return; }";
        }
        contractMethodModel.addStatement(string);
        return contractMethodModel;
    }

    @Requires(value={"kind != null", "annotation != null"})
    @Ensures(value={"result != null"})
    static MethodModel createBlankContractHelper(ContractKind contractKind, ContractAnnotationModel contractAnnotationModel, String string) {
        TypeModel typeModel = Elements.getTypeOf(contractAnnotationModel);
        MethodModel methodModel = null;
        ContractMethodModel contractMethodModel = null;
        MethodModel methodModel2 = null;
        if (contractKind.isMethodContract()) {
            methodModel2 = (MethodModel)contractAnnotationModel.getEnclosingElement();
        }
        TypeName typeName = new TypeName("void");
        String string2 = ContractCreation.getHelperName(contractKind, contractAnnotationModel.getOwner(), methodModel2);
        if (string != null) {
            string2 = string2 + string;
        }
        if (contractAnnotationModel.isPrimary()) {
            contractMethodModel = new ContractMethodModel(ContractKind.HELPER, string2, typeName, methodModel2);
            contractMethodModel.setSourceInfo(contractAnnotationModel.getSourceInfo());
            if (!contractAnnotationModel.isVirtual()) {
                for (TypeName typeName2 : typeModel.getTypeParameters()) {
                    contractMethodModel.addTypeParameter(typeName2);
                }
            }
            methodModel = contractMethodModel;
        } else {
            methodModel = new MethodModel(ElementKind.CONTRACT_MOCK, string2, typeName);
            if (methodModel2 != null) {
                Elements.copyParameters(methodModel, methodModel2.getParameters());
            }
        }
        if (!contractAnnotationModel.isVirtual()) {
            methodModel.addParameter(new VariableModel(ElementKind.PARAMETER, "com$google$java$contract$local$that", contractAnnotationModel.getOwner()));
        }
        if (!contractAnnotationModel.isVirtual()) {
            methodModel.addModifier(ElementModifier.PUBLIC);
            methodModel.addModifier(ElementModifier.STATIC);
        } else {
            methodModel.addModifier(ElementModifier.PROTECTED);
        }
        if (contractAnnotationModel.isPrimary() || contractAnnotationModel.isVirtual() && !contractAnnotationModel.isWeakVirtual()) {
            typeModel.addMember(methodModel);
        }
        return methodModel;
    }

    @Requires(value={"trait != null", "annotation != null"})
    @Ensures(value={"result != null"})
    static MethodModel createContractHelper(ContractCreationTrait contractCreationTrait, ContractAnnotationModel contractAnnotationModel) {
        ContractKind contractKind = ContractCreation.getContractKind(contractAnnotationModel);
        MethodModel methodModel = ContractCreation.createBlankContractHelper(contractKind, contractAnnotationModel, null);
        TypeName typeName = new TypeName(contractKind.getVariance() == ContractVariance.CONTRAVARIANT ? contractCreationTrait.getExceptionName() : "void");
        methodModel.setReturnType(typeName);
        if (contractKind.getVariance() == ContractVariance.CONTRAVARIANT) {
            methodModel.addParameter(new VariableModel(ElementKind.PARAMETER, "com$google$java$contract$local$error", typeName));
        }
        if (contractAnnotationModel.isPrimary()) {
            methodModel.setSourceInfo(contractAnnotationModel.getSourceInfo());
        }
        if (methodModel.getKind() == ElementKind.CONTRACT_METHOD) {
            ContractMethodModel contractMethodModel = (ContractMethodModel)methodModel;
            Elements.copyParameters(contractMethodModel, contractCreationTrait.getInitialParameters());
            Elements.copyParameters(contractMethodModel, contractCreationTrait.getExtraParameters());
            ContractCreation.addContractClauses(contractMethodModel, contractCreationTrait, contractAnnotationModel);
            if (contractKind.getVariance() == ContractVariance.CONTRAVARIANT) {
                contractMethodModel.setEpilogue("return null;");
            }
            if (contractAnnotationModel.isPrimary()) {
                contractMethodModel.setLineNumbers(contractAnnotationModel.getLineNumbers());
            }
        } else {
            Elements.copyParameters(methodModel, contractCreationTrait.getInitialMockParameters());
            Elements.copyParameters(methodModel, contractCreationTrait.getExtraMockParameters());
        }
        return methodModel;
    }

    @Requires(value={"kind != null", "owner != null"})
    @Ensures(value={"ClassName.isSimpleName(result)"})
    static String getHelperName(ContractKind contractKind, ClassName className, MethodModel methodModel) {
        return contractKind.getHelperNameSpace() + "$" + className.getBinaryName().replace('/', '$') + ContractCreation.getContractName(contractKind, methodModel);
    }

    @Requires(value={"kind != null", "!kind.isClassContract() || contracted == null"})
    @Ensures(value={"result.isEmpty() || ClassName.isSimpleName(result) && result.startsWith(\"$\")"})
    static String getContractName(ContractKind contractKind, MethodModel methodModel) {
        if (methodModel == null) {
            return "";
        }
        if (methodModel.isConstructor()) {
            return "$" + methodModel.getEnclosingElement().getSimpleName();
        }
        return "$" + methodModel.getSimpleName();
    }
}

