/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.interval;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.sting.gatk.iterators.PushbackIterator;
import org.broadinstitute.sting.utils.GenomeLoc;

public class OverlappingIntervalIterator
implements Iterator<GenomeLoc> {
    PushbackIterator<GenomeLoc> iter = null;
    PushbackIterator<GenomeLoc> boundBy = null;
    GenomeLoc prefetchedOverlap = null;
    GenomeLoc currentBound = null;
    GenomeLoc currentInterval = null;

    public OverlappingIntervalIterator(Iterator<GenomeLoc> intervals, Iterator<GenomeLoc> boundBy) {
        this.iter = new PushbackIterator(intervals);
        this.boundBy = new PushbackIterator(boundBy);
        if (this.iter.hasNext() && boundBy.hasNext()) {
            this.currentInterval = (GenomeLoc)this.iter.next();
            this.currentBound = boundBy.next();
            this.fetchNextOverlap();
        }
    }

    private void fetchNextOverlap() {
        this.prefetchedOverlap = null;
        while (this.currentInterval != null && this.currentBound != null) {
            if (this.currentInterval.isBefore(this.currentBound)) {
                if (!this.iter.hasNext()) {
                    this.currentInterval = null;
                    continue;
                }
                this.currentInterval = (GenomeLoc)this.iter.next();
                continue;
            }
            if (this.currentInterval.isPast(this.currentBound)) {
                if (!this.boundBy.hasNext()) {
                    this.currentBound = null;
                    continue;
                }
                this.currentBound = (GenomeLoc)this.boundBy.next();
                continue;
            }
            this.prefetchedOverlap = this.currentInterval.intersect(this.currentBound);
            this.advanceToNearest();
            break;
        }
    }

    private void advanceToNearest() {
        if (!this.iter.hasNext()) {
            this.currentBound = this.boundBy.hasNext() ? (GenomeLoc)this.boundBy.next() : null;
        } else if (!this.boundBy.hasNext()) {
            this.currentInterval = this.iter.hasNext() ? (GenomeLoc)this.iter.next() : null;
        } else {
            GenomeLoc nextBound;
            GenomeLoc nextInterval = (GenomeLoc)this.iter.next();
            if (nextInterval.compareTo(nextBound = (GenomeLoc)this.boundBy.next()) < 0) {
                this.currentInterval = nextInterval;
                this.boundBy.pushback((Object)nextBound);
            } else {
                this.currentBound = nextBound;
                this.iter.pushback((Object)nextInterval);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.prefetchedOverlap != null;
    }

    @Override
    public GenomeLoc next() {
        if (this.prefetchedOverlap == null) {
            throw new NoSuchElementException("Illegal call to next(): Overlapping iterator has no more overlaps");
        }
        GenomeLoc ret = this.prefetchedOverlap;
        this.fetchNextOverlap();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported by OverlappingIntervalIterator");
    }
}

