/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Invariant(value={"!isWeakVirtual() || isVirtual()", "getValues() != null", "!getValues().contains(null)", "Iterables.all(getLineNumbers(), Predicates.or(Predicates.isNull(), Predicates.between(1L, null)))", "getValues().size() == getLineNumbers().size()", "getOwner() != null"})
public class ContractAnnotationModel
extends ElementModel {
    protected boolean primary;
    protected boolean virtual;
    protected boolean weakVirtual;
    protected ClassName owner;
    protected TypeName returnType;
    protected List<String> values;
    protected List<Long> lineNumbers;

    @Requires(value={"kind != null", "owner != null", "kind.isSourceAnnotation()"})
    public ContractAnnotationModel(ElementKind elementKind, boolean bl, boolean bl2, ClassName className, TypeName typeName) {
        super(elementKind, "<@" + elementKind.name() + ">");
        this.primary = bl;
        this.virtual = bl2;
        this.weakVirtual = false;
        this.owner = className;
        this.returnType = typeName;
        this.values = new ArrayList<String>();
        this.lineNumbers = new ArrayList<Long>();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public ContractAnnotationModel(ContractAnnotationModel contractAnnotationModel) {
        super(contractAnnotationModel);
        this.primary = contractAnnotationModel.primary;
        this.virtual = contractAnnotationModel.virtual;
        this.weakVirtual = contractAnnotationModel.weakVirtual;
        this.owner = contractAnnotationModel.owner;
        this.returnType = contractAnnotationModel.returnType;
        this.values = new ArrayList<String>(contractAnnotationModel.values);
        this.lineNumbers = new ArrayList<Long>(contractAnnotationModel.lineNumbers);
    }

    @Override
    public ContractAnnotationModel clone() {
        return new ContractAnnotationModel(this);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isWeakVirtual() {
        return this.weakVirtual;
    }

    public void setWeakVirtual(boolean bl) {
        this.weakVirtual = bl;
    }

    public ClassName getOwner() {
        return this.owner;
    }

    public TypeName getReturnType() {
        return this.returnType;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public List<Long> getLineNumbers() {
        return Collections.unmodifiableList(this.lineNumbers);
    }

    @Ensures(value={"getValues().isEmpty()", "getLineNumbers().isEmpty()"})
    public void clearValues() {
        this.values.clear();
        this.lineNumbers.clear();
    }

    @Requires(value={"value != null"})
    @Ensures(value={"getValues().size() == old(getValues().size()) + 1", "getValues().contains(value.replace('\\r', ' ').replace('\\n', ' '))", "getLineNumbers().size() == old(getLineNumbers().size()) + 1", "getLineNumbers().contains(lineNumber)"})
    public void addValue(String string, Long l) {
        this.values.add(string.replace('\r', ' ').replace('\n', ' '));
        this.lineNumbers.add(l);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ContractAnnotationModel)) {
            return false;
        }
        ContractAnnotationModel contractAnnotationModel = (ContractAnnotationModel)object;
        return contractAnnotationModel.getKind() == this.getKind() && ((Object)contractAnnotationModel.getValues()).equals(this.getValues());
    }

    @Override
    public void accept(ElementVisitor elementVisitor) {
        elementVisitor.visitContractAnnotation(this);
    }
}

