/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.FileChannelJDKBugWorkAround;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.util.PeekIterator;
import net.sf.samtools.util.SortingCollection;

public class IlluminaBasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private static final Log log = Log.getInstance(IlluminaBasecallsConverter.class);
    public static final IlluminaDataType[] DATA_TYPES_NO_BARCODE = new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.Position, IlluminaDataType.PF};
    private static final IlluminaDataType[] DATA_TYPES_WITH_BARCODE = Arrays.copyOf(DATA_TYPES_NO_BARCODE, DATA_TYPES_NO_BARCODE.length + 1);
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR;
    private final Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator;
    private final Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap;
    private final int maxReadsInRamPerTile;
    private final boolean demultiplex;
    private final List<File> tmpDirs;
    private final IlluminaDataProviderFactory factory;
    private ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter = null;
    private final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    private final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    private int numThreads;
    private final TimerTask gcTimerTask;
    private List<Integer> tiles;
    private final SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype;
    private final Class<CLUSTER_OUTPUT_RECORD> outputRecordClass;

    public IlluminaBasecallsConverter(File basecallsDir, int lane, ReadStructure readStructure, Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int maxReadsInRamPerTile, List<File> tmpDirs, int numProcessors, boolean forceGc, Integer firstTile, Integer tileLimit, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass) {
        this.barcodeRecordWriterMap = barcodeRecordWriterMap;
        this.demultiplex = demultiplex;
        this.maxReadsInRamPerTile = maxReadsInRamPerTile;
        this.tmpDirs = tmpDirs;
        this.outputRecordComparator = outputRecordComparator;
        this.codecPrototype = codecPrototype;
        this.outputRecordClass = outputRecordClass;
        if (forceGc) {
            Timer gcTimer = new Timer(true);
            long delay = 300000L;
            this.gcTimerTask = new TimerTask(){

                @Override
                public void run() {
                    System.out.println("Before explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    System.gc();
                    System.runFinalization();
                    System.out.println("After explicit GC, Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                }
            };
            gcTimer.scheduleAtFixedRate(this.gcTimerTask, 300000L, 300000L);
        } else {
            this.gcTimerTask = null;
        }
        this.factory = new IlluminaDataProviderFactory(basecallsDir, lane, readStructure, IlluminaBasecallsConverter.getDataTypesFromReadStructure(readStructure, demultiplex));
        this.numThreads = numProcessors == 0 ? Runtime.getRuntime().availableProcessors() : (numProcessors < 0 ? Runtime.getRuntime().availableProcessors() + numProcessors : numProcessors);
        this.tiles = new ArrayList<Integer>(this.factory.getAvailableTiles());
        Collections.sort(this.tiles, TILE_NUMBER_COMPARATOR);
        if (firstTile != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != firstTile.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != firstTile.intValue()) {
                throw new PicardException("firstTile=" + firstTile + ", but that tile was not found.");
            }
        }
        if (tileLimit != null && this.tiles.size() > tileLimit) {
            this.tiles = this.tiles.subList(0, tileLimit);
        }
        this.numThreads = Math.max(1, Math.min(this.numThreads, this.tiles.size()));
    }

    public void setConverter(ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter) {
        this.converter = converter;
    }

    public IlluminaDataProviderFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTileProcessing() {
        try {
            FileChannelJDKBugWorkAround.doBugWorkAround();
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            for (Integer tileNumber : this.tiles) {
                tiles.add(new Tile(tileNumber));
            }
            TileReadAggregator tileReadAggregator = new TileReadAggregator(tiles);
            tileReadAggregator.submit();
            try {
                tileReadAggregator.awaitWorkComplete();
            }
            catch (InterruptedException e) {
                log.error(e, "Failure encountered in worker thread; attempting to shut down remaining worker threads and terminate ...");
                tileReadAggregator.shutdown();
                throw new PicardException("Failure encountered in worker thread; see log for details.");
            }
        }
        catch (Throwable throwable) {
            try {
                this.gcTimerTask.cancel();
            }
            catch (Throwable ex) {
                log.warn(ex, "Ignoring exception stopping background GC thread.");
            }
            Iterator<Map.Entry<String, ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>>> i$ = this.barcodeRecordWriterMap.entrySet().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    throw throwable;
                }
                Map.Entry<String, ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> entry = i$.next();
                ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer = entry.getValue();
                log.debug(String.format("Closing file for barcode %s.", entry.getKey()));
                writer.close();
            }
        }
        try {
            this.gcTimerTask.cancel();
        }
        catch (Throwable ex) {
            log.warn(ex, "Ignoring exception stopping background GC thread.");
        }
        Iterator<Map.Entry<String, ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>>> i$ = this.barcodeRecordWriterMap.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> entry = i$.next();
            ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer = entry.getValue();
            log.debug(String.format("Closing file for barcode %s.", entry.getKey()));
            writer.close();
        }
        return;
    }

    private static IlluminaDataType[] getDataTypesFromReadStructure(ReadStructure readStructure, boolean demultiplex) {
        if (readStructure.barcodes.isEmpty() || !demultiplex) {
            return DATA_TYPES_NO_BARCODE;
        }
        return DATA_TYPES_WITH_BARCODE;
    }

    static /* synthetic */ int access$1200(IlluminaBasecallsConverter x0) {
        return x0.numThreads;
    }

    static {
        IlluminaBasecallsConverter.DATA_TYPES_WITH_BARCODE[IlluminaBasecallsConverter.DATA_TYPES_WITH_BARCODE.length - 1] = IlluminaDataType.Barcodes;
        TILE_NUMBER_COMPARATOR = new Comparator<Integer>(){

            @Override
            public int compare(Integer integer1, Integer integer2) {
                String s1 = integer1.toString();
                String s2 = integer2.toString();
                if (s1.length() < s2.length()) {
                    if (s2.startsWith(s1)) {
                        return 1;
                    }
                } else if (s2.length() < s1.length() && s1.startsWith(s2)) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        };
    }

    public static interface ConvertedClusterDataWriter<OUTPUT_RECORD> {
        public void write(OUTPUT_RECORD var1);

        public void close();
    }

    public static interface ClusterDataConverter<OUTPUT_RECORD> {
        public OUTPUT_RECORD convertClusterToOutputRecord(ClusterData var1);
    }

    private class TileReadAggregator {
        private final Map<Tile, TileProcessingRecord> tileRecords = new TreeMap<Tile, TileProcessingRecord>();
        private final ExecutorService prioritizingThreadPool = new ThreadPoolExecutor(IlluminaBasecallsConverter.access$1200(IlluminaBasecallsConverter.this), IlluminaBasecallsConverter.access$1200(IlluminaBasecallsConverter.this), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(5, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                return ((PriorityRunnable)o2).getPriority() - ((PriorityRunnable)o1).getPriority();
            }
        }));
        private final Object completionLatch = new Object();
        private Thread parentThread;
        private final Object workEnqueueMonitor = new Object();
        private final AtomicBoolean submitted = new AtomicBoolean(false);

        public TileReadAggregator(Collection<Tile> tiles) {
            for (Tile t : tiles) {
                this.tileRecords.put(t, new TileProcessingRecord());
            }
        }

        public void submit() {
            if (!this.submitted.compareAndSet(false, true)) {
                throw new IllegalStateException("The submit() method may not be called more than once.");
            }
            this.parentThread = Thread.currentThread();
            int priority = 0;
            for (Tile tile : this.tileRecords.keySet()) {
                final TileReader reader = new TileReader(tile, this, this.tileRecords.get(tile));
                this.prioritizingThreadPool.execute(new PriorityRunnable(--priority){

                    @Override
                    public void run() {
                        try {
                            reader.process();
                        }
                        catch (RuntimeException e) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw e;
                        }
                        catch (Error e) {
                            TileReadAggregator.this.parentThread.interrupt();
                            throw e;
                        }
                    }
                });
            }
        }

        private void completeTile(Tile tile) {
            TileProcessingRecord tileRecord = this.tileRecords.get(tile);
            if (tileRecord.getState() == TileProcessingState.DONE_READING) {
                throw new IllegalStateException("This tile is already in the completed state.");
            }
            for (String barcode : tileRecord.getBarcodes()) {
                tileRecord.setBarcodeState(barcode, TileBarcodeProcessingState.READ);
            }
            tileRecord.setState(TileProcessingState.DONE_READING);
            log.debug(String.format("Completed reading tile %s; collected %s reads spanning %s barcodes.", tile.getNumber(), tileRecord.getRecordCount(), tileRecord.getBarcodeCount()));
            this.findAndEnqueueWorkOrSignalCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitWorkComplete() throws InterruptedException {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void signalWorkComplete() {
            Object object = this.completionLatch;
            synchronized (object) {
                this.completionLatch.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findAndEnqueueWorkOrSignalCompletion() {
            Object object = this.workEnqueueMonitor;
            synchronized (object) {
                if (this.isWorkCompleted()) {
                    this.signalWorkComplete();
                } else {
                    LinkedList<PriorityRunnable> tasks = new LinkedList<PriorityRunnable>();
                    block8: for (String string : IlluminaBasecallsConverter.this.barcodeRecordWriterMap.keySet()) {
                        block9: for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                            Tile tile = entry.getKey();
                            TileProcessingRecord tileRecord = entry.getValue();
                            if (tileRecord.getState() != TileProcessingState.DONE_READING) continue block8;
                            switch (tileRecord.getBarcodeState(string)) {
                                case NA: 
                                case WRITTEN: {
                                    continue block9;
                                }
                                case QUEUED_FOR_WRITE: {
                                    continue block8;
                                }
                                case READ: {
                                    tileRecord.setBarcodeState(string, TileBarcodeProcessingState.QUEUED_FOR_WRITE);
                                    log.debug(String.format("Enqueuing work for tile %s and barcode %s.", tile.getNumber(), string));
                                    tasks.add(this.newBarcodeWorkInstance(tile, tileRecord, string));
                                    continue block8;
                                }
                            }
                        }
                    }
                    for (Runnable runnable : tasks) {
                        this.prioritizingThreadPool.execute(runnable);
                    }
                }
            }
        }

        private PriorityRunnable newBarcodeWorkInstance(final Tile tile, final TileProcessingRecord tileRecord, final String barcode) {
            return new PriorityRunnable(){

                @Override
                public void run() {
                    try {
                        SortingCollection records = tileRecord.getBarcodeRecords().get(barcode);
                        ConvertedClusterDataWriter writer = (ConvertedClusterDataWriter)IlluminaBasecallsConverter.this.barcodeRecordWriterMap.get(barcode);
                        log.debug(String.format("Writing records from tile %s with barcode %s ...", tile.getNumber(), barcode));
                        PeekIterator it = new PeekIterator((Iterator)records.iterator());
                        while (it.hasNext()) {
                            Object rec = it.next();
                            if (it.hasNext()) {
                                Object lookAhead = it.peek();
                                if (IlluminaBasecallsConverter.this.outputRecordComparator.compare(rec, lookAhead) == 0) {
                                    it.next();
                                    log.info("Skipping reads with identical read names: " + rec.toString());
                                    continue;
                                }
                            }
                            writer.write(rec);
                            IlluminaBasecallsConverter.this.writeProgressLogger.record(null, 0);
                        }
                        tileRecord.setBarcodeState(barcode, TileBarcodeProcessingState.WRITTEN);
                        TileReadAggregator.this.findAndEnqueueWorkOrSignalCompletion();
                    }
                    catch (RuntimeException e) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw e;
                    }
                    catch (Error e) {
                        TileReadAggregator.this.parentThread.interrupt();
                        throw e;
                    }
                }
            };
        }

        public boolean isWorkCompleted() {
            for (Map.Entry<Tile, TileProcessingRecord> entry : this.tileRecords.entrySet()) {
                TileProcessingRecord tileProcessingRecord = entry.getValue();
                if (tileProcessingRecord.getState() != TileProcessingState.DONE_READING) {
                    log.debug(String.format("Work is not completed because a tile isn't done being read: %s.", entry.getKey().getNumber()));
                    return false;
                }
                for (Map.Entry<String, TileBarcodeProcessingState> barcodeStateEntry : tileProcessingRecord.getBarcodeProcessingStates().entrySet()) {
                    TileBarcodeProcessingState barcodeProcessingState = barcodeStateEntry.getValue();
                    if (barcodeProcessingState == TileBarcodeProcessingState.WRITTEN) continue;
                    log.debug(String.format("Work is not completed because a tile isn't done being read: Tile %s, Barcode %s, Processing State %s.", new Object[]{entry.getKey().getNumber(), barcodeStateEntry.getKey(), barcodeProcessingState}));
                    return false;
                }
            }
            log.info("All work is complete.");
            return true;
        }

        public void shutdown() {
            this.prioritizingThreadPool.shutdownNow();
        }
    }

    private class TileReader {
        private final Tile tile;
        private final TileReadAggregator handler;
        private final TileProcessingRecord processingRecord;

        public TileReader(Tile tile, TileReadAggregator handler, TileProcessingRecord processingRecord) {
            this.tile = tile;
            this.handler = handler;
            this.processingRecord = processingRecord;
        }

        public void process() {
            IlluminaDataProvider dataProvider = IlluminaBasecallsConverter.this.factory.makeDataProvider(Arrays.asList(this.tile.getNumber()));
            log.debug(String.format("Reading data from tile %s ...", this.tile.getNumber()));
            while (dataProvider.hasNext()) {
                ClusterData cluster = dataProvider.next();
                String barcode = IlluminaBasecallsConverter.this.demultiplex ? cluster.getMatchedBarcode() : null;
                IlluminaBasecallsConverter.this.readProgressLogger.record(null, 0);
                this.processingRecord.addRecord(barcode, IlluminaBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
            }
            this.handler.completeTile(this.tile);
        }
    }

    private class TileProcessingRecord {
        private final Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> barcodeToRecordCollection = new HashMap();
        private final Map<String, TileBarcodeProcessingState> barcodeToProcessingState = new HashMap<String, TileBarcodeProcessingState>();
        private TileProcessingState state = TileProcessingState.NOT_DONE_READING;
        private long recordCount = 0L;

        private TileProcessingRecord() {
        }

        public synchronized TileProcessingState getState() {
            return this.state;
        }

        public synchronized void setState(TileProcessingState state) {
            this.state = state;
        }

        public synchronized void addRecord(String barcode, CLUSTER_OUTPUT_RECORD record) {
            ++this.recordCount;
            SortingCollection recordCollection = this.barcodeToRecordCollection.get(barcode);
            if (recordCollection == null) {
                if (!IlluminaBasecallsConverter.this.barcodeRecordWriterMap.containsKey(barcode)) {
                    throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", barcode));
                }
                recordCollection = this.newSortingCollection();
                this.barcodeToRecordCollection.put(barcode, recordCollection);
                this.barcodeToProcessingState.put(barcode, null);
            }
            recordCollection.add(record);
        }

        private synchronized SortingCollection<CLUSTER_OUTPUT_RECORD> newSortingCollection() {
            int maxRecordsInRam = IlluminaBasecallsConverter.this.maxReadsInRamPerTile / IlluminaBasecallsConverter.this.barcodeRecordWriterMap.size();
            return SortingCollection.newInstance((Class)IlluminaBasecallsConverter.this.outputRecordClass, (SortingCollection.Codec)IlluminaBasecallsConverter.this.codecPrototype.clone(), (Comparator)IlluminaBasecallsConverter.this.outputRecordComparator, (int)maxRecordsInRam, (Collection)IlluminaBasecallsConverter.this.tmpDirs);
        }

        public synchronized long getBarcodeCount() {
            return this.barcodeToRecordCollection.size();
        }

        public synchronized long getRecordCount() {
            return this.recordCount;
        }

        public synchronized Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> getBarcodeRecords() {
            return this.barcodeToRecordCollection;
        }

        public synchronized TileBarcodeProcessingState getBarcodeState(String barcode) {
            if (this.getState() == TileProcessingState.NOT_DONE_READING) {
                throw new IllegalStateException("A tile's barcode data's state cannot be queried until the tile has been completely read.");
            }
            if (this.barcodeToProcessingState.containsKey(barcode)) {
                return this.barcodeToProcessingState.get(barcode);
            }
            return TileBarcodeProcessingState.NA;
        }

        public synchronized Map<String, TileBarcodeProcessingState> getBarcodeProcessingStates() {
            return this.barcodeToProcessingState;
        }

        public synchronized void setBarcodeState(String barcode, TileBarcodeProcessingState state) {
            if (!this.barcodeToProcessingState.containsKey(barcode)) {
                throw new NoSuchElementException(String.format("No record of the provided barcode, %s.", barcode));
            }
            this.barcodeToProcessingState.put(barcode, state);
        }

        public synchronized Set<String> getBarcodes() {
            return this.getBarcodeRecords().keySet();
        }
    }

    private abstract class PriorityRunnable
    implements Runnable {
        private final int priority;

        public PriorityRunnable() {
            this(1);
        }

        public PriorityRunnable(int priority) {
            this.priority = priority;
        }

        int getPriority() {
            return this.priority;
        }
    }

    private static class Tile
    implements Comparable<Tile> {
        private final int tileNumber;

        public Tile(int i) {
            this.tileNumber = i;
        }

        public int getNumber() {
            return this.tileNumber;
        }

        public boolean equals(Object o) {
            return o instanceof Tile && this.getNumber() == ((Tile)o).getNumber();
        }

        @Override
        public int compareTo(Tile o) {
            return TILE_NUMBER_COMPARATOR.compare(this.getNumber(), o.getNumber());
        }
    }

    private static enum TileProcessingState {
        NOT_DONE_READING,
        DONE_READING;

    }

    private static enum TileBarcodeProcessingState {
        NA,
        READ,
        QUEUED_FOR_WRITE,
        WRITTEN;

    }
}

