/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gitools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.Globals;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.collections.DoubleArrayList;

public class Gitools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTDM(List<String> lociStrings, File file) throws IOException {
        int averageFeatureSize = 0;
        ArrayList<NamedFeature> loci = new ArrayList<NamedFeature>(lociStrings.size());
        for (String l : lociStrings) {
            NamedFeature feature = FeatureDB.getFeature(l);
            if (feature == null) {
                feature = Locus.fromString(l);
            }
            if (feature == null) continue;
            loci.add(feature);
            averageFeatureSize += feature.getEnd() - feature.getStart();
        }
        if (loci.size() > 0) {
            averageFeatureSize /= loci.size();
        }
        LinkedHashSet<TrackType> loadedTypes = new LinkedHashSet<TrackType>();
        LinkedHashSet<String> samples = new LinkedHashSet<String>();
        List<Track> tracks = IGV.getInstance().getAllTracks();
        for (Track t : tracks) {
            if (!(t instanceof DataTrack) && t.getTrackType() != TrackType.MUTATION || !t.isVisible()) continue;
            loadedTypes.add(t.getTrackType());
            samples.add(t.getSample());
        }
        int zoom = 0;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome != null) {
            double averageChrLength = genome.getTotalLength() / (long)genome.getChromosomes().size();
            zoom = (int)(Math.log(averageChrLength / (double)averageFeatureSize) / Globals.log2) + 1;
        }
        LinkedHashMap<String, SampleData> sampleDataMap = new LinkedHashMap<String, SampleData>();
        for (Track t : tracks) {
            if (!t.isVisible() || !(t instanceof DataTrack)) continue;
            DataTrack dataTrack = (DataTrack)t;
            for (NamedFeature locus : loci) {
                double regionScore = dataTrack.getAverageScore(locus.getChr(), locus.getStart(), locus.getEnd(), zoom);
                if (Double.isNaN(regionScore)) continue;
                String sample = t.getSample();
                String locusString = locus.getName();
                String key = sample + "_" + locusString;
                SampleData sd = (SampleData)sampleDataMap.get(key);
                if (sd == null) {
                    sd = new SampleData(sample, locusString);
                    sampleDataMap.put(key, sd);
                }
                sd.addValue(t.getTrackType(), regionScore);
            }
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.print("Sample\tLocus");
            for (TrackType tt : loadedTypes) {
                pw.print("\t" + tt.name());
            }
            pw.println();
            for (SampleData sd : sampleDataMap.values()) {
                pw.print(sd.sample + "\t" + sd.locus);
                for (TrackType tt : loadedTypes) {
                    pw.print('\t');
                    double[] values = sd.getValues(tt);
                    if (values == null) {
                        pw.print("-");
                        continue;
                    }
                    double avg = StatUtils.max(values);
                    pw.print(avg);
                }
                pw.println();
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    static class SampleData {
        String sample;
        String locus;
        Map<TrackType, DoubleArrayList> valueMap;

        SampleData(String sample, String locus) {
            this.sample = sample;
            this.locus = locus;
            this.valueMap = new HashMap<TrackType, DoubleArrayList>();
        }

        void addValue(TrackType tt, double value) {
            DoubleArrayList vlist = this.valueMap.get((Object)tt);
            if (vlist == null) {
                vlist = new DoubleArrayList();
                this.valueMap.put(tt, vlist);
            }
            vlist.add(value);
        }

        public double[] getValues(TrackType tt) {
            DoubleArrayList dal = this.valueMap.get((Object)tt);
            return dal == null ? null : dal.toArray();
        }
    }
}

