/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broad.igv.Globals;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ucsc.hub.Hub;
import org.broad.igv.ucsc.hub.Stanza;
import org.broad.igv.util.ParsingUtils;

public class HubParser {
    private static Logger log = LogManager.getLogger(HubParser.class);
    static Map<String, List<String>> hubURLMap = null;
    private static Set<String> urlProperties = new HashSet<String>(Arrays.asList("descriptionUrl", "desriptionUrl", "twoBitPath", "blat", "chromAliasBb", "twoBitBptURL", "twoBitBptUrl", "htmlPath", "bigDataUrl", "genomesFile", "trackDb", "groups", "include", "html", "searchTrix", "groups", "chromSizes"));

    public static Hub loadAssemblyHub(String url) throws IOException {
        return HubParser.loadHub(url, null);
    }

    public static Hub loadHub(String url, String genomeId) throws IOException {
        log.info("Loading Hub: " + url);
        List<Stanza> stanzas = HubParser.loadStanzas(url);
        if (stanzas.size() < 1) {
            throw new RuntimeException("Expected at least 1 stanza");
        }
        if (!"hub".equals(stanzas.get((int)0).type)) {
            throw new RuntimeException("Unexpected hub.txt file -- does the first line start with 'hub'?");
        }
        Stanza hubStanza = stanzas.get(0);
        Stanza genomeStanza = null;
        ArrayList<Stanza> trackStanzas = null;
        List<Stanza> groupStanzas = null;
        String trackDbURL = null;
        if ("on".equals(stanzas.get(0).getProperty("useOneFile"))) {
            if (!"genome".equals(stanzas.get((int)1).type)) {
                throw new RuntimeException("Unexpected hub file -- expected 'genome' stanza but found " + stanzas.get((int)1).type);
            }
            genomeStanza = stanzas.get(1);
            if (!genomeStanza.hasProperty("twoBitPath") && !genomeStanza.getProperty("genome").equals(genomeId)) {
                throw new RuntimeException("Hub file does not contain tracks for genome " + genomeId);
            }
            trackStanzas = new ArrayList<Stanza>(stanzas.subList(2, stanzas.size()));
        } else {
            if (!hubStanza.hasProperty("genomesFile")) {
                throw new RuntimeException("hub.txt must specify 'genomesFile'");
            }
            List<Stanza> genomeStanzaList = HubParser.loadStanzas(hubStanza.getProperty("genomesFile"));
            for (Stanza s : genomeStanzaList) {
                if (genomeId != null && !genomeId.equals(s.getProperty("genome"))) continue;
                stanzas.add(s);
                genomeStanza = s;
                trackDbURL = genomeStanza.getProperty("trackDb");
                break;
            }
            if (trackDbURL == null) {
                throw new RuntimeException("Hub file does not contain tracks for genome " + genomeId);
            }
        }
        if (genomeId == null && !genomeStanza.hasProperty("twoBitPath")) {
            throw new RuntimeException("Assembly hubs must specify 'twoBitPath'");
        }
        if (genomeStanza.hasProperty("groups") && genomeStanza.hasProperty("groups")) {
            String groupsTxtURL = genomeStanza.getProperty("groups");
            groupStanzas = HubParser.loadStanzas(groupsTxtURL);
        }
        Hub hub = new Hub(url, trackDbURL, hubStanza, genomeStanza, trackStanzas, groupStanzas);
        return hub;
    }

    public static List<Hub> loadHubs(String ucscId, List<String> hubUrls) {
        ArrayList<Hub> trackHubs = new ArrayList<Hub>();
        List<CompletableFuture> futures = IntStream.range(0, hubUrls.size()).parallel().mapToObj(i -> CompletableFuture.supplyAsync(() -> {
            try {
                int order = i + 1;
                Hub hub = HubParser.loadHub((String)hubUrls.get(i), ucscId);
                hub.setOrder(order);
                trackHubs.add(hub);
            }
            catch (Exception e) {
                log.error("Error loading hub " + (String)hubUrls.get(i), e);
            }
            return null;
        })).collect(Collectors.toList());
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            combinedFuture.get(20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("Error loading hubs", e);
        }
        Collections.sort(trackHubs, (h1, h2) -> h1.getOrder() - h2.getOrder());
        return trackHubs;
    }

    public static Map<String, List<String>> getHubURLs() {
        if (hubURLMap == null) {
            String filePath = PreferencesManager.getPreferences().get("AUXILLARY_HUBS_URL");
            hubURLMap = new HashMap<String, List<String>>();
            try (BufferedReader br = ParsingUtils.openBufferedReader(filePath);){
                String line;
                String currentGenomeId = null;
                ArrayList<String> currentURLList = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    line = line.trim();
                    if (currentGenomeId == null) {
                        currentGenomeId = line;
                        currentURLList = new ArrayList<String>();
                        hubURLMap.put(currentGenomeId, currentURLList);
                        continue;
                    }
                    if (line.length() == 0) {
                        currentGenomeId = null;
                        continue;
                    }
                    currentURLList.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return hubURLMap;
    }

    static List<Stanza> loadStanzas(String url) throws IOException {
        int idx = url.lastIndexOf("/");
        String baseURL = url.substring(0, idx + 1);
        String host = HubParser.getHost(url);
        ArrayList<Stanza> nodes = new ArrayList<Stanza>();
        Stanza currentNode = null;
        boolean startNewNode = true;
        boolean order = false;
        try (BufferedReader br = ParsingUtils.openBufferedReader(url);){
            Object line;
            while ((line = br.readLine()) != null) {
                int indent;
                int i;
                String continuation;
                if (((String)line).startsWith("#")) continue;
                while (((String)line).endsWith("\\") && (continuation = br.readLine()) != null) {
                    line = ((String)line).substring(0, ((String)line).length() - 1) + " " + continuation.trim();
                }
                if (((String)line).startsWith("include")) {
                    String relativeURL = ((String)line).substring(8).trim();
                    String includeURL = HubParser.getDataURL(relativeURL, host, baseURL);
                    List<Stanza> includeStanzas = HubParser.loadStanzas(includeURL);
                    nodes.addAll(includeStanzas);
                }
                if ((i = ((String)line).indexOf(" ", indent = HubParser.indentLevel((String)line))) < 0) {
                    startNewNode = true;
                    continue;
                }
                String key = ((String)line).substring(indent, i);
                if (key.startsWith("#")) continue;
                String value = ((String)line).substring(i + 1).trim();
                if ("type".equals(key)) {
                    tokens = Globals.whitespacePattern.split(value);
                    if ("bigWig".equals(value = tokens[0]) && tokens.length == 3) {
                        String min = tokens[1];
                        String max = tokens[2];
                        if (currentNode != null) {
                            currentNode.properties.put("min", min);
                            currentNode.properties.put("max", max);
                        }
                    }
                } else if (!("shortLabel".equals(key) || "longLabel".equals(key) || "metadata".equals(key) || "label".equals(key))) {
                    tokens = Globals.whitespacePattern.split(value);
                    value = tokens[0];
                }
                if (urlProperties.contains(key) || value.endsWith("URL") || value.endsWith("Url")) {
                    value = HubParser.getDataURL(value, host, baseURL);
                }
                if (startNewNode) {
                    Stanza newNode = new Stanza(key, value);
                    nodes.add(newNode);
                    currentNode = newNode;
                    startNewNode = false;
                }
                currentNode.properties.put(key, value);
            }
        }
        return HubParser.resolveParents(nodes);
    }

    private static int indentLevel(String str) {
        char c;
        int level;
        for (level = 0; level < str.length() && ((c = str.charAt(level)) == ' ' || c == '\t'); ++level) {
        }
        return level;
    }

    private static List<Stanza> resolveParents(List<Stanza> nodes) {
        HashMap<String, Stanza> nodeMap = new HashMap<String, Stanza>();
        for (Stanza n : nodes) {
            nodeMap.put(n.name, n);
        }
        for (Stanza n : nodes) {
            if (!n.properties.containsKey("parent")) continue;
            String parentName = HubParser.firstWord(n.properties.get("parent"));
            n.parent = (Stanza)nodeMap.get(parentName);
            n.properties.put("parent", parentName);
        }
        return nodes;
    }

    static String firstWord(String str) {
        return Globals.whitespacePattern.split(str)[0];
    }

    private static String getDataURL(String url, String host, String baseURL) {
        return url.startsWith("http://") || url.startsWith("https://") ? url : (url.startsWith("/") ? host + url : baseURL + url);
    }

    private static String getHost(String url) {
        Object host;
        if (url.startsWith("https://") || url.startsWith("http://")) {
            try {
                URL tmp = new URL(url);
                host = tmp.getProtocol() + "://" + tmp.getHost();
            }
            catch (MalformedURLException e) {
                log.error("Error parsing base URL host", e);
                throw new RuntimeException(e);
            }
        } else {
            host = "";
        }
        return host;
    }
}

