/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDownloadUtils;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ucsc.hub.Hub;
import org.broad.igv.ucsc.hub.HubParser;
import org.broad.igv.ucsc.hub.TrackConfigContainer;
import org.broad.igv.ucsc.hub.TrackHubSelectionDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;

public class HubGenomeLoader
extends GenomeLoader {
    static Logger log = LogManager.getLogger(HubGenomeLoader.class);
    String hubURL;

    public static boolean isHubURL(String obj) {
        return obj != null && obj.toLowerCase().endsWith("hub.txt");
    }

    public static String convertToHubURL(String accension) {
        if (accension.startsWith("GCF") || accension.startsWith("GCA") && accension.length() >= 13) {
            String prefix = accension.substring(0, 3);
            String n1 = accension.substring(4, 7);
            String n2 = accension.substring(7, 10);
            String n3 = accension.substring(10, 13);
            return "https://hgdownload.soe.ucsc.edu/hubs/" + prefix + "/" + n1 + "/" + n2 + "/" + n3 + "/" + accension + "/hub.txt";
        }
        return null;
    }

    public static void loadGenome(final String hubURL) throws IOException {
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        SwingWorker<File, Void> worker = new SwingWorker<File, Void>(){

            @Override
            protected File doInBackground() throws Exception {
                File genomeFile = null;
                try {
                    Hub hub = HubParser.loadAssemblyHub(hubURL);
                    GenomeConfig config = HubGenomeLoader.getGenomeConfig(hub);
                    if (config != null) {
                        genomeFile = GenomeDownloadUtils.saveLocalGenome(config);
                    }
                }
                catch (Exception e) {
                    log.error("Error loading hub: " + e.getMessage());
                    MessageUtils.showMessage("Error loading hub: " + e.getMessage());
                }
                return genomeFile;
            }

            @Override
            protected void done() {
                try {
                    File genomeFile = (File)this.get();
                    if (genomeFile != null) {
                        WaitCursorManager.removeWaitCursor(token);
                        GenomeManager.getInstance().loadGenome(genomeFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    log.error("Error loading hub: " + e.getMessage());
                    MessageUtils.showMessage("Error loading hub: " + e.getMessage());
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }
        };
        worker.execute();
    }

    public static void loadAssemblyHub(Hub hub) throws IOException {
        GenomeConfig config = HubGenomeLoader.getGenomeConfig(hub);
        if (config != null) {
            File genomeFile = GenomeDownloadUtils.saveLocalGenome(config);
            GenomeManager.getInstance().loadGenome(genomeFile.getAbsolutePath());
        }
    }

    private static GenomeConfig getGenomeConfig(Hub hub) throws IOException {
        GenomeConfig config = hub.getGenomeConfig();
        String key = "hub:" + hub.getUrl();
        List<TrackConfigContainer> groupedTrackConfigurations = hub.getGroupedTrackConfigurations();
        if (PreferencesManager.getPreferences().hasExplicitValue(key)) {
            HashSet<String> selectedTrackNames = new HashSet<String>(Arrays.asList(PreferencesManager.getPreferences().get(key).split(",")));
            List<TrackConfig> selectedTracks = groupedTrackConfigurations.stream().flatMap(group -> group.tracks.stream()).filter(trackConfig -> selectedTrackNames.contains(trackConfig.name)).collect(Collectors.toList());
            config.setTracks(selectedTracks);
        } else if (IGV.hasInstance() && !Globals.isBatch() && !Globals.isHeadless() && !Globals.isTesting()) {
            TrackHubSelectionDialog dlg = TrackHubSelectionDialog.getTrackHubSelectionDialog(hub, null, true, "Select default annotation tracks for this genome.  You can change these selections later using the 'Genomes > Select Genome Annotations...' menu.");
            boolean dlgSuccess = true;
            try {
                UIUtilities.invokeAndWaitOnEventThread(() -> dlg.setVisible(true));
            }
            catch (Exception e) {
                dlgSuccess = false;
                log.error("Error opening or using TrackHubSelectionDialog: " + e.getMessage());
            }
            if (dlg.isCanceled() || !dlgSuccess) {
                return null;
            }
            List<TrackConfig> selectedTracks = dlg.getSelectedConfigs();
            config.setTracks(selectedTracks);
        }
        config.setHubs(Arrays.asList(hub.getUrl()));
        Genome genome = new Genome(config);
        genome.setGenomeHub(hub);
        return config;
    }

    public HubGenomeLoader(String hubURL) {
        this.hubURL = hubURL;
    }

    @Override
    public Genome loadGenome() throws IOException {
        Hub hub = HubParser.loadAssemblyHub(this.hubURL);
        GenomeConfig config = HubGenomeLoader.getGenomeConfig(hub);
        if (config == null) {
            return GenomeManager.getInstance().getCurrentGenome();
        }
        String key = "hub:" + this.hubURL;
        if (PreferencesManager.getPreferences().hasExplicitValue(key)) {
            ArrayList<TrackConfig> selectedTracks = new ArrayList<TrackConfig>();
            HashSet<String> selectedTrackNames = new HashSet<String>(Arrays.asList(PreferencesManager.getPreferences().get(key).split(",")));
            List<TrackConfigContainer> trackConfigGroups = hub.getGroupedTrackConfigurations();
            for (TrackConfigContainer group : trackConfigGroups) {
                List<TrackConfig> trackConfigs = group.findTracks(trackConfig -> selectedTrackNames.contains(trackConfig.name));
                for (TrackConfig trackConfig2 : trackConfigs) {
                    if (!selectedTrackNames.contains(trackConfig2.name)) continue;
                    selectedTracks.add(trackConfig2);
                }
            }
            config.setTracks(selectedTracks);
        }
        GenomeDownloadUtils.saveLocalGenome(config);
        PreferencesManager.getPreferences().remove(key);
        GenomeListManager.getInstance().removeRemoteItem(config.getId());
        Genome genome = new Genome(config);
        genome.setGenomeHub(hub);
        return genome;
    }
}

