/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;

class Stanza {
    private static Set<String> parentOverrideProperties = new HashSet<String>(Arrays.asList("visibility", "priority", "group"));
    private static Set<String> inheritableProperties = new HashSet<String>(Arrays.asList("group", "priority", "color", "altColor", "autoscale", "autoScale", "viewLimits", "negativeValues", "maxWindowToQuery", "transformFun", "windowingFunction", "yLineMark", "yLineOnOff", "graphTypeDefault", "interactUp", "interactMultiRegion", "endsVisible", "maxHeightPixels", "scoreMin", "scoreFilter", "scoreFilterLimits", "minAliQual", "bamColorTag", "bamColorMode", "bamGrayMode", "colorByStrand", "itemRgb", "html"));
    final String type;
    final String name;
    Stanza parent;
    Map<String, String> properties;

    Stanza(String type, String name) {
        this.type = type;
        this.name = name;
        this.properties = new HashMap<String, String>();
    }

    static String firstWord(String str) {
        return Globals.whitespacePattern.split(str)[0];
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    String getOwnProperty(String key) {
        return this.properties.get(key);
    }

    boolean hasOwnProperty(String key) {
        return this.getProperty(key) != null;
    }

    String getProperty(String key) {
        if (this.properties.containsKey("noInherit")) {
            return this.properties.get(key);
        }
        if (parentOverrideProperties.contains(key) && this.parent != null && this.parent.hasProperty(key)) {
            return this.parent.getProperty(key);
        }
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        if (this.parent != null) {
            if (inheritableProperties.contains(key)) {
                return this.parent.getProperty(key);
            }
        }
        return null;
    }

    boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    String format() {
        String type = this.getOwnProperty("type");
        if (type != null) {
            return Stanza.firstWord(type);
        }
        return null;
    }

    public Stanza getParent() {
        return this.parent;
    }

    public void setParent(Stanza parent) {
        this.parent = parent;
    }

    public Stanza getAncestor() {
        if (this.parent != null) {
            return this.parent.getAncestor();
        }
        return this;
    }
}

