/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEP = System.getProperty("file.separator");
    static final String[] igvJnlpPrefixes = new String[]{"igv", "ichip", "29mammals", "hic"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void searchAndReplace(File inputDirectory, File outputDirectory, String str1, String str2) throws IOException {
        for (File in : inputDirectory.listFiles()) {
            if (in.isDirectory() || in.isHidden()) continue;
            File of = new File(outputDirectory, in.getName());
            BufferedReader reader = null;
            PrintWriter pw = null;
            try {
                String nextLine;
                reader = new BufferedReader(new FileReader(in));
                pw = new PrintWriter(new BufferedWriter(new FileWriter(of)));
                while ((nextLine = reader.readLine()) != null) {
                    nextLine = nextLine.replaceAll(str1, str2);
                    pw.println(nextLine);
                }
            }
            finally {
                reader.close();
                pw.close();
            }
        }
    }

    public static boolean resourceExists(String path) {
        try {
            boolean remoteFile = FileUtils.isRemote(path);
            return !remoteFile && new File(path).exists() || remoteFile && HttpUtils.getInstance().resourceAvailable(new URL(path));
        }
        catch (IOException e) {
            log.error("Malformed URL: " + path, e);
            return false;
        }
    }

    public static boolean isRemote(String path) {
        if (path == null) {
            return false;
        }
        return path.startsWith("http://") || path.startsWith("https://") || path.startsWith("ftp://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWriteTo(File file) {
        Object fos = null;
        try {
            file.createNewFile();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            file.delete();
        }
    }

    public static String getInstallDirectory() {
        String path = FileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File f = new File(path);
        if (f.isDirectory()) {
            return f.getAbsolutePath();
        }
        return f.getParentFile().getAbsolutePath();
    }

    public static String getRelativePath(String basePath, String targetPath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator(targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator(basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix(normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix(normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows(normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows(normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    public static String getPlatformIndependentPath(String path) {
        return path.replace('\\', '/');
    }

    public static String getRelativePath(String basePath, String targetPath) {
        return FileUtils.getRelativePath(basePath, targetPath, FILE_SEP);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixEOL(String ifile, String ofile) {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(ifile));
            pw = new PrintWriter(new FileWriter(ofile));
            while ((nextLine = br.readLine()) != null) {
                pw.println(nextLine);
            }
            br.close();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAscii(ResourceLocator loc) throws IOException {
        InputStream in = null;
        CharsetDecoder d = Charset.forName("US-ASCII").newDecoder();
        try {
            in = ParsingUtils.openInputStreamGZ(loc);
            byte[] bytes = new byte[1024];
            int nBytes = in.read(bytes);
            while (nBytes > 0) {
                for (int i = 0; i < nBytes; ++i) {
                    byte j = bytes[i];
                    if (j >= 1 && j <= 127) continue;
                    boolean bl = false;
                    return bl;
                }
                nBytes = in.read(bytes);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTabDelimited(ResourceLocator loc, int minColumnCount) throws IOException {
        BufferedReader reader = null;
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(loc.getPath());
            int nLinesTested = 0;
            while ((nextLine = reader.readLine()) != null && nLinesTested < 5) {
                if (nextLine.startsWith("#")) continue;
                ++nLinesTested;
                String[] tokens = nextLine.split("\t");
                if (tokens.length < minColumnCount) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = nLinesTested > 1;
            return bl;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File inputFile, File outputFile) throws IOException {
        int totalSize = 0;
        OutputStream out = null;
        FileInputStream in = null;
        try {
            int bytes_read;
            in = new FileInputStream(inputFile);
            out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[64000];
            while ((bytes_read = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
                totalSize += bytes_read;
            }
        }
        catch (Exception e) {
            outputFile.delete();
            MessageUtils.showMessage("<html>Error copying file: " + outputFile.getAbsoluteFile() + "<br/>" + e.toString());
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceStrings(File inputFile, File outputFile, Map<String, String> replace) throws IOException {
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            String nextLine;
            reader = new BufferedReader(new FileReader(inputFile));
            writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = reader.readLine()) != null) {
                for (Map.Entry<String, String> entry : replace.entrySet()) {
                    nextLine = nextLine.replace(entry.getKey(), entry.getValue());
                }
                writer.println(nextLine);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    public static void cleanupJnlpFiles() {
        if (Globals.IS_MAC) {
            File downloads;
            File desktop = new File(System.getProperty("user.home") + "/Desktop");
            if (desktop.exists() && desktop.isDirectory()) {
                FileUtils.cleanup(desktop);
            }
            if ((downloads = new File(System.getProperty("user.home") + "/Downloads")).exists() && downloads.isDirectory()) {
                FileUtils.cleanup(downloads);
            }
        }
    }

    private static void cleanup(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] jnlpFiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    String name = arg0.getName();
                    for (String pre : igvJnlpPrefixes) {
                        if (!name.startsWith(pre) || !name.endsWith(".jnlp")) continue;
                        return true;
                    }
                    return false;
                }
            });
            Arrays.sort(jnlpFiles, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    if (org.apache.commons.io.FileUtils.isFileNewer(file1, file2)) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (int i = 0; i < jnlpFiles.length - 1; ++i) {
                jnlpFiles[i].delete();
            }
            if (jnlpFiles.length > 1) {
                File newestFile = jnlpFiles[jnlpFiles.length - 1];
                String fn = newestFile.getName();
                int dotIndex = fn.indexOf(".jnlp");
                int dashIndex = fn.lastIndexOf("-");
                if (dashIndex > 1) {
                    String newName = fn.substring(0, dashIndex) + fn.substring(dotIndex);
                    newestFile.renameTo(new File(newestFile.getParentFile(), newName));
                }
            }
        }
    }

    public static String getFileExtension(String filePath) {
        String extension = null;
        int indexOfExtension = filePath.lastIndexOf(".");
        if (indexOfExtension >= 0) {
            extension = filePath.substring(indexOfExtension, filePath.length());
        }
        return extension;
    }

    public static String getAbsolutePath(String inputPath, String referencePath) {
        String absolutePath;
        if (FileUtils.isRemote(inputPath)) {
            return inputPath;
        }
        File inFile = new File(inputPath);
        if (inFile.isAbsolute()) {
            return inFile.getAbsolutePath();
        }
        if (FileUtils.isRemote(referencePath)) {
            int idx = referencePath.lastIndexOf("/");
            String basePath = referencePath.substring(0, idx);
            absolutePath = basePath + "/" + inputPath;
        } else {
            File parent = new File(referencePath).getParentFile();
            File file = new File(parent, inputPath);
            absolutePath = file.getAbsolutePath();
        }
        return absolutePath;
    }

    public static long getModifiedDate(String file) {
        if (file.startsWith("http://") || file.startsWith("https://")) {
            try {
                String lastModified = HttpUtils.getInstance().getHeaderField(new URL(file), "Last-Modified");
                return Integer.parseInt(lastModified);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        if (file.startsWith("ftp://")) {
            return 0L;
        }
        File f = new File(file);
        return f.exists() ? f.lastModified() : 0L;
    }

    public static String getParent(String path) {
        String piPath = FileUtils.getPlatformIndependentPath(path);
        int lastSlashIdx = piPath.lastIndexOf("/");
        return lastSlashIdx <= 0 ? path : path.substring(0, lastSlashIdx);
    }

    public static String findExecutableOnPath(String executable) {
        if (executable.contains(File.separator)) {
            return executable;
        }
        String systemPath = System.getenv("PATH");
        if (systemPath == null) {
            systemPath = System.getenv("path");
        }
        String[] pathDirs = systemPath.split(File.pathSeparator);
        String fullPath = executable;
        for (String pathDir : pathDirs) {
            File file = new File(pathDir, executable);
            if (!file.isFile()) continue;
            fullPath = file.getAbsolutePath();
            break;
        }
        return fullPath;
    }

    public static URL[] getURLsFromString(String libs, String rootPath) {
        String[] sLibs = libs.split(":");
        ArrayList<URL> libURLList = new ArrayList<URL>(sLibs.length);
        String pluginDir = new File(rootPath).getParent();
        for (String s : sLibs) {
            File fi = new File(pluginDir, s);
            try {
                libURLList.add(new URL("file:" + fi.getAbsolutePath()));
            }
            catch (MalformedURLException e) {
                log.error("Error adding to libs: " + fi.getAbsolutePath());
                log.error(e);
            }
        }
        return libURLList.toArray(new URL[0]);
    }
}

