/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentPacker;
import org.broad.igv.sam.AlignmentTileLoader;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ArrayHeapObjectSorter;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.CachedIntervals;

public class AlignmentDataManager {
    private static Logger log = Logger.getLogger(AlignmentDataManager.class);
    private static final int DEFAULT_DEPTH = 10;
    private CachedIntervals<AlignmentInterval> loadedIntervalMap = new CachedIntervals(5, 1000000);
    private HashMap<String, String> chrMappings = new HashMap();
    private volatile boolean isLoading = false;
    private AlignmentTileLoader reader;
    private CoverageTrack coverageTrack;
    private static final int MAX_ROWS = 1000000;
    private Map<String, PEStats> peStats;
    private AlignmentTrack.ExperimentType experimentType;
    private boolean showSpliceJunctions;
    static final int CACHE_SIZE = 5;
    static final int MAX_INTERVAL_MULTIPLE = 3;
    static int n = 1;

    public AlignmentDataManager(ResourceLocator locator, Genome genome) throws IOException {
        PreferenceManager prefs = PreferenceManager.getInstance();
        this.reader = new AlignmentTileLoader(AlignmentReaderFactory.getReader(locator));
        this.peStats = new HashMap<String, PEStats>();
        this.showSpliceJunctions = prefs.getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
        this.initChrMap(genome);
    }

    public void updateGenome(Genome genome) {
        this.chrMappings.clear();
        this.initChrMap(genome);
    }

    public void setShowSpliceJunctions(boolean showSpliceJunctions) {
        this.showSpliceJunctions = showSpliceJunctions;
    }

    private void initChrMap(Genome genome) {
        List<String> seqNames;
        if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
            for (String chr : seqNames) {
                String alias = genome.getChromosomeAlias(chr);
                this.chrMappings.put(alias, chr);
            }
        }
    }

    public void setExperimentType(AlignmentTrack.ExperimentType experimentType) {
        this.experimentType = experimentType;
        this.showSpliceJunctions = experimentType == AlignmentTrack.ExperimentType.BISULFITE ? false : PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
    }

    public AlignmentTrack.ExperimentType getExperimentType() {
        return this.experimentType;
    }

    public AlignmentTileLoader getReader() {
        return this.reader;
    }

    public Map<String, PEStats> getPEStats() {
        return this.peStats;
    }

    public boolean isPairedEnd() {
        return this.reader.isPairedEnd();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
    }

    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public boolean isIonTorrent() {
        Set<String> platforms = this.reader.getPlatforms();
        if (platforms != null) {
            return platforms.contains("IONTORRENT");
        }
        return false;
    }

    public Collection<AlignmentInterval> getLoadedIntervals(ReferenceFrame frame) {
        return this.loadedIntervalMap.get(frame.getChrName());
    }

    public void sortRows(AlignmentTrack.SortOption option, ReferenceFrame referenceFrame, double location, String tag) {
        List<AlignmentInterval> loadedIntervals = this.loadedIntervalMap.get(referenceFrame.getChrName());
        if (loadedIntervals == null) {
            return;
        }
        for (AlignmentInterval loadedInterval : loadedIntervals) {
            if (loadedInterval == null) continue;
            loadedInterval.sortRows(option, location, tag);
        }
    }

    public void setViewAsPairs(boolean option, AlignmentTrack.RenderOptions renderOptions) {
        if (option == renderOptions.isViewPairs()) {
            return;
        }
        boolean currentPairState = renderOptions.isViewPairs();
        renderOptions.setViewPairs(option);
        for (ReferenceFrame frame : FrameManager.getFrames()) {
            this.repackAlignments(frame, currentPairState, renderOptions);
        }
    }

    private void repackAlignments(ReferenceFrame referenceFrame, boolean currentPairState, AlignmentTrack.RenderOptions renderOptions) {
        if (currentPairState) {
            List<AlignmentInterval> loadedIntervals = this.loadedIntervalMap.get(referenceFrame.getChrName());
            if (loadedIntervals == null) {
                return;
            }
            for (AlignmentInterval loadedInterval : loadedIntervals) {
                LinkedHashMap<String, List<AlignmentInterval.Row>> groupedAlignments = loadedInterval.getGroupedAlignments();
                ArrayList<Alignment> alignments = new ArrayList<Alignment>(Math.min(50000, groupedAlignments.size() * 10000));
                for (List alignmentRows : groupedAlignments.values()) {
                    for (AlignmentInterval.Row row : alignmentRows) {
                        for (Alignment al : row.alignments) {
                            if (al instanceof PairedAlignment) {
                                PairedAlignment pair = (PairedAlignment)al;
                                alignments.add(pair.firstAlignment);
                                if (pair.secondAlignment == null) continue;
                                alignments.add(pair.secondAlignment);
                                continue;
                            }
                            alignments.add(al);
                        }
                    }
                }
                ArrayHeapObjectSorter<Alignment> heapSorter = new ArrayHeapObjectSorter<Alignment>();
                heapSorter.sort(alignments, new Comparator<Alignment>(){

                    @Override
                    public int compare(Alignment alignment, Alignment alignment1) {
                        return alignment.getStart() - alignment1.getStart();
                    }
                });
                int max = Integer.MAX_VALUE;
                LinkedHashMap<String, List<AlignmentInterval.Row>> tmp = new AlignmentPacker().packAlignments(alignments.iterator(), loadedInterval.getEnd(), renderOptions);
                loadedInterval.setAlignmentRows(tmp, renderOptions);
            }
        } else {
            this.repackAlignments(referenceFrame, renderOptions);
        }
    }

    public void repackAlignments(ReferenceFrame referenceFrame, AlignmentTrack.RenderOptions renderOptions) {
        List<AlignmentInterval> loadedIntervals = this.loadedIntervalMap.get(referenceFrame.getChrName());
        if (loadedIntervals == null) {
            return;
        }
        for (AlignmentInterval loadedInterval : loadedIntervals) {
            Iterator<Alignment> iter = loadedInterval.getAlignmentIterator();
            int max = Integer.MAX_VALUE;
            LinkedHashMap<String, List<AlignmentInterval.Row>> alignmentRows = new AlignmentPacker().packAlignments(iter, loadedInterval.getEnd(), renderOptions);
            loadedInterval.setAlignmentRows(alignmentRows, renderOptions);
        }
    }

    public synchronized void preload(RenderContext context, AlignmentTrack.RenderOptions renderOptions, boolean expandEnds) {
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation();
        List<AlignmentInterval> loadedIntervals = this.loadedIntervalMap.get(context.getReferenceFrame().getChrName());
        int adjustedStart = start;
        int adjustedEnd = end;
        int windowSize = PreferenceManager.getInstance().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000;
        int center = (end + start) / 2;
        int expand = Math.max(end - start, windowSize / 2);
        boolean foundInterval = false;
        if (loadedIntervals != null) {
            for (AlignmentInterval loadedInterval : loadedIntervals) {
                if (!loadedInterval.contains(chr, start, end)) continue;
                return;
            }
            for (AlignmentInterval loadedInterval : loadedIntervals) {
                if (!loadedInterval.overlaps(chr, start, end, context.getZoom())) continue;
                foundInterval = true;
                if (start < loadedInterval.getStart() && end <= loadedInterval.getEnd()) {
                    adjustedEnd = loadedInterval.getStart() + 1;
                    if (!expandEnds) break;
                    adjustedStart = Math.max(0, Math.min(start, center - expand));
                    break;
                }
                if (start < loadedInterval.getStart() || end <= loadedInterval.getEnd()) break;
                adjustedStart = loadedInterval.getEnd() - 1;
                if (!expandEnds) break;
                adjustedEnd = Math.max(end, center + expand);
                break;
            }
        }
        if (!foundInterval && expandEnds) {
            adjustedStart = Math.max(0, Math.min(start, center - expand));
            adjustedEnd = Math.max(end, center + expand);
        }
        this.loadAlignments(chr, adjustedStart, adjustedEnd, renderOptions, context);
    }

    public synchronized LinkedHashMap<String, List<AlignmentInterval.Row>> getGroups(RenderContext context, AlignmentTrack.RenderOptions renderOptions) {
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation();
        this.preload(context, renderOptions, false);
        List<AlignmentInterval> overlaps = this.loadedIntervalMap.getOverlaps(chr, start, end, context.getZoom());
        if (overlaps != null && overlaps.size() >= 1) {
            return overlaps.get(0).getGroupedAlignments();
        }
        return null;
    }

    public void clear() {
        this.loadedIntervalMap.clear();
    }

    public synchronized void loadAlignments(final String chr, final int start, final int end, final AlignmentTrack.RenderOptions renderOptions, final RenderContext context) {
        if (this.isLoading || chr.equals("All")) {
            return;
        }
        this.isLoading = true;
        int windowSize = PreferenceManager.getInstance().getAsInt("SAM.MAX_VISIBLE_RANGE") * 1000;
        int maxIntervalSize = 3 * Math.max(end - start, windowSize);
        this.loadedIntervalMap.setMaxIntervalSize(maxIntervalSize);
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "loadAlignments";
            }

            @Override
            public void run() {
                log.debug("Loading alignments: " + chr + ":" + start + "-" + end);
                AlignmentInterval loadedInterval = AlignmentDataManager.this.loadInterval(chr, start, end, renderOptions);
                AlignmentDataManager.this.addLoadedInterval(context, loadedInterval);
                if (AlignmentDataManager.this.coverageTrack != null) {
                    AlignmentDataManager.this.coverageTrack.rescale(context.getReferenceFrame());
                }
                if (context.getPanel() != null) {
                    context.getPanel().invalidate();
                    context.getPanel().repaint();
                }
                AlignmentDataManager.this.isLoading = false;
            }
        };
        LongRunningTask.submit(runnable);
    }

    AlignmentInterval loadInterval(String chr, int start, int end, AlignmentTrack.RenderOptions renderOptions) {
        NumberFormat format = NumberFormat.getInstance();
        int delta = end - start;
        String sequence = this.chrMappings.containsKey(chr) ? this.chrMappings.get(chr) : chr;
        DownsampleOptions downsampleOptions = new DownsampleOptions();
        AlignmentTrack.BisulfiteContext bisulfiteContext = renderOptions != null ? renderOptions.bisulfiteContext : null;
        AlignmentTileLoader.AlignmentTile t = this.reader.loadTile(sequence, start, end, this.showSpliceJunctions, downsampleOptions, this.peStats, bisulfiteContext);
        List<Alignment> alignments = t.getAlignments();
        List<SpliceJunctionFeature> spliceJunctions = t.getSpliceJunctionFeatures();
        List<DownsampledInterval> downsampledIntervals = t.getDownsampledIntervals();
        Comparator<Alignment> alignmentSorter = new Comparator<Alignment>(){

            @Override
            public int compare(Alignment alignment, Alignment alignment1) {
                return alignment.getStart() - alignment1.getStart();
            }
        };
        Collections.sort(alignments, alignmentSorter);
        Iterator<Alignment> iter = alignments.iterator();
        AlignmentPacker alignmentPacker = new AlignmentPacker();
        LinkedHashMap<String, List<AlignmentInterval.Row>> alignmentRows = alignmentPacker.packAlignments(iter, end, renderOptions);
        return new AlignmentInterval(chr, start, end, alignmentRows, t.getCounts(), spliceJunctions, downsampledIntervals, renderOptions);
    }

    private void addLoadedInterval(RenderContext context, AlignmentInterval interval) {
        this.loadedIntervalMap.setLocusList(FrameManager.getFrames());
        this.loadedIntervalMap.put(interval);
    }

    public Map<String, List<AlignmentInterval.Row>> getGroupedAlignmentsContaining(double position, ReferenceFrame referenceFrame) {
        String chr = referenceFrame.getChrName();
        int start = (int)position;
        int end = start + 1;
        List<AlignmentInterval> loadedIntervals = this.loadedIntervalMap.get(referenceFrame.getChrName());
        if (loadedIntervals == null) {
            return null;
        }
        for (AlignmentInterval loadedInterval : loadedIntervals) {
            if (loadedInterval.getGroupedAlignments() == null || !loadedInterval.contains(chr, start, end)) continue;
            return loadedInterval.getGroupedAlignments();
        }
        return null;
    }

    public int getNLevels() {
        int nLevels = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.getLoadedIntervals()) {
            int intervalNLevels = 0;
            Collection<List<AlignmentInterval.Row>> tmp = loadedInterval.getGroupedAlignments().values();
            for (List<AlignmentInterval.Row> rows : tmp) {
                intervalNLevels += rows.size();
            }
            nLevels = Math.max(nLevels, intervalNLevels);
        }
        return nLevels;
    }

    public int getMaxGroupCount() {
        int groupCount = 0;
        for (AlignmentInterval loadedInterval : this.loadedIntervalMap.getLoadedIntervals()) {
            groupCount = Math.max(groupCount, loadedInterval.getGroupCount());
        }
        return groupCount;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                log.error("Error closing AlignmentQueryReader. ", ex);
            }
        }
    }

    public Collection<AlignmentInterval> getLoadedIntervals() {
        return this.loadedIntervalMap.getLoadedIntervals();
    }

    public void updatePEStats(AlignmentTrack.RenderOptions renderOptions) {
        if (this.peStats != null) {
            for (PEStats stats : this.peStats.values()) {
                stats.compute(renderOptions.getMinInsertSizePercentile(), renderOptions.getMaxInsertSizePercentile());
            }
        }
    }

    public boolean isShowSpliceJunctions() {
        return this.showSpliceJunctions;
    }

    public static class DownsampleOptions {
        private boolean downsample;
        private int sampleWindowSize;
        private int maxReadCount;

        public DownsampleOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            this.downsample = prefs.getAsBoolean("SAM.DOWNSAMPLE_READS");
            this.sampleWindowSize = prefs.getAsInt("SAM.SAMPLING_WINDOW");
            this.maxReadCount = prefs.getAsInt("SAM.MAX_LEVELS");
        }

        public boolean isDownsample() {
            return this.downsample;
        }

        public int getSampleWindowSize() {
            return this.sampleWindowSize;
        }

        public int getMaxReadCount() {
            return this.maxReadCount;
        }
    }
}

