/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public abstract class DataRenderer
implements Renderer<LocusScore> {
    private static Logger log = Logger.getLogger(DataRenderer.class);
    protected static final int AXIS_AREA_WIDTH = 60;
    protected static Color axisLineColor = new Color(255, 180, 180);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(List<LocusScore> scores, RenderContext context, Rectangle rect, Track track) {
        if (scores != null) {
            List<LocusScore> list = scores;
            synchronized (list) {
                this.renderScores(track, scores, context, rect);
                this.renderAxis(track, context, rect);
            }
        }
        this.renderBorder(track, context, rect);
    }

    public void renderBorder(Track track, RenderContext context, Rectangle rect) {
    }

    public void renderAxis(Track track, RenderContext context, Rectangle rect) {
        PreferenceManager prefs = PreferenceManager.getInstance();
        if (context.getChr().equals("All")) {
            return;
        }
        if (prefs.getAsBoolean("CHART.DRAW_AXIS")) {
            Rectangle axisRect = new Rectangle(rect.x, rect.y + 1, 60, rect.height);
            Graphics2D whiteGraphics = context.getGraphic2DForColor(Color.white);
            whiteGraphics.fillRect(axisRect.x, axisRect.y, axisRect.width, axisRect.height);
            Graphics2D axisGraphics = context.getGraphic2DForColor(axisLineColor);
            axisGraphics.drawLine(rect.x + 60, rect.y, rect.x + 60, rect.y + rect.height);
        }
    }

    protected abstract void renderScores(Track var1, List<LocusScore> var2, RenderContext var3, Rectangle var4);
}

