/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.maf.MAFListReader;
import org.broad.igv.maf.MAFLocalReader;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MAFTile;
import org.broad.igv.maf.MAFUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.LRUCache;

public class MAFManager {
    private static Logger log = Logger.getLogger(MAFManager.class);
    public static String[] species = new String[]{"panTro2", "gorGor1", "ponAbe2", "rheMac2", "calJac1", "tarSyr1", "micMur1", "otoGar1", "tupBel1", "mm9", "rn4", "dipOrd1", "cavPor3", "speTri1", "oryCun1", "ochPri2", "vicPac1", "turTru1", "bosTau4", "equCab2", "felCat3", "canFam2", "myoLuc1", "pteVam1", "eriEur1", "sorAra1", "loxAfr2", "proCap1", "echTel1", "dasNov2", "choHof1", "monDom4", "ornAna1", "galGal3", "taeGut1", "anoCar1", "xenTro2", "tetNig1", "fr2", "gasAcu1", "oryLat28", "danRer5", "petMar1"};
    private List<String> selectedSpecies;
    private List<String> allSpecies;
    private Map<String, String> speciesNames;
    private int tileSize = 500;
    LRUCache<String, MAFTile> tileCache = new LRUCache(this, 10);
    MAFReader reader;
    String refId;
    Genome genome;

    public MAFManager(final ResourceLocator locator, Genome genome) throws IOException {
        this.loadSpecies(locator.getPath());
        this.speciesNames.put(genome.getId(), genome.getDisplayName());
        this.overrides();
        if (locator.getPath().endsWith(".maf.dict")) {
            this.reader = new MAFListReader(locator.getPath());
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MAFManager.this.reader = new MAFLocalReader(locator.getPath());
                        IGV.getInstance().repaintDataAndHeaderPanels();
                    }
                    catch (Exception e) {
                        log.error("Error loading MAF reader (" + locator.getPath() + "):  ", e);
                        MessageUtils.showMessage("Error loading MAF file: " + e.getMessage());
                    }
                }
            };
            LongRunningTask.submit(runnable);
        }
    }

    private void overrides() {
        String[] humanIds;
        for (String id : humanIds = new String[]{"hg18", "1kg_ref", "hg19", "b37", "1kg_v37"}) {
            this.speciesNames.put(id, "Human");
        }
    }

    public List<String> getSelectedSpecies() {
        return this.selectedSpecies;
    }

    public void setSelectedSpecies(List<String> selectedSpecies) {
        this.selectedSpecies = selectedSpecies;
        this.allSpecies = new ArrayList<String>(selectedSpecies);
        this.allSpecies.add(0, this.refId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSpecies(String path) {
        InputStream is = null;
        this.speciesNames = new HashMap<String, String>();
        ArrayList<String> species = new ArrayList<String>();
        try {
            String nextLine;
            String speciesPath = path + ".species";
            is = FileUtils.resourceExists(speciesPath) ? ParsingUtils.openInputStream(speciesPath) : MAFUtils.class.getResourceAsStream("species.properties");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((nextLine = br.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#ref")) {
                    tokens = Globals.equalPattern.split(nextLine);
                    this.refId = tokens[1];
                    continue;
                }
                tokens = Globals.equalPattern.split(nextLine);
                if (tokens.length != 2) continue;
                String id = tokens[0];
                String name = tokens[1];
                this.speciesNames.put(id, name);
                species.add(id);
            }
            this.setSelectedSpecies(species);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getSpeciesName(String speciesId) {
        String name = this.speciesNames.get(speciesId);
        return name == null ? speciesId : name;
    }

    public List<String> getChrNames() {
        return this.reader.getChrNames();
    }

    public MAFTile[] getTiles(String chr, int start, int end) {
        int startTile = start / this.tileSize;
        int endTile = end / this.tileSize;
        MAFTile[] tiles = new MAFTile[endTile - startTile + 1];
        for (int i = startTile; i <= endTile; ++i) {
            tiles[i - startTile] = this.getTile(chr, i);
        }
        return tiles;
    }

    private MAFTile getTile(String chr, int tileNo) {
        if (this.reader == null) {
            return null;
        }
        String key = MAFManager.getKey(chr, tileNo);
        MAFTile tile = this.tileCache.get(key);
        if (tile == null) {
            int start = tileNo * this.tileSize;
            int end = start + this.tileSize + 1;
            tile = this.reader.loadTile(chr, start, end, this.allSpecies);
            this.tileCache.put(key, tile);
        }
        return tile;
    }

    static String getKey(String chr, int tileNo) {
        return chr + tileNo;
    }
}

