/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.ParserConfigurationException;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBProfileEditor
extends JDialog {
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel4;
    private JLabel label4;
    private JComboBox nameComboBox;
    private JPanel panel1;
    private JLabel label1;
    private JTextField DBHost;
    private JPanel panel6;
    private JLabel label6;
    private JTextField DBPath;
    private JPanel panel5;
    private JLabel label5;
    private JTextField port;
    private JPanel panel2;
    private JLabel label2;
    private JTextField username;
    private JPanel panel3;
    private JLabel label3;
    private JPasswordField password;
    private JCheckBox checkBox1;
    private JPanel panel7;
    private JLabel label7;
    private JTextField tableName;
    private JPanel panel8;
    private JLabel label8;
    private JComboBox dataType;
    private JSeparator separator1;
    private JPanel panel9;
    private JLabel label9;
    private JTextField chromField;
    private JPanel panel10;
    private JLabel label10;
    private JTextField posStartField;
    private JPanel panel13;
    private JLabel label13;
    private JTextField posEndField;
    private JPanel panel11;
    private JLabel label11;
    private JTextField startColField;
    private JPanel panel12;
    private JLabel label12;
    private JTextField endColField;
    private JPanel panel14;
    private JLabel label14;
    private JTextField binColField;
    private JPanel buttonBar;
    private JButton saveButton;
    private JButton okButton;
    private JButton cancelButton;

    public DBProfileEditor(Frame owner, String initProfilePath) {
        super(owner);
        this.initComponents();
        this.postInit(initProfilePath);
    }

    public DBProfileEditor(Dialog owner, String initProfilePath) {
        super(owner);
        this.initComponents();
        this.postInit(initProfilePath);
    }

    private void postInit(String initProfilePath) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(CodecFactory.validExtensions.toArray(new String[0]));
        this.dataType.setModel(model);
        if (initProfilePath != null) {
            try {
                FileInputStream profileStream = new FileInputStream(initProfilePath);
                Document document = Utilities.createDOMDocumentFromXmlStream(profileStream);
                NamedNodeMap dbAttrs = document.getAttributes();
                String fullHost = "";
                String subprotocol = Utilities.getNullSafe(dbAttrs, "subprotocol");
                String host = Utilities.getNullSafe(dbAttrs, "host");
                if (subprotocol != null && host != null) {
                    fullHost = subprotocol + "://" + host;
                }
                this.DBPath.setText(fullHost);
                this.port.setText(Utilities.getNullSafe(dbAttrs, "port"));
                this.username.setText(Utilities.getNullSafe(dbAttrs, "username"));
                this.password.setText(Utilities.getNullSafe(dbAttrs, "password"));
                NodeList tables = document.getElementsByTagName("table");
                Node table = tables.item(0);
                NamedNodeMap tableAttrs = table.getAttributes();
                this.tableName.setText(Utilities.getNullSafe(tableAttrs, "name"));
                this.chromField.setText(Utilities.getNullSafe(tableAttrs, "chromoColName"));
                this.posStartField.setText(Utilities.getNullSafe(tableAttrs, "posStartColName"));
                this.posEndField.setText(Utilities.getNullSafe(tableAttrs, "posEndColName"));
                this.startColField.setText(Utilities.getNullSafe(tableAttrs, "startColIndex"));
                this.endColField.setText(Utilities.getNullSafe(tableAttrs, "endColIndex"));
                this.binColField.setText(Utilities.getNullSafe(tableAttrs, "binColName"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel4 = new JPanel();
        this.label4 = new JLabel();
        this.nameComboBox = new JComboBox();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.DBHost = new JTextField();
        this.panel6 = new JPanel();
        this.label6 = new JLabel();
        this.DBPath = new JTextField();
        this.panel5 = new JPanel();
        this.label5 = new JLabel();
        this.port = new JTextField();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.username = new JTextField();
        this.panel3 = new JPanel();
        this.label3 = new JLabel();
        this.password = new JPasswordField();
        this.checkBox1 = new JCheckBox();
        this.panel7 = new JPanel();
        this.label7 = new JLabel();
        this.tableName = new JTextField();
        this.panel8 = new JPanel();
        this.label8 = new JLabel();
        this.dataType = new JComboBox();
        this.separator1 = new JSeparator();
        this.panel9 = new JPanel();
        this.label9 = new JLabel();
        this.chromField = new JTextField();
        this.panel10 = new JPanel();
        this.label10 = new JLabel();
        this.posStartField = new JTextField();
        this.panel13 = new JPanel();
        this.label13 = new JLabel();
        this.posEndField = new JTextField();
        this.panel11 = new JPanel();
        this.label11 = new JLabel();
        this.startColField = new JTextField();
        this.panel12 = new JPanel();
        this.label12 = new JLabel();
        this.endColField = new JTextField();
        this.panel14 = new JPanel();
        this.label14 = new JLabel();
        this.binColField = new JTextField();
        this.buttonBar = new JPanel();
        this.saveButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(367, 500));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.panel4.setLayout(new BoxLayout(this.panel4, 0));
        this.label4.setText("Name:");
        this.label4.setHorizontalAlignment(2);
        this.label4.setMaximumSize(new Dimension(80, 16));
        this.panel4.add(this.label4);
        this.nameComboBox.setEditable(true);
        this.nameComboBox.setMaximumRowCount(100);
        this.panel4.add(this.nameComboBox);
        this.contentPanel.add(this.panel4);
        this.panel1.setLayout(new BoxLayout(this.panel1, 0));
        this.label1.setText("Host:");
        this.label1.setHorizontalAlignment(2);
        this.label1.setMaximumSize(new Dimension(80, 16));
        this.panel1.add(this.label1);
        this.DBHost.setMaximumSize(new Dimension(250, 28));
        this.DBHost.setPreferredSize(new Dimension(250, 28));
        this.DBHost.setToolTipText("my.awesomedb.com");
        this.DBHost.setText("mysql://my.db.com");
        this.panel1.add(this.DBHost);
        this.contentPanel.add(this.panel1);
        this.panel6.setLayout(new BoxLayout(this.panel6, 0));
        this.label6.setText("Path:");
        this.label6.setHorizontalAlignment(2);
        this.label6.setMaximumSize(new Dimension(80, 16));
        this.panel6.add(this.label6);
        this.DBPath.setMaximumSize(new Dimension(250, 28));
        this.DBPath.setPreferredSize(new Dimension(250, 28));
        this.DBPath.setToolTipText("my.awesomedb.com");
        this.DBPath.setText("hg19");
        this.panel6.add(this.DBPath);
        this.contentPanel.add(this.panel6);
        this.panel5.setLayout(new BoxLayout(this.panel5, 0));
        this.label5.setText("Port (optional):");
        this.label5.setHorizontalAlignment(2);
        this.label5.setMaximumSize(new Dimension(80, 16));
        this.panel5.add(this.label5);
        this.port.setMaximumSize(new Dimension(250, 28));
        this.port.setPreferredSize(new Dimension(250, 28));
        this.port.setToolTipText("my.awesomedb.com");
        this.port.setText("80");
        this.panel5.add(this.port);
        this.contentPanel.add(this.panel5);
        this.panel2.setLayout(new BoxLayout(this.panel2, 0));
        this.label2.setText("Username:");
        this.label2.setHorizontalAlignment(2);
        this.label2.setMaximumSize(new Dimension(80, 16));
        this.label2.setMinimumSize(new Dimension(66, 16));
        this.label2.setPreferredSize(new Dimension(80, 16));
        this.panel2.add(this.label2);
        this.username.setMaximumSize(new Dimension(150, 28));
        this.username.setPreferredSize(new Dimension(150, 28));
        this.panel2.add(this.username);
        this.contentPanel.add(this.panel2);
        this.panel3.setMaximumSize(new Dimension(400, 28));
        this.panel3.setLayout(new BoxLayout(this.panel3, 0));
        this.label3.setText("Password (opt.):");
        this.label3.setMaximumSize(new Dimension(120, 16));
        this.label3.setMinimumSize(new Dimension(66, 16));
        this.label3.setPreferredSize(new Dimension(80, 16));
        this.label3.setHorizontalAlignment(2);
        this.panel3.add(this.label3);
        this.password.setMaximumSize(new Dimension(150, 28));
        this.password.setPreferredSize(new Dimension(150, 28));
        this.password.setEnabled(false);
        this.panel3.add(this.password);
        this.checkBox1.setText("Save");
        this.panel3.add(this.checkBox1);
        this.contentPanel.add(this.panel3);
        this.panel7.setLayout(new BoxLayout(this.panel7, 0));
        this.label7.setText("Table Name:");
        this.label7.setHorizontalAlignment(2);
        this.label7.setMaximumSize(new Dimension(80, 16));
        this.panel7.add(this.label7);
        this.tableName.setMaximumSize(new Dimension(250, 28));
        this.tableName.setPreferredSize(new Dimension(250, 28));
        this.tableName.setToolTipText("mysql://my.awesomedb.com:8080/mytable");
        this.tableName.setText("DataTable");
        this.panel7.add(this.tableName);
        this.contentPanel.add(this.panel7);
        this.panel8.setLayout(new BoxLayout(this.panel8, 0));
        this.label8.setText("Data Type:");
        this.label8.setHorizontalAlignment(2);
        this.label8.setMaximumSize(new Dimension(80, 16));
        this.panel8.add(this.label8);
        this.dataType.setMaximumSize(new Dimension(250, 28));
        this.dataType.setMinimumSize(new Dimension(96, 28));
        this.panel8.add(this.dataType);
        this.contentPanel.add(this.panel8);
        this.separator1.setPreferredSize(new Dimension(0, 1));
        this.contentPanel.add(this.separator1);
        this.panel9.setLayout(new BoxLayout(this.panel9, 0));
        this.label9.setText("Chromosome Column Name:");
        this.label9.setHorizontalAlignment(2);
        this.label9.setMaximumSize(new Dimension(80, 16));
        this.panel9.add(this.label9);
        this.chromField.setMaximumSize(new Dimension(250, 28));
        this.chromField.setPreferredSize(new Dimension(250, 28));
        this.chromField.setText("chrom");
        this.panel9.add(this.chromField);
        this.contentPanel.add(this.panel9);
        this.panel10.setLayout(new BoxLayout(this.panel10, 0));
        this.label10.setText("Position Start Column Name:");
        this.label10.setHorizontalAlignment(2);
        this.label10.setMaximumSize(new Dimension(80, 16));
        this.panel10.add(this.label10);
        this.posStartField.setMaximumSize(new Dimension(250, 28));
        this.posStartField.setPreferredSize(new Dimension(250, 28));
        this.posStartField.setText("txStart");
        this.panel10.add(this.posStartField);
        this.contentPanel.add(this.panel10);
        this.panel13.setLayout(new BoxLayout(this.panel13, 0));
        this.label13.setText("Position End Column Name:");
        this.label13.setHorizontalAlignment(2);
        this.label13.setMaximumSize(new Dimension(80, 16));
        this.panel13.add(this.label13);
        this.posEndField.setMaximumSize(new Dimension(250, 28));
        this.posEndField.setPreferredSize(new Dimension(250, 28));
        this.posEndField.setText("txEnd");
        this.panel13.add(this.posEndField);
        this.contentPanel.add(this.panel13);
        this.panel11.setLayout(new BoxLayout(this.panel11, 0));
        this.label11.setText("Data start column index (opt.):");
        this.label11.setHorizontalAlignment(2);
        this.label11.setMaximumSize(new Dimension(80, 16));
        this.panel11.add(this.label11);
        this.startColField.setMaximumSize(new Dimension(250, 28));
        this.startColField.setPreferredSize(new Dimension(250, 28));
        this.startColField.setToolTipText("Starting column index from which to read data (1-based)");
        this.startColField.setText("1");
        this.panel11.add(this.startColField);
        this.contentPanel.add(this.panel11);
        this.panel12.setLayout(new BoxLayout(this.panel12, 0));
        this.label12.setText("Data end column index (opt.):");
        this.label12.setHorizontalAlignment(2);
        this.label12.setMaximumSize(new Dimension(80, 16));
        this.panel12.add(this.label12);
        this.endColField.setMaximumSize(new Dimension(250, 28));
        this.endColField.setPreferredSize(new Dimension(250, 28));
        this.endColField.setToolTipText("Last column (1-based, inclusive end) from which to read data");
        this.panel12.add(this.endColField);
        this.contentPanel.add(this.panel12);
        this.panel14.setLayout(new BoxLayout(this.panel14, 0));
        this.label14.setText("Bin column Name (opt.):");
        this.label14.setHorizontalAlignment(2);
        this.label14.setMaximumSize(new Dimension(80, 16));
        this.panel14.add(this.label14);
        this.binColField.setMaximumSize(new Dimension(250, 28));
        this.binColField.setPreferredSize(new Dimension(250, 28));
        this.binColField.setToolTipText("Some databases use binning to speed up querying");
        this.panel14.add(this.binColField);
        this.contentPanel.add(this.panel14);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.saveButton.setText("Save Profile");
        this.buttonBar.add((Component)this.saveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.okButton.setText("Load Data");
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

