/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.LocusScoreUtils;
import org.broad.igv.data.cufflinks.CufflinksValue;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.DownsampledDoubleArrayList;

public class CufflinksDataSource
implements DataSource {
    double dataMax;
    double dataMin;
    Map<String, List<LocusScore>> values;
    Map<String, String> chrAliasMap = new HashMap<String, String>();

    public CufflinksDataSource(List<CufflinksValue> valueList, Genome genome) {
        DownsampledDoubleArrayList sampledData = new DownsampledDoubleArrayList(5000, 10000);
        this.values = new HashMap<String, List<LocusScore>>();
        for (CufflinksValue cufflinksValue : valueList) {
            String chr = cufflinksValue.getChr();
            List<LocusScore> chrValues = this.values.get(chr);
            if (chrValues == null) {
                chrValues = new ArrayList<LocusScore>();
                this.values.put(chr, chrValues);
                if (genome != null) {
                    String alias = genome.getChromosomeAlias(chr);
                    this.chrAliasMap.put(alias, chr);
                }
            }
            sampledData.add(cufflinksValue.getScore());
            chrValues.add(cufflinksValue);
        }
        for (List list : this.values.values()) {
            LocusScoreUtils.sortFeatureList(list);
        }
        double[] sd = sampledData.toArray();
        if (sd.length > 0) {
            this.dataMin = Math.min(0.0, StatUtils.percentile(sd, 5.0));
            this.dataMax = StatUtils.percentile(sd, 95.0);
        } else {
            this.dataMin = 0.0;
            this.dataMax = 100.0;
        }
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        if (this.chrAliasMap.containsKey(chr)) {
            return this.values.get(this.chrAliasMap.get(chr));
        }
        return this.values.get(chr);
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.FPKM;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return null;
    }
}

