/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.stat.StatUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.IntArrayList;

public class ProcessingUtils {
    protected static int[] findBoundaries(List<LocusScore> scores) {
        int[] boundaries = new int[2 * scores.size() + 1];
        for (int i = 0; i < scores.size(); ++i) {
            LocusScore score = scores.get(i);
            boundaries[2 * i] = score.getStart();
            boundaries[2 * i + 1] = score.getEnd();
        }
        Arrays.sort(boundaries);
        IntArrayList boundaryList = new IntArrayList(boundaries.length);
        int lastPos = -1;
        for (int i = 0; i < boundaries.length; ++i) {
            if (boundaries[i] == lastPos) continue;
            lastPos = boundaries[i];
            boundaryList.add(lastPos);
        }
        boundaries = boundaryList.toArray();
        return boundaries;
    }

    private static boolean nullDataCheck(float[] data) {
        boolean noData = true;
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                if (Float.isNaN(data[i])) continue;
                noData = false;
                break;
            }
        }
        return noData;
    }

    private static float computeQuantile(float[] data, double quantile) {
        double[] dData = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            dData[i] = data[i];
        }
        return (float)StatUtils.percentile(dData, quantile);
    }

    private static float computeMin(float[] data) {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            min = Math.min(data[i], min);
        }
        return min;
    }

    private static float computeMax(float[] data) {
        float max = -3.4028235E38f;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            max = Math.max(data[i], max);
        }
        return max;
    }

    private static float computeMean(float[] data) {
        float sum = 0.0f;
        int nPts = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            sum += data[i];
            ++nPts;
        }
        return nPts == 0 ? Float.NaN : sum / (float)nPts;
    }

    public static float computeStat(float[] data, WindowFunction function) {
        if (ProcessingUtils.nullDataCheck(data)) {
            return Float.NaN;
        }
        switch (function) {
            case mean: {
                return ProcessingUtils.computeMean(data);
            }
            case median: {
                return ProcessingUtils.computeQuantile(data, 50.0);
            }
            case min: {
                return ProcessingUtils.computeMin(data);
            }
            case max: {
                return ProcessingUtils.computeMax(data);
            }
            case percentile2: {
                return ProcessingUtils.computeQuantile(data, 2.0);
            }
            case percentile10: {
                return ProcessingUtils.computeQuantile(data, 10.0);
            }
            case percentile90: {
                return ProcessingUtils.computeQuantile(data, 90.0);
            }
            case percentile98: {
                return ProcessingUtils.computeQuantile(data, 98.0);
            }
            case count: {
                return data.length;
            }
        }
        return Float.NaN;
    }

    static class Interval {
        int start;
        int end;
        List<LocusScore> scores = new ArrayList<LocusScore>(3);

        public Interval(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

