/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;

public class VariantRenderer {
    private static Logger log = Logger.getLogger(VariantRenderer.class);
    public static final int BOTTOM_MARGIN = 0;
    public static final int TOP_MARGIN = 3;
    private static float alphaValue = 0.2f;
    public static Color colorHomRef = new Color(235, 235, 235);
    public static Color colorHomRefAlpha = ColorUtilities.getCompositeColor(colorHomRef, alphaValue);
    public static Color colorHomVar = new Color(0, 245, 255);
    public static Color colorHomVarAlpha = ColorUtilities.getCompositeColor(colorHomVar, alphaValue);
    public static Color colorHet = Color.blue.brighter();
    public static Color colorHetAlpha = ColorUtilities.getCompositeColor(colorHet, alphaValue);
    public static Color colorNoCall = Color.white;
    public static Color colorNoCallAlpha = ColorUtilities.getCompositeColor(colorNoCall, alphaValue);
    public static final Color colorAlleleBand = Color.red;
    public static Color colorAlleleBandAlpha = ColorUtilities.getCompositeColor(colorAlleleBand, alphaValue);
    public static final Color colorAlleleRef = Color.gray;
    public static Color colorAlleleRefAlpha = ColorUtilities.getCompositeColor(colorAlleleRef, alphaValue);
    private static final Color blue = new Color(0, 0, 220);
    public static Color blueAlpha = ColorUtilities.getCompositeColor(blue, alphaValue);
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();
    private VariantTrack track;

    public VariantRenderer(VariantTrack track) {
        this.track = track;
    }

    public void renderSiteBand(Variant variant, Rectangle bandRectangle, int pX0, int dX, RenderContext context) {
        Graphics2D g;
        Color refColor;
        double percent;
        Color alleleColor;
        boolean filtered = variant.isFiltered();
        if (this.track.getColorMode() == VariantTrack.ColorMode.METHYLATION_RATE) {
            alleleColor = this.convertMethylationRateToColor((float)variant.getMethlationRate() / 100.0f);
            percent = variant.getCoveredSampleFraction();
            refColor = filtered ? colorAlleleRefAlpha : colorAlleleRef;
        } else {
            double[] afreqs;
            alleleColor = filtered ? colorAlleleBandAlpha : colorAlleleBand;
            double af = variant.getAlleleFraction();
            if (af < 0.0 && (afreqs = variant.getAlleleFreqs()) != null && afreqs.length > 0) {
                af = afreqs[0];
            }
            if ((percent = Math.min(1.0, af)) <= 0.0) {
                percent = 0.0;
                refColor = filtered ? colorAlleleRefAlpha : colorAlleleRef;
            } else {
                refColor = filtered ? blueAlpha : blue;
            }
        }
        int bottomY = bandRectangle.y + bandRectangle.height - 0;
        int barHeight = bandRectangle.height - 3 - 0;
        int alleleBarHeight = (int)(percent * (double)barHeight);
        int remainderHeight = barHeight - alleleBarHeight;
        if (remainderHeight > 0) {
            g = context.getGraphic2DForColor(refColor);
            g.fillRect(pX0, bottomY - alleleBarHeight - remainderHeight, dX, remainderHeight);
        }
        if (alleleBarHeight > 0) {
            g = context.getGraphic2DForColor(alleleColor);
            g.fillRect(pX0, bottomY - alleleBarHeight, dX, alleleBarHeight);
        }
    }

    public void renderGenotypeBandSNP(Variant variant, RenderContext context, Rectangle bandRectangle, int pX0, int dX, String sampleName, VariantTrack.ColorMode coloring, boolean hideFiltered) {
        int pY = (int)bandRectangle.getY();
        int dY = (int)bandRectangle.getHeight();
        int tOffset = 6;
        int bOffset = 8;
        Graphics2D g = (Graphics2D)context.getGraphics().create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, PreferenceManager.getInstance().getAntiAliasingHint());
        if (dX >= 10) {
            Font f;
            if (dY > 24) {
                f = FontManager.getFont(1, Math.min(dX, 12));
                g.setFont(f);
            } else if (dY > 18) {
                f = FontManager.getFont(1, Math.min(dX, 8));
                tOffset = 4;
                bOffset = 5;
                g.setFont(f);
            }
        }
        boolean isFiltered = variant.isFiltered() && hideFiltered;
        Genotype genotype = variant.getGenotype(sampleName);
        if (genotype == null) {
            log.error("Now what?");
        } else {
            Color b1Color = Color.gray;
            Color b2Color = Color.gray;
            char b1 = ' ';
            char b2 = ' ';
            switch (coloring) {
                case GENOTYPE: {
                    b2Color = b1Color = this.getGenotypeColor(genotype, isFiltered);
                    break;
                }
                case ALLELE: {
                    List<Allele> alleleList = genotype.getAlleles();
                    if (alleleList.size() > 0) {
                        b1 = this.getFirstBase(alleleList.get(0));
                        b1Color = nucleotideColors.get(Character.valueOf(b1));
                    }
                    if (alleleList.size() <= 1) break;
                    b2 = this.getFirstBase(alleleList.get(1));
                    b2Color = nucleotideColors.get(Character.valueOf(b2));
                    break;
                }
                case METHYLATION_RATE: {
                    double goodBaseCount = genotype.getAttributeAsDouble("GB");
                    b2Color = b1Color = colorNoCall;
                    double value = genotype.getAttributeAsDouble("MR");
                    if (!Double.isNaN(goodBaseCount) && !Double.isNaN(value)) {
                        if (goodBaseCount < (double)VariantTrack.METHYLATION_MIN_BASE_COUNT || Double.isNaN(value)) {
                            b2Color = b1Color = colorNoCall;
                            break;
                        }
                        float mr = (float)value;
                        b2Color = b1Color = this.convertMethylationRateToColor(mr /= 100.0f);
                        break;
                    }
                    log.error("GB and MR fields must be defined for all records in a VCF methylation file.");
                    break;
                }
                default: {
                    b2Color = b1Color = colorNoCall;
                }
            }
            int y0 = this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? pY + 1 : pY;
            int h = Math.max(1, this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? dY - 2 : dY);
            if (coloring == VariantTrack.ColorMode.GENOTYPE) {
                g.setColor(b1Color);
                g.fillRect(pX0, y0, dX, h);
            } else {
                g.setColor(b1Color);
                g.fillRect(pX0, y0, dX / 2, h);
                g.setColor(b2Color);
                g.fillRect(pX0 + dX / 2, y0, dX / 2, h);
            }
            if (dX >= 10 && dY >= 18) {
                if (b1Color == Color.blue) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(Color.black);
                }
                this.drawCenteredText(g, new char[]{b1}, pX0, pY - tOffset, dX, dY);
                this.drawCenteredText(g, new char[]{b2}, pX0, pY + dY / 2 - bOffset, dX, dY);
            }
        }
        g.dispose();
    }

    private Color convertMethylationRateToColor(float mr) {
        float v = 1.5f + mr / 2.0f;
        return Color.getHSBColor(v, 0.75f, 1.0f);
    }

    public char getFirstBase(Allele allele) {
        byte[] bases = allele.getBases();
        if (bases.length > 0) {
            return (char)bases[0];
        }
        return '.';
    }

    public Color getGenotypeColor(Genotype genotype, boolean isFiltered) {
        if (genotype.isNoCall()) {
            return isFiltered ? colorNoCallAlpha : colorNoCall;
        }
        if (genotype.isHomRef()) {
            return isFiltered ? colorHomRefAlpha : colorHomRef;
        }
        if (genotype.isHomVar()) {
            return isFiltered ? colorHomVarAlpha : colorHomVar;
        }
        if (genotype.isHet()) {
            return isFiltered ? colorHetAlpha : colorHet;
        }
        return Color.white;
    }

    private void drawCenteredText(Graphics2D g, char[] chars, int x, int y, int w, int h) {
        FontMetrics fm = g.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h / 2 - descent / 2 + ascent / 2;
        g.drawChars(chars, 0, 1, msgX, msgY);
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('g'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('N'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('n'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('.'), colorAlleleRef);
        nucleotideColors.put(null, Color.BLACK);
    }
}

