/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;

public class GFFtoBed {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File inputFile, File outputFile) {
        GFFParser parser = new GFFParser(inputFile.getPath());
        BufferedReader reader = null;
        PrintWriter pw = null;
        try {
            reader = ParsingUtils.openBufferedReader(new ResourceLocator(inputFile.getAbsolutePath()));
            List<Feature> features = parser.loadFeatures(reader, null);
            IGVBEDCodec codec = new IGVBEDCodec();
            codec.setGffTags(true);
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            pw.println("#gffTags");
            for (Feature feature : features) {
                BasicFeature bf = (BasicFeature)feature;
                String line = codec.encode(bf);
                pw.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            try {
                if (pw != null) {
                    pw.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void main(String[] args) {
        File gffFile = new File("test/data/gff/gene.gff3");
        File bedFile = new File("test/data/gff/gene.bed");
        GFFtoBed.convert(gffFile, bedFile);
    }
}

