/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMTextWriter;
import org.broad.igv.dev.plugin.Argument;
import org.broad.igv.dev.plugin.FeatureEncoder;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.SAMWriter;
import org.broad.igv.sam.SamAlignment;

public class SamAlignmentEncoder
implements FeatureEncoder<Alignment> {
    private boolean headerSet = false;

    @Override
    public Map<String, Object> encodeAll(OutputStream stream, Iterator<Alignment> alignments) {
        SAMTextWriter writer = new SAMTextWriter(stream);
        while (alignments.hasNext()) {
            Alignment al = alignments.next();
            if (!(al instanceof SamAlignment)) continue;
            SamAlignment samAl = (SamAlignment)al;
            if (!this.headerSet) {
                writer.setSortOrder(SAMFileHeader.SortOrder.unsorted, true);
                writer.setHeader(samAl.getRecord().getHeader());
                this.headerSet = true;
            }
            writer.addAlignment(samAl.getRecord());
        }
        writer.close();
        return null;
    }

    private String encode(Alignment feature) {
        if (feature instanceof SamAlignment) {
            SamAlignment alignment = (SamAlignment)feature;
            String out = "";
            out = out + alignment.getRecord().getSAMString();
            return out;
        }
        return SAMWriter.getSAMString(feature);
    }

    @Override
    public void setInputs(List<String> commands, Map<Argument, Object> argumentMap) {
    }
}

