/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.util.ImageFileTypes;
import org.broad.igv.ui.util.MessageUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SnapshotUtilities {
    private static Logger log = LogManager.getLogger(SnapshotUtilities.class);
    public static int DEFAULT_MAX_PANEL_HEIGHT;
    private static int maxPanelHeight;
    public static boolean snapshotInProgress;

    public static int getMaxPanelHeight() {
        return maxPanelHeight;
    }

    public static void setMaxPanelHeight(int h) {
        maxPanelHeight = h;
    }

    public static void resetMaxPanelHeight() {
        maxPanelHeight = DEFAULT_MAX_PANEL_HEIGHT;
    }

    private SnapshotUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doComponentSnapshot(Component component, File file, ImageFileTypes.Type type, boolean batch) throws IOException {
        try {
            snapshotInProgress = true;
            if (!(component instanceof Paintable)) {
                throw new RuntimeException("Error: " + String.valueOf(component) + " is not an instance of Paintable");
            }
            Paintable paintable = (Paintable)((Object)component);
            int width = component.getWidth();
            int height = paintable.getSnapshotHeight(batch);
            if (type == ImageFileTypes.Type.SVG) {
                SnapshotUtilities.exportScreenshotSVG((Paintable)((Object)component), file, width, height, batch);
                String string = "OK";
                return string;
            }
            if (type == ImageFileTypes.Type.PNG) {
                String format = "png";
                String[] exts = new String[]{"." + format};
                SnapshotUtilities.exportScreenShotBufferedImage((Paintable)((Object)component), file, width, height, exts, format, batch);
                String string = "OK";
                return string;
            }
            String message = "No image write for file type: " + String.valueOf(file) + " Try '.png' or '.svg'";
            MessageUtils.showMessage(message);
            String string = "ERROR: " + message;
            return string;
        }
        finally {
            snapshotInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportScreenshotSVG(Paintable target, File selectedFile, int width, int height, boolean batch) throws IOException {
        String format = "svg";
        selectedFile = SnapshotUtilities.fixFileExt(selectedFile, new String[]{format}, format);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, format, null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        SnapshotUtilities.paintImage(target, (Graphics2D)svgGenerator, width, height, batch);
        Writer out = null;
        try {
            boolean useCSS = false;
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), "UTF-8"));
            svgGenerator.stream(out, useCSS);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error("Error closing svg file", e);
                }
            }
        }
    }

    private static void exportScreenShotBufferedImage(Paintable target, File selectedFile, int width, int height, String[] allowedExts, String format, boolean batch) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        Color c = g.getColor();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(c);
        SnapshotUtilities.paintImage(target, g, width, height, batch);
        selectedFile = SnapshotUtilities.fixFileExt(selectedFile, allowedExts, format);
        if (selectedFile != null) {
            log.debug("Writing image to " + selectedFile.getAbsolutePath());
            boolean success = ImageIO.write((RenderedImage)image, format, selectedFile);
            if (!success) {
                MessageUtils.showMessage("Error writing image file of type: " + format + ". Try .png or .svg");
            }
        }
    }

    private static void paintImage(Paintable target, Graphics2D g, int width, int height, boolean batch) {
        Rectangle rect = new Rectangle(0, 0, width, height);
        target.paintOffscreen(g, rect, batch);
    }

    private static File fixFileExt(File selectedFile, String[] allowedExts, String defExtension) {
        boolean hasExt = false;
        if (selectedFile != null) {
            for (String ext : allowedExts) {
                if (!selectedFile.getName().toLowerCase().endsWith(ext)) continue;
                hasExt = true;
                break;
            }
            if (!hasExt) {
                Object addExt = defExtension.startsWith(".") ? defExtension : "." + defExtension;
                String correctedFilename = selectedFile.getAbsolutePath() + (String)addExt;
                selectedFile = new File(correctedFilename);
            }
        }
        return selectedFile;
    }

    public static BufferedImage getDeviceCompatibleImage(int width, int height) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screenDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicConfiguration = screenDevice.getDefaultConfiguration();
        BufferedImage image = graphicConfiguration.createCompatibleImage(width, height);
        return image;
    }

    static {
        maxPanelHeight = DEFAULT_MAX_PANEL_HEIGHT = 1000;
        snapshotInProgress = false;
    }
}

