/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.load.HubGenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.table.SearchableTableDialog;
import org.broad.igv.ui.table.SearchableTableModel;
import org.broad.igv.ui.table.SearchableTableRecord;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;

public class UCSCGenArkAction
extends MenuAction {
    private static Logger log = LogManager.getLogger(UCSCGenArkAction.class);
    IGV igv;

    public UCSCGenArkAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try (BufferedReader reader = ParsingUtils.openBufferedReader("https://hgdownload.soe.ucsc.edu/hubs/UCSC_GI.assemblyHubList.txt");){
            String line;
            String[] headers = null;
            ArrayList<SearchableTableRecord> records = new ArrayList<SearchableTableRecord>();
            String headerLine = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    headerLine = line;
                    continue;
                }
                if (headers == null) {
                    headers = Globals.tabPattern.split(headerLine.substring(1).trim());
                }
                String[] values = Globals.tabPattern.split(line.trim());
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (int i = 0; i < headers.length; ++i) {
                    attributes.put(headers[i], values[i]);
                }
                records.add(new SearchableTableRecord(attributes));
            }
            SearchableTableModel model = new SearchableTableModel(headers, records);
            SearchableTableDialog dlg = new SearchableTableDialog(null, model);
            dlg.setTitle("UCSC GenArk");
            dlg.setVisible(true);
            SearchableTableRecord rec = dlg.getSelectedRecord();
            if (!dlg.isCanceled() && rec != null) {
                String accession = rec.getAttributeValue("accession");
                String url = HubGenomeLoader.convertToHubURL(accession);
                HubGenomeLoader.loadGenome(url);
            }
        }
        catch (IOException e) {
            log.error(e);
            MessageUtils.showMessage("Error loading GenArk hub: " + e.getMessage());
        }
    }
}

