/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.io.IOException;
import java.util.List;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ucsc.hub.HubParser;
import org.broad.igv.ucsc.hub.Stanza;
import org.broad.igv.ucsc.hub.TrackConfigContainer;
import org.broad.igv.ucsc.hub.TrackDbHub;

public class Hub {
    private static Logger log = LogManager.getLogger(Hub.class);
    private final String url;
    private final String trackDbURL;
    private int order = 0;
    Stanza hubStanza;
    Stanza genomeStanza;
    List<Stanza> trackStanzas;
    List<Stanza> groupStanzas;
    TrackDbHub trackHub;

    Hub(String url, String trackDbURL, Stanza hubStanza, Stanza genomeStanza, List<Stanza> trackStanzas, List<Stanza> groupStanzas) throws IOException {
        this.url = url;
        this.trackDbURL = trackDbURL;
        this.hubStanza = hubStanza;
        this.genomeStanza = genomeStanza;
        this.trackStanzas = trackStanzas;
        this.groupStanzas = groupStanzas;
        if (trackStanzas != null) {
            this.trackHub = new TrackDbHub(trackStanzas, groupStanzas);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isAssemblyHub() {
        return this.genomeStanza.hasProperty("twoBitPath");
    }

    public String getShortLabel() {
        return this.hubStanza.hasProperty("shortLabel") ? this.hubStanza.getProperty("shortLabel") : this.url;
    }

    public String getLongLabel() {
        return this.hubStanza.hasProperty("longLabel") ? this.hubStanza.getProperty("longLabel") : this.url;
    }

    public String getDescriptionURL() {
        return this.hubStanza.hasProperty("descriptionUrl") ? this.hubStanza.getProperty("descriptionUrl") : (this.hubStanza.hasProperty("desriptionUrl") ? this.hubStanza.getProperty("desriptionUrl") : null);
    }

    static int getPriority(String priorityString) {
        try {
            String[] tokens = priorityString.trim().split("\\.");
            int p = Integer.parseInt(tokens[0]) * 100;
            if (tokens.length > 1) {
                p += Integer.parseInt(tokens[1]) * 10;
            }
            if (tokens.length > 2) {
                p += Integer.parseInt(tokens[2]);
            }
            return p;
        }
        catch (Exception e) {
            log.error("Error parsing priority string: " + priorityString, e);
            return Integer.MAX_VALUE;
        }
    }

    public GenomeConfig getGenomeConfig() {
        GenomeConfig config = new GenomeConfig();
        config.setId(this.genomeStanza.getProperty("genome"));
        if (this.genomeStanza.hasProperty("scientificName")) {
            config.setName(this.genomeStanza.getProperty("scientificName"));
        } else if (this.genomeStanza.hasProperty("organism")) {
            config.setName(this.genomeStanza.getProperty("organism"));
        } else if (this.genomeStanza.hasProperty("description")) {
            config.setName(this.genomeStanza.getProperty("description"));
        }
        if (config.getName() == null) {
            config.setName(config.getId());
        } else {
            config.setName(config.getName() + " (" + config.getId() + ")");
        }
        config.setTwoBitURL(this.genomeStanza.getProperty("twoBitPath"));
        config.setNameSet("ucsc");
        config.setWholeGenomeView(false);
        if (this.genomeStanza.hasProperty("defaultPos")) {
            config.setDefaultPos(this.genomeStanza.getProperty("defaultPos"));
        }
        config.setDescription(config.getId());
        if (this.genomeStanza.hasProperty("blat")) {
            config.setBlat(this.genomeStanza.getProperty("blat"));
        }
        if (this.genomeStanza.hasProperty("chromAliasBb")) {
            config.setChromAliasBbURL(this.genomeStanza.getProperty("chromAliasBb"));
        }
        if (this.genomeStanza.hasProperty("twoBitBptURL")) {
            config.setTwoBitBptURL(this.genomeStanza.getProperty("twoBitBptURL"));
        }
        if (this.genomeStanza.hasProperty("twoBitBptUrl")) {
            config.setTwoBitBptURL(this.genomeStanza.getProperty("twoBitBptUrl"));
        }
        if (this.genomeStanza.hasProperty("description")) {
            config.setDescription(config.getDescription() + "\n" + this.genomeStanza.getProperty("description"));
        }
        if (this.genomeStanza.hasProperty("organism")) {
            config.setDescription(config.getDescription() + "\n" + this.genomeStanza.getProperty("organism"));
        }
        if (this.genomeStanza.hasProperty("scientificName")) {
            config.setDescription(config.getDescription() + "\n" + this.genomeStanza.getProperty("scientificName"));
        }
        if (this.genomeStanza.hasProperty("htmlPath")) {
            config.setInfoURL(this.genomeStanza.getProperty("htmlPath"));
        }
        if (this.genomeStanza.hasProperty("chromSizes")) {
            config.setChromSizesURL(this.genomeStanza.getProperty("chromSizes"));
        }
        for (Stanza t : this.trackStanzas) {
            if (!"cytoBandIdeo".equals(t.name) || !t.hasProperty("bigDataUrl")) continue;
            config.setCytobandBbURL(t.getProperty("bigDataUrl"));
            break;
        }
        return config;
    }

    public List<TrackConfigContainer> getGroupedTrackConfigurations() {
        String longLabel;
        if (this.trackHub == null) {
            try {
                List<Stanza> trackStanzas = HubParser.loadStanzas(this.trackDbURL);
                this.trackHub = new TrackDbHub(trackStanzas, this.groupStanzas);
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading track configurations: " + e.getMessage(), e);
            }
        }
        String hubLabel = (longLabel = this.getLongLabel()) != null && longLabel.length() < 50 ? longLabel : this.getShortLabel();
        return this.trackHub.getGroupedTrackConfigurations(hubLabel);
    }

    public String getUrl() {
        return this.url;
    }
}

