/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.encode;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.text.NumberFormatter;
import org.broad.igv.Globals;
import org.broad.igv.encode.FileRecord;
import org.broad.igv.encode.TrackChooser;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.BrowseEncodeAction;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ParsingUtils;

public class EncodeTrackChooserFactory {
    private static Logger log = LogManager.getLogger(EncodeTrackChooserFactory.class);
    private static Map<String, TrackChooser> instanceMap = Collections.synchronizedMap(new HashMap());
    private static NumberFormatter numberFormatter = new NumberFormatter();
    private static String ENCODE_HOST = "https://www.encodeproject.org";
    private static Set<String> filteredColumns = new HashSet<String>(Arrays.asList("ID", "Assembly", "HREF", "path"));
    private static List<String> filteredExtensions = Arrays.asList("tsv", "tsv.gz");
    private static Map<String, String> speciesNames = Map.of("ce10", "Caenorhabditis elegans", "ce11", "Caenorhabditis elegans", "dm3", "Drosophila melanogaster", "dm6", "Drosophila melanogaster", "GRCh38", "Homo sapiens", "hg19", "Homo sapiens", "mm10", "Mus musculus", "mm9", "Mus musculus");
    static HashSet<String> ucscSupportedGenomes = new HashSet<String>(Arrays.asList("hg19", "mm9"));
    static HashSet<String> supportedGenomes = new HashSet<String>(Arrays.asList("ce10", "ce11", "dm3", "dm6", "GRCh38", "hg19", "mm10", "mm9"));

    public static synchronized TrackChooser getInstance(String genomeId, BrowseEncodeAction.Type type) throws IOException {
        String encodeGenomeId = EncodeTrackChooserFactory.getEncodeGenomeID(genomeId);
        String key = encodeGenomeId + type.toString();
        TrackChooser instance = instanceMap.get(key);
        if (instance == null) {
            Pair<List<String>, List<FileRecord>> records = EncodeTrackChooserFactory.getEncodeFileRecords(encodeGenomeId, type);
            if (records == null) {
                return null;
            }
            Frame parent = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            List<String> headings = records.getFirst();
            List<FileRecord> rows = records.getSecond();
            String title = EncodeTrackChooserFactory.getDialogTitle(genomeId, type);
            instance = new TrackChooser(parent, headings, rows, title);
            instanceMap.put(key, instance);
        }
        return instance;
    }

    private static String getDialogTitle(String genomeId, BrowseEncodeAction.Type type) {
        if (type == BrowseEncodeAction.Type.UCSC) {
            return "ENCODE data hosted at UCSC (2012)";
        }
        switch (type) {
            case SIGNALS_CHIP: {
                return "ENCODE CHiP Seq - Signals";
            }
            case SIGNALS_OTHER: {
                return "ENCODE Non CHiP Data - Signals";
            }
        }
        return "ENCODE";
    }

    public static boolean genomeSupportedUCSC(String genomeId) {
        return genomeId != null && ucscSupportedGenomes.contains(EncodeTrackChooserFactory.getEncodeGenomeID(genomeId));
    }

    public static boolean genomeSupported(String genomeId) {
        return genomeId != null && supportedGenomes.contains(EncodeTrackChooserFactory.getEncodeGenomeID(genomeId));
    }

    private static String getEncodeGenomeID(String genomeId) {
        switch (genomeId) {
            case "hg38": 
            case "hg38_1kg": {
                return "GRCh38";
            }
            case "b37": 
            case "1kg_v37": {
                return "hg19";
            }
        }
        return genomeId;
    }

    private static Pair<List<String>, List<FileRecord>> getEncodeFileRecords(String genomeId, BrowseEncodeAction.Type type) throws IOException {
        try (InputStream is = EncodeTrackChooserFactory.getStreamFor(genomeId, type);){
            if (is == null) {
                Pair<List<String>, List<FileRecord>> pair = null;
                return pair;
            }
            Pair headingRecordPair = EncodeTrackChooserFactory.parseRecords(is, type, genomeId);
            if (IGV.hasInstance()) {
                Set loadedPaths = IGV.getInstance().getDataResourceLocators().stream().map(rl -> rl.getPath()).collect(Collectors.toSet());
                for (FileRecord fileRecord : (List)headingRecordPair.getSecond()) {
                    if (!loadedPaths.contains(fileRecord.getPath())) continue;
                    fileRecord.setSelected(true);
                }
            }
            Pair pair = headingRecordPair;
            return pair;
        }
    }

    private static InputStream getStreamFor(String genomeId, BrowseEncodeAction.Type type) throws IOException {
        if (type == BrowseEncodeAction.Type.UCSC) {
            return EncodeTrackChooserFactory.class.getResourceAsStream("encode." + genomeId + ".txt");
        }
        String root = PreferencesManager.getPreferences().get("ENCODE_FILELIST_URL") + genomeId + ".";
        String url = null;
        switch (type) {
            case SIGNALS_CHIP: {
                url = root + "signals.chip.txt";
                break;
            }
            case SIGNALS_OTHER: {
                url = root + "signals.other.txt";
                break;
            }
            case OTHER: {
                url = root + "other.txt";
            }
        }
        if (url == null) {
            throw new RuntimeException("Unknown encode data collection type: " + String.valueOf((Object)type));
        }
        return ParsingUtils.openInputStream(url);
    }

    private static Pair parseRecords(InputStream is, BrowseEncodeAction.Type type, String genomeId) throws IOException {
        String nextLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String[] headers = Globals.tabPattern.split(reader.readLine());
        int pathColumn = type == BrowseEncodeAction.Type.UCSC ? 0 : Arrays.asList(headers).indexOf("HREF");
        ArrayList<FileRecord> records = new ArrayList<FileRecord>(20000);
        while ((nextLine = reader.readLine()) != null) {
            String path;
            if (nextLine.startsWith("#")) continue;
            String[] tokens = Globals.tabPattern.split(nextLine, -1);
            String string = path = type == BrowseEncodeAction.Type.UCSC ? tokens[pathColumn] : ENCODE_HOST + tokens[pathColumn];
            if (filteredExtensions.stream().anyMatch(e -> path.endsWith((String)e))) continue;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            for (int i = 0; i < headers.length; ++i) {
                String value;
                String string2 = value = i < tokens.length ? tokens[i] : "";
                if (value.length() <= 0) continue;
                attributes.put(headers[i], EncodeTrackChooserFactory.shortenField(value, genomeId));
            }
            FileRecord record = new FileRecord(path, attributes);
            records.add(record);
        }
        List filteredHeaders = Arrays.stream(headers).filter(h -> !filteredColumns.contains(h)).collect(Collectors.toList());
        return new Pair(filteredHeaders, records);
    }

    private static String shortenField(String value, String genomeId) {
        String species = speciesNames.get(genomeId);
        return species == null ? value : value.replace("(" + species + ")", "").replace(species, "").trim();
    }

    public static void main(String[] args) throws IOException {
        EncodeTrackChooserFactory.getInstance("hg19", BrowseEncodeAction.Type.UCSC).setVisible(true);
    }
}

