/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.samtools.SAMSequenceDictionary;
import org.broad.tribble.Tribble;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broadinstitute.sting.gatk.refdata.tracks.IndexDictionaryUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.writer.PositionalOutputStream;
import org.broadinstitute.sting.utils.variantcontext.writer.VariantContextWriter;

abstract class IndexingVariantContextWriter
implements VariantContextWriter {
    private final String name;
    private final SAMSequenceDictionary refDict;
    private OutputStream outputStream;
    private PositionalOutputStream positionalOutputStream = null;
    private DynamicIndexCreator indexer = null;
    private LittleEndianOutputStream idxStream = null;

    @Requires(value={"name != null", "! ( location == null && output == null )", "! ( enableOnTheFlyIndexing && location == null )"})
    protected IndexingVariantContextWriter(String name, File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing) {
        this.outputStream = output;
        this.name = name;
        this.refDict = refDict;
        if (enableOnTheFlyIndexing) {
            try {
                this.idxStream = new LittleEndianOutputStream(new FileOutputStream(Tribble.indexFile(location)));
                this.indexer = new DynamicIndexCreator(IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
                this.indexer.initialize(location, this.indexer.defaultBinSize());
                this.positionalOutputStream = new PositionalOutputStream(output);
                this.outputStream = this.positionalOutputStream;
            }
            catch (IOException ex) {
                this.idxStream = null;
                this.indexer = null;
                this.positionalOutputStream = null;
            }
        }
    }

    @Ensures(value={"result != null"})
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Ensures(value={"result != null"})
    public String getStreamName() {
        return this.name;
    }

    @Override
    public abstract void writeHeader(VCFHeader var1);

    @Override
    public void close() {
        if (this.indexer != null) {
            try {
                Index index = this.indexer.finalizeIndex(this.positionalOutputStream.getPosition());
                IndexDictionaryUtils.setIndexSequenceDictionary((Index)index, (SAMSequenceDictionary)this.refDict);
                index.write(this.idxStream);
                this.idxStream.close();
            }
            catch (IOException e) {
                throw new ReviewedStingException("Unable to close index for " + this.getStreamName(), e);
            }
        }
    }

    public SAMSequenceDictionary getRefDict() {
        return this.refDict;
    }

    @Override
    public void add(VariantContext vc) {
        if (this.indexer != null) {
            this.indexer.addFeature(vc, this.positionalOutputStream.getPosition());
        }
    }

    protected static final String writerName(File location, OutputStream stream) {
        return location == null ? stream.toString() : location.getAbsolutePath();
    }
}

