/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.codecs.bcf2.BCF2Type;
import org.broadinstitute.sting.utils.codecs.bcf2.BCF2Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.writer.BCF2Encoder;

@Invariant(value={"headerLine != null", "dictionaryOffsetType.isIntegerType()", "dictionaryOffset >= 0"})
public abstract class BCF2FieldEncoder {
    final VCFCompoundHeaderLine headerLine;
    final BCF2Type staticType;
    final int dictionaryOffset;
    final BCF2Type dictionaryOffsetType;

    @Requires(value={"headerLine != null", "dict != null"})
    private BCF2FieldEncoder(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict, BCF2Type staticType) {
        this.headerLine = headerLine;
        this.staticType = staticType;
        Integer offset = dict.get(this.getField());
        if (offset == null) {
            throw new ReviewedStingException("Format error: could not find string " + this.getField() + " in header as required by BCF");
        }
        this.dictionaryOffset = offset;
        this.dictionaryOffsetType = BCF2Utils.determineIntegerType((int)offset);
    }

    @Ensures(value={"result != null"})
    public final String getField() {
        return this.headerLine.getID();
    }

    @Requires(value={"encoder != null"})
    public final void writeFieldKey(BCF2Encoder encoder) throws IOException {
        encoder.encodeTypedInt(this.dictionaryOffset, this.dictionaryOffsetType);
    }

    public String toString() {
        return "BCF2FieldEncoder for " + this.getField() + " with count " + (Object)((Object)this.getCountType()) + " encoded with " + this.getClass().getSimpleName();
    }

    @Ensures(value={"result != null"})
    protected final VCFHeaderLineCount getCountType() {
        return this.headerLine.getCountType();
    }

    @Ensures(value={"result != (hasValueDeterminedNumElements() || hasContextDeterminedNumElements())"})
    public boolean hasConstantNumElements() {
        return this.getCountType() == VCFHeaderLineCount.INTEGER;
    }

    @Ensures(value={"result != (hasConstantNumElements() || hasContextDeterminedNumElements())"})
    public boolean hasValueDeterminedNumElements() {
        return this.getCountType() == VCFHeaderLineCount.UNBOUNDED;
    }

    @Ensures(value={"result != (hasValueDeterminedNumElements() || hasConstantNumElements())"})
    public boolean hasContextDeterminedNumElements() {
        return !this.hasConstantNumElements() && !this.hasValueDeterminedNumElements();
    }

    @Requires(value={"hasConstantNumElements()"})
    @Ensures(value={"result >= 0"})
    public int numElements() {
        return this.headerLine.getCount();
    }

    @Requires(value={"hasValueDeterminedNumElements()"})
    @Ensures(value={"result >= 0"})
    public int numElements(Object value) {
        return this.numElementsFromValue(value);
    }

    @Requires(value={"hasContextDeterminedNumElements()"})
    @Ensures(value={"result >= 0"})
    public int numElements(VariantContext vc) {
        return this.headerLine.getCount(vc);
    }

    @Ensures(value={"result >= 0"})
    public final int numElements(VariantContext vc, Object value) {
        if (this.hasConstantNumElements()) {
            return this.numElements();
        }
        if (this.hasContextDeterminedNumElements()) {
            return this.numElements(vc);
        }
        return this.numElements(value);
    }

    @Requires(value={"hasValueDeterminedNumElements()"})
    @Ensures(value={"result >= 0"})
    protected int numElementsFromValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof List) {
            return ((List)value).size();
        }
        return 1;
    }

    @Ensures(value={"result || isDynamicallyTyped()"})
    public final boolean isStaticallyTyped() {
        return !this.isDynamicallyTyped();
    }

    @Ensures(value={"result || isStaticallyTyped()"})
    public final boolean isDynamicallyTyped() {
        return this.staticType == null;
    }

    public final BCF2Type getType(Object value) {
        return this.isDynamicallyTyped() ? this.getDynamicType(value) : this.getStaticType();
    }

    @Requires(value={"isStaticallyTyped()"})
    @Ensures(value={"result != null"})
    public final BCF2Type getStaticType() {
        return this.staticType;
    }

    @Requires(value={"isDynamicallyTyped()"})
    @Ensures(value={"result != null"})
    public BCF2Type getDynamicType(Object value) {
        throw new ReviewedStingException("BUG: cannot get dynamic type for statically typed BCF2 field " + this.getField());
    }

    @Requires(value={"encoder != null", "isDynamicallyTyped() || type == getStaticType()", "minValues >= 0"})
    public abstract void encodeValue(BCF2Encoder var1, Object var2, BCF2Type var3, int var4) throws IOException;

    private static final <T> List<T> toList(Class<T> c, Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.singletonList(o);
    }

    public static class GenericInts
    extends BCF2FieldEncoder {
        public GenericInts(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, null);
        }

        @Override
        public BCF2Type getDynamicType(Object value) {
            return value == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((List)BCF2FieldEncoder.toList(Integer.class, value));
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            for (Integer i : BCF2FieldEncoder.toList(Integer.class, value)) {
                if (i == null) continue;
                encoder.encodeRawInt(i, type);
                ++count;
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class AtomicInt
    extends BCF2FieldEncoder {
        public AtomicInt(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, null);
        }

        @Override
        public BCF2Type getDynamicType(Object value) {
            return value == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((int)((Integer)value));
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            if (value != null) {
                encoder.encodeRawInt((Integer)value, type);
                ++count;
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class IntArray
    extends BCF2FieldEncoder {
        public IntArray(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, null);
        }

        @Override
        protected int numElementsFromValue(Object value) {
            return value == null ? 0 : ((int[])value).length;
        }

        @Override
        public BCF2Type getDynamicType(Object value) {
            return value == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((int[])((int[])value));
        }

        @Override
        @Requires(value={"value == null || ((int[])value).length <= minValues"})
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            if (value != null) {
                for (int i : (int[])value) {
                    encoder.encodeRawInt(i, type);
                    ++count;
                }
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class Float
    extends BCF2FieldEncoder {
        final boolean isAtomic = this.hasConstantNumElements() && this.numElements() == 1;

        public Float(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, BCF2Type.FLOAT);
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            int count = 0;
            if (this.isAtomic) {
                if (value != null) {
                    encoder.encodeRawFloat((Double)value);
                    ++count;
                }
            } else {
                List doubles = BCF2FieldEncoder.toList(Double.class, value);
                for (Double d : doubles) {
                    if (d == null) continue;
                    encoder.encodeRawFloat(d);
                    ++count;
                }
            }
            while (count < minValues) {
                encoder.encodeRawMissingValue(type);
                ++count;
            }
        }
    }

    public static class Flag
    extends BCF2FieldEncoder {
        public Flag(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, BCF2Type.INT8);
            if (!headerLine.isFixedCount() || headerLine.getCount() != 0) {
                throw new ReviewedStingException("Flag encoder only suppports atomic flags for field " + this.getField());
            }
        }

        @Override
        public int numElements() {
            return 1;
        }

        @Override
        @Requires(value={"minValues <= 1", "value != null", "value instanceof Boolean", "((Boolean)value) == true"})
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            encoder.encodeRawBytes(1, this.getStaticType());
        }
    }

    public static class StringOrCharacter
    extends BCF2FieldEncoder {
        public StringOrCharacter(VCFCompoundHeaderLine headerLine, Map<String, Integer> dict) {
            super(headerLine, dict, BCF2Type.CHAR);
        }

        @Override
        public void encodeValue(BCF2Encoder encoder, Object value, BCF2Type type, int minValues) throws IOException {
            String s = this.javaStringToBCF2String(value);
            encoder.encodeRawString(s, Math.max(s.length(), minValues));
        }

        @Override
        public boolean hasConstantNumElements() {
            return false;
        }

        @Override
        public boolean hasContextDeterminedNumElements() {
            return false;
        }

        @Override
        public boolean hasValueDeterminedNumElements() {
            return true;
        }

        @Override
        protected int numElementsFromValue(Object value) {
            return value == null ? 0 : this.javaStringToBCF2String(value).length();
        }

        @Ensures(value={"result != null"})
        private String javaStringToBCF2String(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof List) {
                List l = (List)value;
                if (l.isEmpty()) {
                    return "";
                }
                if (l.size() == 1) {
                    return (String)l.get(0);
                }
                return BCF2Utils.collapseStringList((List)l);
            }
            return (String)value;
        }
    }
}

