/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.WrappedIterator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.collections.MultiMap;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;

public class GFFFeatureSource
extends TribbleFeatureSource {
    private static Logger log = Logger.getLogger(GFFFeatureSource.class);
    public static final String PHASE_STRING = "XXPHASE_STRINGXX";

    public static boolean isGFF(String path) {
        int idx;
        String lowpath = path.toLowerCase();
        if (lowpath.endsWith(".gz")) {
            idx = lowpath.length() - 3;
            lowpath = lowpath.substring(0, idx);
        }
        if (lowpath.endsWith(".txt")) {
            idx = lowpath.length() - 4;
            lowpath = lowpath.substring(0, idx);
        }
        return lowpath.endsWith("gff3") || lowpath.endsWith("gvf") || lowpath.endsWith("gff") || lowpath.endsWith("gtf");
    }

    public GFFFeatureSource(String path, Genome genome) throws IOException {
        super(path, genome);
        this.isVCF = false;
    }

    @Override
    public CloseableTribbleIterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        Iterator rawIter = super.getFeatures(chr, start, end);
        return new WrappedIterator<Feature>(new GFFCombiner().combineFeatures(rawIter).iterator());
    }

    static class GFF3Transcript {
        private String id;
        private Set<Exon> exons = new HashSet<Exon>();
        private List<Exon> cdss = new ArrayList<Exon>();
        private Exon fivePrimeUTR;
        private Exon threePrimeUTR;
        private BasicFeature transcript;
        private String parentId;
        String chr = null;
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        String description;
        MultiMap<String, String> attributes;
        Map<String, BasicFeature> geneCache;

        GFF3Transcript(String id, Map<String, BasicFeature> geneCache) {
            this.id = id;
            this.geneCache = geneCache;
        }

        void transcript(BasicFeature mRNA, String parent) {
            this.transcript = mRNA;
            this.parentId = parent;
            if (mRNA.getName() == null) {
                mRNA.setName(mRNA.getIdentifier());
            }
            if (mRNA.getName() == null) {
                return;
            }
            int prefixIndex = mRNA.getName().indexOf(":");
            if (prefixIndex > 0) {
                mRNA.setName(mRNA.getName().substring(prefixIndex + 1));
            }
        }

        void setFivePrimeUTR(Exon exon) {
            this.fivePrimeUTR = exon;
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void setThreePrimeUTR(Exon exon) {
            this.threePrimeUTR = exon;
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void addExon(Exon exon) {
            this.exons.add(exon);
            this.start = Math.min(exon.getStart(), this.start);
            this.end = Math.max(exon.getEnd(), this.end);
        }

        void addCDS(Exon cds) {
            this.cdss.add(cds);
            this.start = Math.min(cds.getStart(), this.start);
            this.end = Math.max(cds.getEnd(), this.end);
        }

        void addCDSParts(String chr, int start, int end) {
            this.chr = chr;
            this.start = Math.min(this.start, start);
            this.end = Math.max(this.end, end);
        }

        Feature createTranscript() {
            Strand strand = Strand.NONE;
            String name = null;
            for (Exon cds : this.cdss) {
                Exon exon = this.findMatchingExon(cds);
                if (exon == null) {
                    cds.setCodingStart(cds.getStart());
                    cds.setCodingEnd(cds.getEnd());
                    this.exons.add(cds);
                    continue;
                }
                exon.setCodingStart(cds.getStart());
                exon.setCodingEnd(cds.getEnd());
                exon.setReadingFrame(cds.getReadingShift());
            }
            for (Exon exon : this.exons) {
                this.chr = exon.getChr();
                strand = exon.getStrand();
                this.start = Math.min(exon.getStart(), this.start);
                this.end = Math.max(exon.getEnd(), this.end);
                name = exon.getName();
            }
            if (this.transcript == null) {
                this.transcript = new BasicFeature(this.chr, this.start, this.end, strand);
                this.transcript.setIdentifier(this.id);
                this.transcript.setName(name == null ? this.id : name);
                this.transcript.setDescription(this.description);
                this.transcript.setAttributes(this.attributes);
            }
            if (this.parentId != null && this.geneCache.containsKey(this.parentId)) {
                BasicFeature gene = this.geneCache.get(this.parentId);
                this.geneCache.remove(this.parentId);
                if (this.transcript.getName() == null && gene.getName() != null) {
                    this.transcript.setName(gene.getName());
                }
                this.transcript.setDescription("Transcript<br>" + this.transcript.getDescription() + "<br>--------<br>Gene<br>" + gene.getDescription());
            }
            for (Exon exon : this.exons) {
                this.transcript.addExon(exon);
                if (this.transcript.getColor() != null || exon.getColor() == null) continue;
                this.transcript.setColor(exon.getColor());
            }
            this.transcript.sortExons();
            if (this.fivePrimeUTR != null) {
                this.adjustBoundariesByUTR(this.fivePrimeUTR);
            }
            if (this.threePrimeUTR != null) {
                this.adjustBoundariesByUTR(this.threePrimeUTR);
            }
            return this.transcript;
        }

        private void adjustBoundariesByUTR(Exon UTR) {
            UTR.setUTR(true);
            this.transcript.addExon(UTR);
            Exon exon = this.findMatchingExon(UTR);
            if (exon != null) {
                if (exon.getStrand() == Strand.POSITIVE) {
                    exon.setStart(UTR.getEnd());
                } else {
                    exon.setEnd(UTR.getStart());
                }
            }
        }

        private void insertCDS(Exon cds) {
            int insertLoc = 0;
            boolean foundExon = false;
            for (Exon exon : this.exons) {
                if (exon.contains(cds)) {
                    exon.setCodingStart(cds.getStart());
                    exon.setCodingEnd(cds.getEnd());
                    exon.setReadingFrame(cds.getReadingShift());
                    foundExon = true;
                    break;
                }
                if (cds.getStart() <= exon.getStart()) break;
                ++insertLoc;
            }
            if (!foundExon) {
                cds.setCodingStart(cds.getStart());
                cds.setCodingEnd(cds.getEnd());
            }
        }

        Exon findMatchingExon(IGVFeature cds) {
            for (Exon exon : this.exons) {
                if (!exon.contains(cds)) continue;
                return exon;
            }
            return null;
        }
    }

    public static class GFFCombiner {
        Map<String, GFF3Transcript> transcriptCache = new HashMap<String, GFF3Transcript>(50000);
        Map<String, BasicFeature> geneCache = new HashMap<String, BasicFeature>(50000);

        private void clearCombinedFeatures() {
            this.transcriptCache.clear();
            this.geneCache.clear();
        }

        public List<Feature> combineFeatures(Iterator<Feature> rawIter) {
            ArrayList<Feature> features = new ArrayList<Feature>();
            while (rawIter.hasNext()) {
                BasicFeature bf = (BasicFeature)rawIter.next();
                String featureType = bf.getType();
                if (featureType.equalsIgnoreCase("CDS_parts") || featureType.equalsIgnoreCase("intron")) {
                    String[] parentIds;
                    for (String pid : parentIds = bf.getParentIds()) {
                        this.getGFF3Transcript(pid).addCDSParts(bf.getChr(), bf.getStart(), bf.getEnd());
                    }
                    continue;
                }
                if (GFFCodec.exonTerms.contains(featureType)) {
                    this.incorporateExon(bf);
                    continue;
                }
                BasicFeature f = this.incorporateFeature(bf);
                if (f == null) continue;
                features.add(f);
            }
            for (GFF3Transcript transcript : this.transcriptCache.values()) {
                Feature igvTranscript = transcript.createTranscript();
                if (igvTranscript == null) continue;
                features.add(igvTranscript);
            }
            FeatureUtils.sortFeatureList(features);
            return features;
        }

        private void incorporateExon(BasicFeature bf) {
            String featureType = bf.getType();
            String[] parentIds = bf.getParentIds();
            if (!this.isValidParentIds(parentIds) && bf.getIdentifier() != null) {
                parentIds = new String[]{bf.getIdentifier()};
                bf.setParentIds(parentIds);
            }
            for (String pid : parentIds) {
                int phase;
                Exon exon = new Exon(bf.getChr(), bf.getStart(), bf.getEnd(), bf.getStrand());
                if (bf.getColor() != null) {
                    exon.setColor(bf.getColor());
                }
                String sPhase = bf.getAttributes().remove(GFFFeatureSource.PHASE_STRING);
                exon.setAttributes(bf.getAttributes());
                exon.setUTR(GFFCodec.utrTerms.contains(featureType));
                if (sPhase != null && (phase = this.parsePhase(sPhase)) >= 0) {
                    exon.setPhase(phase);
                }
                exon.setName(bf.getName());
                if (featureType.equalsIgnoreCase("exon")) {
                    this.getGFF3Transcript(pid).addExon(exon);
                    continue;
                }
                if (featureType.equalsIgnoreCase("CDS")) {
                    this.getGFF3Transcript(pid).addCDS(exon);
                    continue;
                }
                if (featureType.equalsIgnoreCase("five_prime_UTR") || featureType.equalsIgnoreCase("5'-UTR")) {
                    this.getGFF3Transcript(pid).setFivePrimeUTR(exon);
                    continue;
                }
                if (!featureType.equalsIgnoreCase("three_prime_UTR") && !featureType.equalsIgnoreCase("3'-UTR")) continue;
                this.getGFF3Transcript(pid).setThreePrimeUTR(exon);
            }
        }

        private BasicFeature incorporateFeature(BasicFeature bf) {
            String featureType = bf.getType();
            String id = bf.getIdentifier();
            if (featureType.equalsIgnoreCase("gene")) {
                this.geneCache.put(id, bf);
                return bf;
            }
            if (featureType.equalsIgnoreCase("mRNA") || featureType.equalsIgnoreCase("transcript")) {
                String pid = null;
                String[] parentIds = bf.getParentIds();
                if (this.isValidParentIds(parentIds)) {
                    pid = parentIds[0];
                }
                this.getGFF3Transcript(id).transcript(bf, pid);
                return null;
            }
            return bf;
        }

        private int parsePhase(String phaseString) {
            int phase = -1;
            if (!phaseString.equals(".")) {
                try {
                    phase = Integer.parseInt(phaseString);
                }
                catch (NumberFormatException numberFormatException) {
                    log.error("GFF3 error: non numeric phase: " + phaseString);
                }
            }
            return phase;
        }

        private GFF3Transcript getGFF3Transcript(String id) {
            GFF3Transcript transcript = this.transcriptCache.get(id);
            if (transcript == null) {
                transcript = new GFF3Transcript(id, this.geneCache);
                this.transcriptCache.put(id, transcript);
            }
            return transcript;
        }

        private boolean isValidParentIds(String[] parentIds) {
            return parentIds != null && parentIds.length > 0 && parentIds[0] != null && parentIds[0].trim().length() > 0 && !parentIds[0].equals(".");
        }
    }
}

