/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.RendererFactory;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TooltipTextFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;

public abstract class AbstractTrack
implements Track {
    private static Logger log = Logger.getLogger(AbstractTrack.class);
    private static Class defaultRendererClass = BarChartRenderer.class;
    private static Map<TrackType, Class> defaultRendererMap = new HashMap<TrackType, Class>();
    private String id;
    private String name;
    private String url;
    private boolean itemRGB = true;
    private boolean useScore;
    private float viewLimitMin = Float.NaN;
    private float viewLimitMax = Float.NaN;
    protected int fontSize = PreferenceManager.getInstance().getAsInt("DEFAULT_FONT_SIZE");
    private boolean showDataRange = true;
    private String sampleId;
    private ResourceLocator resourceLocator;
    private int top;
    protected int minimumHeight = -1;
    protected int maximumHeight = 1000;
    private TrackType trackType = TrackType.OTHER;
    private boolean selected = false;
    private boolean visible = true;
    private boolean sortable = true;
    boolean overlaid;
    boolean drawYLine = false;
    float yLine = 0.0f;
    private Map<String, String> attributes = new HashMap<String, String>();
    private ContinuousColorScale colorScale;
    protected boolean autoScale;
    private Color posColor = Color.blue.darker();
    private Color altColor = Color.blue.darker();
    private DataRange dataRange;
    protected int visibilityWindow = -1;
    private Track.DisplayMode displayMode = Track.DisplayMode.COLLAPSED;
    protected int height = -1;
    private final PreferenceManager prefMgr;

    public AbstractTrack(ResourceLocator dataResourceLocator, String id, String name) {
        this.resourceLocator = dataResourceLocator;
        this.id = id;
        this.name = name;
        this.init();
        this.prefMgr = PreferenceManager.getInstance();
    }

    public AbstractTrack(ResourceLocator dataResourceLocator, String id) {
        this(dataResourceLocator, id, dataResourceLocator.getTrackName());
    }

    public AbstractTrack(ResourceLocator dataResourceLocator) {
        this(dataResourceLocator, dataResourceLocator.getPath(), dataResourceLocator.getTrackName());
    }

    public AbstractTrack(String id) {
        this(null, id, id);
    }

    public AbstractTrack(String id, String name) {
        this(null, id, name);
    }

    private void init() {
        this.showDataRange = PreferenceManager.getInstance().getAsBoolean("CHART.SHOW_DATA_RANGE");
        if (PreferenceManager.getInstance().getAsBoolean("EXPAND_FEATURE_TRACKS")) {
            this.displayMode = Track.DisplayMode.EXPANDED;
        }
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String getDisplayName() {
        String name;
        String sampleKey = IGV.getInstance().getSession().getTrackAttributeName();
        if (sampleKey != null && sampleKey.trim().length() > 0 && (name = this.getAttributeValue(sampleKey.trim())) != null) {
            return name;
        }
        return this.getName();
    }

    @Override
    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    @Override
    public void preload(RenderContext context) {
    }

    @Override
    public boolean isFilterable() {
        return true;
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Rectangle rect = this.getDisplayableRect(trackRectangle, visibleRectangle);
        String trackName = this.getDisplayName();
        if (trackName != null && rect.getHeight() > 3.0) {
            int gap = Math.min(4, rect.height / 3);
            int fs = Math.min(this.fontSize, rect.height - gap);
            Font font = FontManager.getFont(fs);
            g2D.setFont(font);
            GraphicUtils.drawWrappedText(trackName, rect, g2D, false);
        }
    }

    @Override
    public void renderAttributes(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRect, List<String> names, List<MouseableRegion> mouseRegions) {
        int x = trackRectangle.x;
        for (String name : names) {
            String key = name.toUpperCase();
            String attributeValue = this.getAttributeValue(key);
            if (attributeValue != null) {
                Rectangle rect = new Rectangle(x, trackRectangle.y, 10, trackRectangle.height);
                graphics.setColor(AttributeManager.getInstance().getColor(key, attributeValue));
                graphics.fill(rect);
                mouseRegions.add(new MouseableRegion(rect, key, attributeValue));
            }
            x += 11;
        }
    }

    private Rectangle getDisplayableRect(Rectangle trackRectangle, Rectangle visibleRect) {
        Rectangle rect = null;
        if (visibleRect != null) {
            Rectangle intersectedRect = trackRectangle.intersection(visibleRect);
            rect = intersectedRect.height > 15 ? intersectedRect : new Rectangle(trackRectangle);
        }
        return rect;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
    }

    @Override
    public Color getColor() {
        return this.posColor;
    }

    @Override
    public Color getAltColor() {
        return this.altColor;
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    @Override
    public void setAttributeValue(String name, String value) {
        String key = name.toUpperCase();
        this.attributes.put(key, value);
        AttributeManager.getInstance().addAttribute(this.getSample(), name, value);
    }

    @Override
    public String getAttributeValue(String attributeName) {
        String key = attributeName.toUpperCase();
        String value = this.attributes.get(key);
        AttributeManager attributeManager = AttributeManager.getInstance();
        if (value == null && this.getSample() != null) {
            value = attributeManager.getAttribute(this.getSample(), key);
        }
        if (value == null) {
            value = attributeManager.getAttribute(this.getName(), key);
        }
        if (value == null && this.getResourceLocator() != null && this.getResourceLocator().getPath() != null) {
            value = attributeManager.getAttribute(this.getResourceLocator().getPath(), key);
        }
        return value;
    }

    @Override
    public String getSample() {
        if (this.sampleId != null) {
            return this.sampleId;
        }
        String key = AttributeManager.getInstance().getSampleFor(this.getName());
        return key != null ? key : this.getName();
    }

    private int getDefaultHeight() {
        if (XYPlotRenderer.class.isAssignableFrom(this.getDefaultRendererClass())) {
            return PreferenceManager.getInstance().getAsInt("IGV.chart.track.height");
        }
        return PreferenceManager.getInstance().getAsInt("IGV.track.height");
    }

    public int getDefaultMinimumHeight() {
        Renderer r = this.getRenderer();
        if (r != null && HeatmapRenderer.class.isAssignableFrom(r.getClass())) {
            return 1;
        }
        return 10;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public void setMaximumHeight(int maximumHeight) {
        this.maximumHeight = maximumHeight;
    }

    @Override
    public int getMinimumHeight() {
        return this.minimumHeight < 0 ? this.getDefaultMinimumHeight() : this.minimumHeight;
    }

    public int getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setTrackType(TrackType type) {
        this.trackType = type;
    }

    @Override
    public TrackType getTrackType() {
        return this.trackType;
    }

    @Override
    public boolean isVisible() {
        boolean displayOverlays;
        if (this.visible && this.getTrackType() == TrackType.MUTATION && (displayOverlays = IGV.getInstance().getSession().getOverlayMutationTracks())) {
            if (this.overlaid) {
                return false;
            }
            return this.prefMgr.getAsBoolean("SHOW_ORPHANED_MUTATIONS");
        }
        return this.visible;
    }

    @Override
    public void setColor(Color color) {
        this.posColor = color;
    }

    @Override
    public void setAltColor(Color color) {
        this.altColor = color;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    @Override
    public void setOverlayed(boolean bool) {
        this.overlaid = bool;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setHeight(int height) {
        if (height < this.getHeight() && this.getDisplayMode() == Track.DisplayMode.EXPANDED && this.getTrackType() != TrackType.GENE) {
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
        }
        this.height = Math.min(Math.max(this.getMinimumHeight(), height), this.getMaximumHeight());
    }

    @Override
    public int getHeight() {
        return this.height < 0 ? this.getDefaultHeight() : this.height;
    }

    @Override
    public boolean hasDataRange() {
        return this.dataRange != null;
    }

    @Override
    public DataRange getDataRange() {
        if (this.dataRange == null) {
            float min = (float)(this.colorScale == null ? 0.0 : this.colorScale.getMinimum());
            float max = (float)(this.colorScale == null ? 10.0 : this.colorScale.getMaximum());
            float baseline = (float)(this.colorScale == null ? 0.0 : (this.colorScale.getNegStart() + this.colorScale.getPosStart()) / 2.0);
            this.setDataRange(new DataRange(min, baseline, max));
        }
        return this.dataRange;
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        this.dataRange = axisDefinition;
    }

    protected Class getDefaultRendererClass() {
        Class def = defaultRendererMap.get((Object)this.getTrackType());
        return def == null ? defaultRendererClass : def;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        if (IGV.getInstance().isShowDetailsOnClick()) {
            return this.openTooltipWindow(te);
        }
        return false;
    }

    protected boolean openTooltipWindow(TrackClickEvent e) {
        ReferenceFrame frame = e.getFrame();
        MouseEvent me = e.getMouseEvent();
        String popupText = this.getValueStringAt(frame.getChrName(), e.getChromosomePosition(), e.getMouseEvent().getY(), frame);
        if (popupText != null) {
            final TooltipTextFrame tf = new TooltipTextFrame(this.getName(), popupText);
            Point p = me.getComponent().getLocationOnScreen();
            tf.setLocation(Math.max(0, p.x + me.getX() - 150), Math.max(0, p.y + me.getY() - 150));
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    tf.setVisible(true);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void handleNameClick(MouseEvent e) {
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    @Override
    public void setProperties(TrackProperties properties) {
        Map<String, String> attributes;
        this.itemRGB = properties.isItemRGB();
        this.useScore = properties.isUseScore();
        this.viewLimitMin = properties.getMinValue();
        this.viewLimitMax = properties.getMaxValue();
        this.yLine = properties.getyLine();
        this.drawYLine = properties.isDrawYLine();
        this.sortable = properties.isSortable();
        if (!Float.isNaN(this.viewLimitMin) && !Float.isNaN(this.viewLimitMax)) {
            this.setAutoScale(false);
        } else {
            this.setAutoScale(properties.isAutoScale());
        }
        if (!properties.isAutoScale()) {
            float min = properties.getMinValue();
            float max = properties.getMaxValue();
            float mid = properties.getMidValue();
            if (Float.isNaN(mid)) {
                mid = min >= 0.0f ? Math.max(min, 0.0f) : Math.min(max, 0.0f);
            }
            DataRange dr = new DataRange(min, mid, max);
            this.setDataRange(dr);
            if (properties.isLogScale()) {
                dr.setType(DataRange.Type.LOG);
            }
            Color maxColor = properties.getColor();
            Color minColor = properties.getAltColor();
            if (maxColor != null && minColor != null) {
                float tmp = properties.getNeutralFromValue();
                float neutralFrom = Float.isNaN(tmp) ? mid : tmp;
                tmp = properties.getNeutralToValue();
                float neutralTo = Float.isNaN(tmp) ? mid : tmp;
                Color midColor = properties.getMidColor();
                if (midColor == null) {
                    midColor = Color.white;
                }
                this.colorScale = new ContinuousColorScale(neutralFrom, min, neutralTo, max, minColor, midColor, maxColor);
            }
        }
        if (properties.getDisplayMode() != null) {
            this.setDisplayMode(properties.getDisplayMode());
        }
        if (properties.getName() != null) {
            this.name = properties.getName();
        }
        if (properties.getColor() != null) {
            this.setColor(properties.getColor());
        }
        if (properties.getAltColor() != null) {
            this.setAltColor(properties.getAltColor());
        }
        if (properties.getMidColor() != null) {
            // empty if block
        }
        if (properties.getHeight() > 0) {
            this.setHeight(properties.getHeight());
        }
        if (properties.getMinHeight() > 0) {
            this.setMinimumHeight(properties.getMinHeight());
        }
        if (properties.getRendererClass() != null) {
            this.setRendererClass(properties.getRendererClass());
        }
        if (properties.getWindowingFunction() != null) {
            this.setWindowFunction(properties.getWindowingFunction());
        }
        if (properties.getUrl() != null) {
            this.setUrl(properties.getUrl());
        }
        if ((attributes = properties.getAttributes()) != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.setAttributeValue(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public int getY() {
        return this.top;
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    public void setY(int top) {
        this.top = top;
    }

    @Override
    public ContinuousColorScale getColorScale() {
        if (this.colorScale == null) {
            ContinuousColorScale defaultScale;
            if (IGV.hasInstance() && (defaultScale = IGV.getInstance().getSession().getColorScale(this.trackType)) != null) {
                return defaultScale;
            }
            double min = this.dataRange == null ? 0.0 : (double)this.dataRange.getMinimum();
            double max = this.dataRange == null ? 10.0 : (double)this.dataRange.getMaximum();
            Color c = this.getColor();
            Color minColor = Color.white;
            if (min < 0.0) {
                minColor = this.altColor == null ? this.oppositeColor(minColor) : this.altColor;
                this.colorScale = new ContinuousColorScale(min, 0.0, max, minColor, Color.white, c);
            } else {
                this.colorScale = new ContinuousColorScale(min, max, minColor, c);
            }
            this.colorScale.setNoDataColor(UIConstants.NO_DATA_COLOR);
        }
        return this.colorScale;
    }

    private Color oppositeColor(Color c) {
        float[] rgb = new float[4];
        c.getRGBComponents(rgb);
        rgb[0] = Math.abs(rgb[0] - 255.0f);
        rgb[1] = Math.abs(rgb[1] - 255.0f);
        rgb[2] = Math.abs(rgb[2] - 255.0f);
        return Color.getHSBColor(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public Map<String, String> getPersistentState() {
        WindowFunction wf;
        RendererFactory.RendererType type;
        Renderer renderer;
        StringBuffer stringBuffer;
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (this.colorScale != null && !this.colorScale.isDefault()) {
            attributes.put(IGVSessionReader.SessionAttribute.COLOR_SCALE.getText(), this.colorScale.asString());
        }
        attributes.put("showDataRange", String.valueOf(this.showDataRange));
        attributes.put(IGVSessionReader.SessionAttribute.VISIBLE.getText(), String.valueOf(this.visible));
        if (this.height >= 0) {
            String value = Integer.toString(this.height);
            attributes.put(IGVSessionReader.SessionAttribute.HEIGHT.getText(), value);
        }
        if (this.name != null) {
            attributes.put(IGVSessionReader.SessionAttribute.NAME.getText(), this.name);
        }
        if (!this.sortable) {
            attributes.put("sortable", "false");
        }
        if (this.posColor != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.posColor.getRed());
            stringBuffer.append(",");
            stringBuffer.append(this.posColor.getGreen());
            stringBuffer.append(",");
            stringBuffer.append(this.posColor.getBlue());
            attributes.put(IGVSessionReader.SessionAttribute.COLOR.getText(), stringBuffer.toString());
        }
        if (this.altColor != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.altColor.getRed());
            stringBuffer.append(",");
            stringBuffer.append(this.altColor.getGreen());
            stringBuffer.append(",");
            stringBuffer.append(this.altColor.getBlue());
            attributes.put(IGVSessionReader.SessionAttribute.ALT_COLOR.getText(), stringBuffer.toString());
        }
        if ((renderer = this.getRenderer()) != null && (type = RendererFactory.getRenderType(renderer)) != null) {
            attributes.put(IGVSessionReader.SessionAttribute.RENDERER.getText(), type.name());
        }
        if ((wf = this.getWindowFunction()) != null) {
            attributes.put(IGVSessionReader.SessionAttribute.WINDOW_FUNCTION.getText(), wf.name());
        }
        attributes.put("fontSize", String.valueOf(this.fontSize));
        attributes.put(IGVSessionReader.SessionAttribute.DISPLAY_MODE.getText(), String.valueOf((Object)this.displayMode));
        attributes.put(IGVSessionReader.SessionAttribute.FEATURE_WINDOW.getText(), String.valueOf(this.visibilityWindow));
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        String fvw;
        String displayModeText;
        Class rendererClass;
        int blue;
        int green;
        int red;
        String[] rgb;
        String fontSizeString;
        String showDataRangeString;
        String sortableString;
        ColorScale cs;
        String displayName = attributes.get(IGVSessionReader.SessionAttribute.DISPLAY_NAME.getText());
        String name = attributes.get(IGVSessionReader.SessionAttribute.NAME.getText());
        String isVisible = attributes.get(IGVSessionReader.SessionAttribute.VISIBLE.getText());
        String height = attributes.get(IGVSessionReader.SessionAttribute.HEIGHT.getText());
        String colorString = attributes.get(IGVSessionReader.SessionAttribute.COLOR.getText());
        String altColorString = attributes.get(IGVSessionReader.SessionAttribute.ALT_COLOR.getText());
        String rendererType = attributes.get(IGVSessionReader.SessionAttribute.RENDERER.getText());
        String windowFunction = attributes.get(IGVSessionReader.SessionAttribute.WINDOW_FUNCTION.getText());
        String scale = attributes.get(IGVSessionReader.SessionAttribute.SCALE.getText());
        String colorScale = attributes.get(IGVSessionReader.SessionAttribute.COLOR_SCALE.getText());
        if (colorScale != null && (cs = ColorScaleFactory.getScaleFromString(colorScale)) instanceof ContinuousColorScale) {
            this.setColorScale((ContinuousColorScale)cs);
        }
        if (name != null && name.length() > 0) {
            this.setName(name);
        } else if (displayName != null && displayName.length() > 0) {
            this.setName(displayName);
        }
        if (isVisible != null) {
            if (isVisible.equalsIgnoreCase("true")) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }
        if ((sortableString = attributes.get("sortable")) != null) {
            this.sortable = Boolean.parseBoolean(sortableString);
        }
        if ((showDataRangeString = attributes.get("showDataRange")) != null) {
            try {
                this.showDataRange = Boolean.parseBoolean(showDataRangeString);
            }
            catch (Exception e) {
                log.error("Error parsing data range: " + showDataRangeString);
            }
        }
        if (height != null) {
            try {
                this.setHeight(Integer.parseInt(height));
            }
            catch (NumberFormatException e) {
                log.error("Error restoring track height: " + height);
            }
        }
        if ((fontSizeString = attributes.get("fontSize")) != null) {
            try {
                this.setFontSize(Integer.parseInt(fontSizeString));
            }
            catch (NumberFormatException e) {
                log.error("Error restoring font size: " + fontSizeString);
            }
        }
        if (colorString != null) {
            try {
                rgb = colorString.split(",");
                red = Integer.parseInt(rgb[0]);
                green = Integer.parseInt(rgb[1]);
                blue = Integer.parseInt(rgb[2]);
                this.posColor = new Color(red, green, blue);
            }
            catch (NumberFormatException e) {
                log.error("Error restoring color: " + colorString);
            }
        }
        if (altColorString != null) {
            try {
                rgb = altColorString.split(",");
                red = Integer.parseInt(rgb[0]);
                green = Integer.parseInt(rgb[1]);
                blue = Integer.parseInt(rgb[2]);
                this.altColor = new Color(red, green, blue);
            }
            catch (NumberFormatException e) {
                log.error("Error restoring color: " + colorString);
            }
        }
        if (rendererType != null && (rendererClass = RendererFactory.getRendererClass(rendererType)) != null) {
            this.setRendererClass(rendererClass);
        }
        if (windowFunction != null) {
            this.setWindowFunction(WindowFunction.getWindowFunction(windowFunction));
        }
        if (scale != null) {
            String[] axis = scale.split(",");
            float minimum = Float.parseFloat(axis[0]);
            float baseline = Float.parseFloat(axis[1]);
            float maximum = Float.parseFloat(axis[2]);
            this.setDataRange(new DataRange(minimum, baseline, maximum));
        }
        if ((displayModeText = attributes.get(IGVSessionReader.SessionAttribute.DISPLAY_MODE.getText())) != null) {
            try {
                this.setDisplayMode(Track.DisplayMode.valueOf(displayModeText));
            }
            catch (Exception e) {
                log.error("Error interpreting display mode: " + displayModeText);
            }
        } else {
            String isExpanded = attributes.get(IGVSessionReader.SessionAttribute.EXPAND.getText());
            if (isExpanded != null) {
                if (isExpanded.equalsIgnoreCase("true")) {
                    this.setDisplayMode(Track.DisplayMode.EXPANDED);
                } else {
                    this.setDisplayMode(Track.DisplayMode.COLLAPSED);
                }
            }
        }
        if ((fvw = attributes.get(IGVSessionReader.SessionAttribute.FEATURE_WINDOW.getText())) != null) {
            try {
                this.visibilityWindow = Integer.parseInt(fvw);
            }
            catch (NumberFormatException e) {
                log.error("Error restoring featureVisibilityWindow: " + fvw);
            }
        }
    }

    @Override
    public boolean isItemRGB() {
        return this.itemRGB;
    }

    @Override
    public boolean isUseScore() {
        return this.useScore;
    }

    @Override
    public float getViewLimitMin() {
        return this.viewLimitMin;
    }

    @Override
    public float getViewLimitMax() {
        return this.viewLimitMax;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public boolean isShowDataRange() {
        return this.showDataRange;
    }

    public void setShowDataRange(boolean showDataRange) {
        this.showDataRange = showDataRange;
    }

    @Override
    public Feature getFeatureAtMousePosition(TrackClickEvent e) {
        return null;
    }

    public static float getLogNormalizedValue(float value, double norm) {
        if (norm == 0.0) {
            return Float.NaN;
        }
        return (float)(Math.log((double)Math.max(Float.MIN_VALUE, value) / norm) / Globals.log2);
    }

    @Override
    public float logScaleData(float dataY) {
        if (!(this.getTrackType() != TrackType.COPY_NUMBER && this.getTrackType() != TrackType.ALLELE_SPECIFIC_COPY_NUMBER && this.getTrackType() != TrackType.CNV || this.isLogNormalized())) {
            double centerValue = this.getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER ? 1.0 : 2.0;
            dataY = AbstractTrack.getLogNormalizedValue(dataY, centerValue);
        }
        return dataY;
    }

    @Override
    public boolean isRegionScoreType(RegionScoreType type) {
        return this.getTrackType() == TrackType.GENE_EXPRESSION && type == RegionScoreType.EXPRESSION || (this.getTrackType() == TrackType.COPY_NUMBER || this.getTrackType() == TrackType.CNV || this.getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER) && (type == RegionScoreType.AMPLIFICATION || type == RegionScoreType.DELETION || type == RegionScoreType.FLUX) || type == RegionScoreType.MUTATION_COUNT || type == RegionScoreType.SCORE;
    }

    @Override
    public void setVisibilityWindow(int i) {
        this.visibilityWindow = i;
    }

    @Override
    public int getVisibilityWindow() {
        return this.visibilityWindow;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return null;
    }

    @Override
    public Track.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        this.displayMode = mode;
    }

    @Override
    public String getNameValueString(int y) {
        return this.getName();
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        return null;
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return this.getRegionScore(chr, start, end, zoom, type, frameName, null);
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName, List<Track> tracks) {
        return 0.0f;
    }

    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    @Override
    public boolean isDrawYLine() {
        return this.drawYLine;
    }

    @Override
    public float getYLine() {
        return this.yLine;
    }

    @Override
    public void updateGenome(Genome genome) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    static {
        defaultRendererMap.put(TrackType.RNAI, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.COPY_NUMBER, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.CNV, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.ALLELE_SPECIFIC_COPY_NUMBER, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.GENE_EXPRESSION, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.DNA_METHYLATION, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.LOH, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.OTHER, BarChartRenderer.class);
        defaultRendererMap.put(TrackType.CHIP_CHIP, HeatmapRenderer.class);
    }
}

