/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.plugin;

import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.Utilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Argument {
    private static final Logger log = Logger.getLogger(Argument.class);
    private String name;
    private InputType type;
    private String cmdArg;
    private String defaultValue;
    private boolean output;
    private String id;
    private String encodingCodec;
    private URL[] libURLs;

    public String getEncodingCodec() {
        return this.encodingCodec;
    }

    Argument(String name, InputType type, String cmdArg, String defaultValue, String encodingCodec, String libs, String specPath, boolean isOutput, String id) {
        this.name = name;
        this.type = type;
        this.cmdArg = cmdArg != null ? cmdArg : "";
        this.defaultValue = defaultValue;
        this.encodingCodec = encodingCodec;
        this.libURLs = FileUtils.getURLsFromString(libs, specPath);
        this.output = isOutput;
        this.id = id;
        if (!this.output && id == null) {
            log.info(String.format("Argument %s is not output but it also has no id. This argument will have no effect", name));
        }
    }

    static Argument parseFromNode(Node node, String specPath) {
        NamedNodeMap attrs = node.getAttributes();
        String name = Utilities.getNullSafe(attrs, "name");
        InputType type = InputType.valueOf(Utilities.getNullSafe(attrs, "type").toUpperCase());
        String cmdArg = Utilities.getNullSafe(attrs, "cmd_arg");
        String defVal = Utilities.getNullSafe(attrs, "default");
        String encCodec = Utilities.getNullSafe(attrs, "encoding_codec");
        String libString = Utilities.getNullSafe(attrs, "libs");
        libString = libString != null ? libString : "";
        String soutput = Utilities.getNullSafe(attrs, "output");
        boolean output = soutput == null || Boolean.parseBoolean(soutput);
        String id = Utilities.getNullSafe(attrs, "id");
        return new Argument(name, type, cmdArg, defVal, encCodec, libString, specPath, output, id);
    }

    boolean isValidValue(Object value) {
        switch (this.type) {
            case TEXT: {
                return value instanceof String || value == null;
            }
            case FEATURE_TRACK: {
                return value instanceof FeatureTrack;
            }
            case MULTI_FEATURE_TRACK: {
                if (!(value instanceof List)) {
                    return false;
                }
                try {
                    List lVal = (List)value;
                    FeatureTrack fVal = (FeatureTrack)lVal.get(0);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getCmdArg() {
        return this.cmdArg;
    }

    public InputType getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public URL[] getLibURLs() {
        return this.libURLs;
    }

    public boolean isOutput() {
        return this.output;
    }

    public String getId() {
        return this.id;
    }

    public static enum InputType {
        TEXT,
        LONGTEXT,
        FEATURE_TRACK,
        DATA_TRACK,
        MULTI_FEATURE_TRACK,
        ALIGNMENT_TRACK;

    }
}

