/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.charts;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import org.broad.igv.charts.Axis;

class AxisPanel
extends JComponent {
    private static final int TICK_SIZE = 4;
    private static final int TICK_GAP = 2;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    Axis axis;

    AxisPanel() {
    }

    public void setAxisModel(Axis axis) {
        this.axis = axis;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.updateAxisDimension(w, h);
    }

    private void updateAxisDimension(int w, int h) {
        if (this.axis == null) {
            return;
        }
        if (this.axis.getOrientation() == Axis.Orientation.HORIZONTAL) {
            this.axis.setPanelSize(w);
        } else {
            this.axis.setPanelSize(h);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.axis == null) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        FontMetrics fontMetrics = g.getFontMetrics();
        int minusStrWidth = fontMetrics.stringWidth("-") / 2;
        int strHeight = fontMetrics.getHeight();
        boolean top = false;
        int bottom = this.getHeight();
        int width = this.getWidth();
        double[] ticks = this.axis.ticks;
        double tickStart = ticks[0];
        double tickIncrement = ticks[1];
        double labelStep = 1.0;
        if (this.axis.getOrientation() == Axis.Orientation.HORIZONTAL) {
            int strWidth;
            String label;
            int px;
            int tickLabelY = 8 + strHeight;
            double xtick = tickStart;
            do {
                if ((px = this.axis.getPixelForValue(xtick)) > 0 && px < width) {
                    g.drawLine(px, 2, px, 6);
                    label = DECIMAL_FORMAT.format(xtick);
                    if (label.equals("-0")) {
                        label = "0";
                    }
                    if (px > (strWidth = fontMetrics.stringWidth(label)) && px + strWidth < width) {
                        int strPosition = px - strWidth / 2 + 1;
                        if (xtick < 0.0) {
                            strPosition -= minusStrWidth;
                        }
                        g.drawString(label, strPosition, tickLabelY);
                    }
                }
                xtick += tickIncrement;
            } while (px < width);
            label = this.axis.getLabel();
            if (label != null) {
                strWidth = fontMetrics.stringWidth(label);
                int strX = (this.getWidth() - strWidth) / 2;
                g.drawString(label, strX, bottom - 20);
            }
        } else {
            int strWidth;
            String label;
            int py;
            double ytick = tickStart;
            do {
                if ((py = this.axis.getPixelForValue(ytick)) - strHeight > 0 && py < bottom) {
                    g.drawLine(width - 6, py, width - 2, py);
                    label = DECIMAL_FORMAT.format(ytick);
                    if (label.equals("-0")) {
                        label = "0";
                    }
                    strWidth = fontMetrics.stringWidth(label);
                    int strPosition = width - 6 - 4 - strWidth;
                    int tickLabelY = py + strHeight / 2 - 3;
                    g.drawString(label, strPosition, tickLabelY);
                }
                ytick += tickIncrement;
            } while (py > 0);
            label = this.axis.getLabel();
            if (label != null) {
                strWidth = fontMetrics.stringWidth(label);
                int strX = (bottom + strWidth) / 2;
                AffineTransform t = ((Graphics2D)g).getTransform();
                AffineTransform rotateTransform = new AffineTransform();
                rotateTransform.quadrantRotate(-1);
                ((Graphics2D)g).transform(rotateTransform);
                g.drawString(label, -strX, 20);
                ((Graphics2D)g).setTransform(t);
            }
        }
    }
}

